/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.parser.sax.handler;

import com.sonyericsson.fifa.data.OnlineContent;
import com.sonyericsson.fifa.exceptions.InvalidDateException;
import com.sonyericsson.fifa.services.parser.sax.contentprovider.OnlineContentProvider;
import com.sonyericsson.fifa.services.parser.sax.exceptions.RssInvalidFormatException;
import com.sonyericsson.fifa.services.parser.sax.exceptions.RssItemsParsedException;
import com.sonyericsson.fifa.utils.DateConstants;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OnlineContentHandler
extends DefaultHandler
implements OnlineContentProvider {
    private static final String CONTENT_LIST_TAG = "contentList";
    private static final String CONTENT_TAG = "content";
    private static final String PRODUCT_NAME_TAG = "productName";
    private static final String PRODUCT_TYPE_TAG = "productType";
    private static final String DATE_ADDED_TAG = "dateAdded";
    private static final String COMPONENT_TITLE_TAG = "componentTitle";
    private static final String COMPONENT_ARTIST_TAG = "componentArtist";
    private static final String DOWNLOAD_URL_TAG = "downloadURL";
    private static final String DOWNLOAD_FORMAT_TAG = "downloadFormat";
    private static final String PREVIEW_URL_TAG = "previewURL";
    private static final String PREVIEW_FORMAT_TAG = "previewFormat";
    private static final String DOWNLOAD_FILE_SIZE_TAG = "downloadFileSize";
    private Vector parsedContentList;
    private OnlineContent currentContent;
    private String currentElementName;
    private boolean contentListTagAvailable = false;
    private boolean contentTagAvailable = false;
    private boolean productNameTagAvailable = false;
    private boolean productTypeTagAvailable = false;
    private boolean dateAddedTagAvailable = false;
    private boolean componentTitleTagAvailable = false;
    private boolean componentArtistTagAvailable = false;
    private boolean downloadUrlTagAvailable = false;
    private boolean downloadFormatTagAvailable = false;
    private boolean previewUrlTagAvailable = false;
    private boolean previewFormatTagAvailable = false;
    private boolean downloadFileSizeTagAvailable = false;
    private String lastPublishDate = null;

    public void setLastPublishDate(String lastPublishDate) {
        this.lastPublishDate = lastPublishDate;
    }

    public void startElement(String resourceId, String localName, String tagName, Attributes attributes) throws SAXException {
        this.currentElementName = tagName;
        if (!this.contentListTagAvailable) {
            if (CONTENT_LIST_TAG.equalsIgnoreCase(this.currentElementName)) {
                this.contentListTagAvailable = true;
                this.parsedContentList = new Vector();
            } else {
                Logger.logError(this.getClass(), "OnlineContentHandler - startElement - Tag not found");
                throw new RssInvalidFormatException();
            }
        }
        if (this.contentListTagAvailable && !this.contentTagAvailable && CONTENT_TAG.equalsIgnoreCase(this.currentElementName)) {
            this.contentTagAvailable = true;
            this.currentContent = new OnlineContent();
        }
        if (this.contentTagAvailable && !this.productNameTagAvailable && PRODUCT_NAME_TAG.equalsIgnoreCase(this.currentElementName)) {
            this.productNameTagAvailable = true;
        }
        if (this.contentTagAvailable && !this.productTypeTagAvailable && PRODUCT_TYPE_TAG.equalsIgnoreCase(this.currentElementName)) {
            this.productTypeTagAvailable = true;
        }
        if (this.contentTagAvailable && !this.dateAddedTagAvailable && DATE_ADDED_TAG.equalsIgnoreCase(this.currentElementName)) {
            this.dateAddedTagAvailable = true;
        }
        if (this.contentTagAvailable && !this.componentTitleTagAvailable && COMPONENT_TITLE_TAG.equalsIgnoreCase(this.currentElementName)) {
            this.componentTitleTagAvailable = true;
        }
        if (this.contentTagAvailable && !this.componentArtistTagAvailable && COMPONENT_ARTIST_TAG.equalsIgnoreCase(this.currentElementName)) {
            this.componentArtistTagAvailable = true;
        }
        if (this.contentTagAvailable && !this.downloadUrlTagAvailable && DOWNLOAD_URL_TAG.equalsIgnoreCase(this.currentElementName)) {
            this.downloadUrlTagAvailable = true;
        }
        if (this.contentTagAvailable && !this.downloadFormatTagAvailable && DOWNLOAD_FORMAT_TAG.equalsIgnoreCase(this.currentElementName)) {
            this.downloadFormatTagAvailable = true;
        }
        if (this.contentTagAvailable && !this.previewUrlTagAvailable && PREVIEW_URL_TAG.equalsIgnoreCase(this.currentElementName)) {
            this.previewUrlTagAvailable = true;
        }
        if (this.contentTagAvailable && !this.previewFormatTagAvailable && PREVIEW_FORMAT_TAG.equalsIgnoreCase(this.currentElementName)) {
            this.previewFormatTagAvailable = true;
        }
        if (this.contentTagAvailable && !this.downloadFileSizeTagAvailable && DOWNLOAD_FILE_SIZE_TAG.equalsIgnoreCase(this.currentElementName)) {
            this.downloadFileSizeTagAvailable = true;
        }
    }

    public void characters(char[] text, int startingIndex, int textLength) {
        String content = new String(text, startingIndex, textLength).trim();
        if (content.length() > 0) {
            if (PRODUCT_NAME_TAG.equalsIgnoreCase(this.currentElementName)) {
                this.currentContent.setProductName(content);
            }
            if (PRODUCT_TYPE_TAG.equalsIgnoreCase(this.currentElementName)) {
                this.currentContent.setType(content);
            }
            if (DATE_ADDED_TAG.equalsIgnoreCase(this.currentElementName)) {
                this.currentContent.setDateAdded(content);
            }
            if (COMPONENT_TITLE_TAG.equalsIgnoreCase(this.currentElementName)) {
                this.currentContent.setTitle(content);
            }
            if (COMPONENT_ARTIST_TAG.equalsIgnoreCase(this.currentElementName)) {
                this.currentContent.setArtist(content);
            }
            if (DOWNLOAD_URL_TAG.equalsIgnoreCase(this.currentElementName)) {
                this.currentContent.setUrl(String.valueOf(this.currentContent.getUrl()) + content);
            }
            if (DOWNLOAD_FORMAT_TAG.equalsIgnoreCase(this.currentElementName)) {
                this.currentContent.setFormat(content);
            }
            if (PREVIEW_URL_TAG.equalsIgnoreCase(this.currentElementName)) {
                this.currentContent.setPreviewUrl(content);
            }
            if (PREVIEW_FORMAT_TAG.equalsIgnoreCase(this.currentElementName)) {
                this.currentContent.setPreviewFormat(content);
            }
            if (DOWNLOAD_FILE_SIZE_TAG.equalsIgnoreCase(this.currentElementName)) {
                try {
                    int size = Integer.valueOf(content);
                    this.currentContent.setFileSize(size);
                }
                catch (NumberFormatException e) {
                    Logger.logInfo(this.getClass(), "Unexpected Exception to convert file size to integer.");
                }
            }
        }
    }

    private void assertContentIsNew() throws RssItemsParsedException {
        if (this.currentContent != null && this.currentContent.getDateAdded() != null && this.lastPublishDate != null && !this.isCurrentDateNewer(this.currentContent.getDateAdded(), this.lastPublishDate)) {
            throw new RssItemsParsedException();
        }
    }

    public void endElement(String resourceId, String localName, String qName) throws SAXException {
        if (this.currentElementName != null && CONTENT_TAG.equalsIgnoreCase(qName)) {
            if (this.currentContent != null && this.parsedContentList != null && this.isContentValid(this.currentContent)) {
                this.assertContentIsNew();
                this.parsedContentList.addElement(this.currentContent);
            }
            this.currentContent = null;
            this.contentTagAvailable = false;
            this.productNameTagAvailable = false;
            this.productTypeTagAvailable = false;
            this.dateAddedTagAvailable = false;
            this.componentTitleTagAvailable = false;
            this.componentArtistTagAvailable = false;
            this.downloadUrlTagAvailable = false;
            this.downloadFormatTagAvailable = false;
            this.previewUrlTagAvailable = false;
            this.previewFormatTagAvailable = false;
            this.downloadFileSizeTagAvailable = false;
        }
    }

    private boolean isContentValid(OnlineContent content) {
        boolean valid = false;
        if (content.getUrl() != null && content.getTitle() != null && content.getFormat() != null && content.getPreviewFormat() != null) {
            valid = true;
        }
        return valid;
    }

    public void endDocument() throws SAXException {
        if (this.parsedContentList != null) {
            this.contentListTagAvailable = false;
        }
    }

    public Vector getOnlineContentList() {
        return this.parsedContentList;
    }

    private boolean isCurrentDateNewer(String currentDate, String lastDate) {
        boolean currentIsNewer = false;
        if (currentDate != null) {
            if (lastDate != null) {
                try {
                    Date current = new Date(currentDate);
                    Date last = new Date(lastDate);
                    if (current.year > last.year || current.year == last.year && current.month > last.month || current.year == last.year && current.month == last.month && current.day > last.day) {
                        currentIsNewer = true;
                    }
                }
                catch (Exception e) {
                    Logger.logInfo(this.getClass(), "Date is in wrong format, currentDate: " + currentDate + ", lastDate: " + lastDate + ".");
                }
            } else {
                currentIsNewer = true;
            }
        }
        return currentIsNewer;
    }

    static class Date {
        int day;
        int month;
        int year;

        public Date(String date) throws Exception {
            if (date == null) {
                throw new InvalidDateException();
            }
            int firstTag = date.indexOf(32);
            int lastTag = date.lastIndexOf(32);
            String d = date.substring(0, firstTag);
            this.day = Integer.valueOf(d);
            String m = date.substring(firstTag + 1, lastTag);
            this.month = DateConstants.getMonthOfYear(m);
            String y = date.substring(lastTag + 1, date.length());
            this.year = Integer.valueOf(y);
        }
    }
}

