/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.parser.sax.handler;

import com.sonyericsson.fifa.data.TeamLinks;
import com.sonyericsson.fifa.services.parser.sax.contentprovider.TeamsContentProvider;
import com.sonyericsson.fifa.services.parser.sax.exceptions.RssInvalidFormatException;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TeamsHandler
extends DefaultHandler
implements TeamsContentProvider {
    private static final String NEWSTEAMSLINKS_TAG = "NEWSTEAMSLINKS";
    private static final String ITEM_TAG = "item";
    private static final String ITEM_COUNTRYCODE_ATTRIBUTE = "countrycode";
    private static final String ITEM_NEWSFEED_ATTRIBUTE = "newsfeed";
    private boolean xmlStartedCorrectly;
    private String teamCode;
    private TeamLinks teamLinks;
    private Hashtable teamLinksTable;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String resourceId, String localName, String tagName, Attributes attributes) throws SAXException {
        if (this.xmlStartedCorrectly) {
            if (!this.xmlStartedCorrectly || !ITEM_TAG.equals(tagName) || this.teamLinks != null) throw new RssInvalidFormatException();
            if (attributes == null) return;
            this.parseItem(attributes);
            return;
        } else if (NEWSTEAMSLINKS_TAG.equals(tagName)) {
            this.xmlStartedCorrectly = true;
            return;
        } else {
            Logger.logError(this.getClass(), "Error on parsing news teams links XML - Not started correctly");
            throw new RssInvalidFormatException();
        }
    }

    public void endElement(String resourceId, String localName, String qName) throws SAXException {
        if (this.xmlStartedCorrectly) {
            if (ITEM_TAG.equals(qName) && this.teamCode != null && this.teamLinks != null) {
                this.getTeamLinks().put(this.teamCode, this.teamLinks);
                this.teamLinks = null;
                this.teamCode = null;
            } else if (NEWSTEAMSLINKS_TAG.equals(qName)) {
                this.xmlStartedCorrectly = false;
            }
        } else {
            throw new RssInvalidFormatException();
        }
    }

    private void parseItem(Attributes attributes) throws SAXException {
        int numberOfAttributes = attributes.getLength();
        this.teamLinks = new TeamLinks();
        int i = 0;
        while (i < numberOfAttributes) {
            String attributeName = attributes.getQName(i).trim();
            String attributeValue = attributes.getValue(i).trim();
            if (attributeValue != null && !"".equals(attributeValue)) {
                if (ITEM_COUNTRYCODE_ATTRIBUTE.equalsIgnoreCase(attributeName)) {
                    this.teamCode = attributeValue;
                } else if (ITEM_NEWSFEED_ATTRIBUTE.equalsIgnoreCase(attributeName)) {
                    this.teamLinks.setLatestNewsUrl(attributeValue);
                }
            }
            ++i;
        }
        if (this.teamCode == null || this.teamLinks.getLatestNewsUrl() == null) {
            Logger.logError(this.getClass(), "Warning - parsing news team links XML - Item does not contain required attributes");
        }
    }

    public Hashtable getTeamLinks() {
        if (this.teamLinksTable == null) {
            this.teamLinksTable = new Hashtable();
        }
        return this.teamLinksTable;
    }
}

