/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.utils;

import com.sonyericsson.fifa.exceptions.NoDiskSpaceException;
import com.sonyericsson.fifa.utils.FeedFileCleaner;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;

public class Configuration {
    private static final String TEAM_LIST_XML_PREFIX = "/newsteamslinks_";
    private static final String TEAM_LIST_XML_SUFFIX = ".xml";
    public static final String PRELOADED_CONTENT_XML = "/preloadedContent.xml";
    public static final String TEAM_LIST_XML = "/newsteamslinks_en.xml";
    public static final String CONF_LINKS_XML = "/confLinks.xml";
    public static final String RECORDSTORE_NAME_FIFA = "/fifa_config";
    public static final String DEFAULT_LANGUAGE = "en";
    public static final int MINIMUN_FS_FOR_UPDATE = 250000;
    public static final int MINIMUN_STORAGE_FOR_UPDATE = 15000;
    public static final int OSE_PLATFORM = 0;
    public static final int SYMBIAN_PLATFORM = 1;
    public static final int EMULATOR_PLATFORM = 2;
    public static final String OSE_PICTURES_FOLDER = "/img_wqvga/";
    public static final String SYMBIAN_PICTURES_FOLDER = "/img_nhd/";
    public static final String EMULATOR_PICTURES_FOLDER = "/img_wqvga/";
    public static final String MOBILE_OSE_DOWNLOAD_IMAGES_DIRECTORY = System.getProperty("fileconn.dir.private");
    public static final String MOBILE_SYMBIAN_DOWNLOAD_IMAGES_DIRECTORY = String.valueOf(System.getProperty("fileconn.dir.graphics")) + "fifa/";
    public static final String MOBILE_MEMORYCARD_FOLDER = System.getProperty("fileconn.dir.memorycard");
    public static final String MOBILE_VIDEOS_FOLDER = System.getProperty("fileconn.dir.videos");
    public static final String MOBILE_SYMBIAN_VIDEOS_FOLDER_NAME = "Videos/";
    public static final String MOBILE_OSE_VIDEOS_FOLDER_NAME = "video/";
    public static final String FIFA_DEFAULT_FOLDER = "fifa";
    public static final String EMULATOR_VIDEOS_FOLDER = "/video/";
    public static final String EMULATOR_DOWNLOAD_IMAGES_DIRECTORY = "file:///c:/image/";
    public static final boolean avoidNetworkChecks = false;
    public static final String EXTRA_VIDEOS_URL = "http://im46.com/wap/plugin/contentListXML.action?jobId=4716";
    public static final String EMULATOR_EXTRA_VIDEOS_URL = "/extra_videos.xml";
    private static volatile Configuration configuration = null;
    private static boolean BACKGROUND_MODE = false;
    static /* synthetic */ Class class$0;

    public static final Configuration getInstance() {
        if (configuration == null) {
            configuration = new Configuration();
        }
        return configuration;
    }

    public static synchronized boolean isBackgroundMode() {
        if (BACKGROUND_MODE) {
            BACKGROUND_MODE = false;
            return true;
        }
        return BACKGROUND_MODE;
    }

    public static synchronized void setBackgroundMode(boolean value) {
        BACKGROUND_MODE = value;
    }

    public String getTeamCode(String teamName) {
        String code = null;
        return code;
    }

    public String getFeedUrl(String teamCode) {
        String feedUrl = null;
        return feedUrl;
    }

    public String getExtraVideosUrl() {
        String url = null;
        url = SystemProperties.getPhonePlatform() == 3 ? EMULATOR_EXTRA_VIDEOS_URL : EXTRA_VIDEOS_URL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Logger.logInfo(clazz, "getExtraVideosUrl: " + url);
        return url;
    }

    public String getPreloadedVideosDirectory() {
        String directory = null;
        directory = SystemProperties.getPhonePlatform() == 3 ? EMULATOR_VIDEOS_FOLDER : MOBILE_VIDEOS_FOLDER;
        return directory;
    }

    public String getPreloadedMemoryVideosDirectory() {
        String directory = null;
        if (SystemProperties.getPhonePlatform() == 3) {
            directory = EMULATOR_VIDEOS_FOLDER;
        } else if (SystemProperties.getPhonePlatform() == 0 || SystemProperties.getPhonePlatform() == 1) {
            directory = String.valueOf(MOBILE_MEMORYCARD_FOLDER) + MOBILE_OSE_VIDEOS_FOLDER_NAME;
        } else if (SystemProperties.getPhonePlatform() == 2) {
            directory = String.valueOf(MOBILE_MEMORYCARD_FOLDER) + MOBILE_SYMBIAN_VIDEOS_FOLDER_NAME;
        }
        return directory;
    }

    public String getFilePathForDownloadableVideo(String type, String title, int size) throws NoDiskSpaceException {
        Class<?> clazz;
        String filePath = "";
        if (title != null && type != null && (type.indexOf("3gp") != -1 || type.indexOf("3GP") != -1)) {
            filePath = title.trim();
            filePath = filePath.replace(' ', '_');
            filePath = String.valueOf(filePath) + ".3gp";
            filePath = String.valueOf(this.getFilePathForVideoDownloads(size)) + filePath;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Logger.logInfo(clazz, "filePath" + filePath);
        return filePath;
    }

    public String getTeamListXML(String language) {
        Class<?> clazz;
        String xmlFileName = TEAM_LIST_XML;
        if (this.isFeedLanguageAvailable(language) && FifaResources.checkLanguageAvailability(language)) {
            xmlFileName = TEAM_LIST_XML_PREFIX + language + TEAM_LIST_XML_SUFFIX;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Logger.logInfo(clazz, "updateTeamList() | xml = " + xmlFileName);
        return xmlFileName;
    }

    public String getFilePathForVideoDownloads(int videoSize) throws NoDiskSpaceException {
        try {
            IOUtility.assertCardSpaceAvailable(videoSize);
            return this.getPreloadedMemoryVideosDirectory();
        }
        catch (NoDiskSpaceException e) {
            IOUtility.assertMemorySpaceAvailable(videoSize);
            return this.getPreloadedVideosDirectory();
        }
    }

    public boolean isFeedLanguageAvailable(String language) {
        String filePath = TEAM_LIST_XML_PREFIX + language + TEAM_LIST_XML_SUFFIX;
        return IOUtility.isResourceFileAvailable(filePath);
    }

    public String getFeedsLanguage(String lastFeedsLanguage) {
        Class<?> clazz;
        String currentLanguage = FifaResources.getLanguage().getCurrentLocale();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.sonyericsson.fifa.utils.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Logger.logInfo(clazz2, "checkFeedsLanguage | current lang = " + currentLanguage + " | old lang = " + lastFeedsLanguage);
        if (!currentLanguage.equalsIgnoreCase(lastFeedsLanguage)) {
            if (this.isFeedLanguageAvailable(currentLanguage)) {
                FeedFileCleaner.getInstance().deleteAllFeeds();
            } else if (!lastFeedsLanguage.equalsIgnoreCase(DEFAULT_LANGUAGE)) {
                FeedFileCleaner.getInstance().deleteAllFeeds();
                currentLanguage = DEFAULT_LANGUAGE;
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Logger.logInfo(clazz, "checkFeedsLanguage | returning currentLanguage for feeds = " + currentLanguage);
        return currentLanguage;
    }
}

