/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.utils;

import com.sonyericsson.fifa.data.OnlineContent;
import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.data.feed.FeedListener;
import com.sonyericsson.fifa.datastore.FeedDB;
import com.sonyericsson.fifa.datastore.TeamLatestNewsDB;
import com.sonyericsson.fifa.model.onlineContent.OnlineContentList;
import com.sonyericsson.fifa.utils.FeedUtility;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class FeedFileCleaner
implements FeedListener {
    private static final Hashtable protectedFiles = new Hashtable();
    private static final Vector allFiles = new Vector();
    private static final String ALL_FILES = "*";
    private static String rootFolder = FeedUtility.getInstance().getDownloadImageDirectory();
    private static boolean isCleanerRunning = false;
    private static Object lock = new Object();
    private static FeedFileCleaner cleanerInstance = new FeedFileCleaner();
    static /* synthetic */ Class class$0;

    public static FeedFileCleaner getInstance() {
        return cleanerInstance;
    }

    private void addProtectedFeed(Feed newFeed) {
        if (newFeed != null) {
            Vector items = newFeed.getItems();
            int size = items.size();
            int i = 0;
            while (i < size) {
                this.put(((FeedItem)items.elementAt(i)).getEnclosure().getPath(), true);
                this.put(((FeedItem)items.elementAt(i)).getEnclosure().getThumbPath(), true);
                ++i;
            }
        }
    }

    public void cleanUpFeedFiles() {
        FeedDB db = null;
        Vector teams = FeedDB.retrieveTeamsWithFeeds();
        int teamsSize = teams.size();
        int i = 0;
        while (i < teamsSize) {
            Feed feed;
            String team = (String)teams.elementAt(i);
            if (team != null && (feed = (db = new FeedDB(team)).retrieveFeed()) != null) {
                this.addProtectedFeed(feed);
            }
            ++i;
        }
        Enumeration onlineContentList = new OnlineContentList().getOnlineContentList();
        while (onlineContentList.hasMoreElements()) {
            OnlineContent onlineContent = (OnlineContent)onlineContentList.nextElement();
            this.put(onlineContent.getPreviewPath(), true);
        }
        Vector files = this.filterFiles(rootFolder, ALL_FILES);
        int filteredSize = files.size();
        int i2 = 0;
        while (i2 < filteredSize) {
            String path = (String)files.elementAt(i2);
            boolean protect = this.get(path);
            if (!protect) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.sonyericsson.fifa.utils.FeedFileCleaner");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logInfo(clazz, "[BALDE] cleanUpFeedFiles | DELETE = " + path);
                IOUtility.deleteFiles(path);
            }
            ++i2;
        }
    }

    public void deleteAllFeeds() {
        FeedDB db = null;
        TeamLatestNewsDB latestNewsDB = null;
        Vector teams = FeedDB.retrieveTeamsWithFeeds();
        int teamsSize = teams.size();
        int i = 0;
        while (i < teamsSize) {
            String team = (String)teams.elementAt(i);
            if (team != null) {
                db = new FeedDB(team);
                db.deleteRecordStore();
                latestNewsDB = new TeamLatestNewsDB(team);
                latestNewsDB.deleteRecordStore();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String filePath, boolean protect) {
        Hashtable hashtable = protectedFiles;
        synchronized (hashtable) {
            if (filePath != null) {
                protectedFiles.put(filePath, new Boolean(protect));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean get(String key) {
        Hashtable hashtable = protectedFiles;
        synchronized (hashtable) {
            Object obj = protectedFiles.get(key);
            if (obj != null) {
                return (Boolean)obj;
            }
            return false;
        }
    }

    public void recreateFilesRootFolder() {
        block16: {
            FileConnection fc = null;
            try {
                try {
                    fc = (FileConnection)Connector.open((String)rootFolder);
                    if (fc.exists()) {
                        IOUtility.deleteFiles(rootFolder);
                    }
                }
                catch (IOException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.FeedFileCleaner");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logInfo(clazz, "recreateFilesRootFolder | IOException e = " + e + " | " + e.getMessage());
                    if (fc == null) break block16;
                    try {
                        fc.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fc != null) {
                    try {
                        fc.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void enclosureDownloaded(int index, Enclosure enclosure) {
        if (enclosure != null) {
            this.put(enclosure.getPath(), true);
            this.put(enclosure.getThumbPath(), true);
        }
    }

    public void enclosureDownloadFailed(int index, byte reason) {
    }

    private Vector filterFiles(String path, String filter) {
        if (path != null) {
            Enumeration files = null;
            FileConnection fileConnection = null;
            try {
                try {
                    fileConnection = (FileConnection)Connector.open((String)path, (int)3);
                    if (fileConnection.exists()) {
                        if (fileConnection.isDirectory()) {
                            files = fileConnection.list(filter, true);
                            while (files.hasMoreElements()) {
                                this.filterFiles(String.valueOf(path) + (String)files.nextElement(), filter);
                            }
                        } else {
                            allFiles.addElement(fileConnection.getURL());
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        fileConnection.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    fileConnection.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return allFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFeedFilesCleanUp() {
        Thread cleanerThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FeedFileCleaner.this.cleanUpFeedFiles();
                Object object = lock;
                synchronized (object) {
                    isCleanerRunning = false;
                }
            }
        };
        cleanerThread.setPriority(1);
        Object object = lock;
        synchronized (object) {
            if (!isCleanerRunning) {
                isCleanerRunning = true;
                cleanerThread.start();
            }
        }
    }
}

