/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.utils;

import com.sonyericsson.fifa.utils.Configuration;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.SystemProperties;
import java.io.IOException;

public class FeedUtility {
    public static final String THUMB_FILE_PREFIX = "thumb_";
    public static final String PREVIEW_THUMBNAILS_FOLDER = "Fifa_Previews";
    private String preloadedImagesDirectory;
    private static FeedUtility utility = null;

    public static FeedUtility getInstance() {
        if (utility == null) {
            utility = new FeedUtility();
        }
        return utility;
    }

    public String getFilePathForDownload(String httpAddress, String teamCode) {
        String filePath = String.valueOf(this.getDownloadImageDirectory()) + teamCode + "/";
        try {
            IOUtility.createDirectories(filePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int beginIndex = httpAddress.lastIndexOf(47);
        String httpAddressString = SystemProperties.removeTrashCharacters(httpAddress.substring(beginIndex + 1));
        filePath = String.valueOf(filePath) + httpAddressString;
        return filePath;
    }

    public String getFilePathForThumbnail(String enclosurePath) {
        int beginIndex = enclosurePath.lastIndexOf(47);
        String fileName = enclosurePath.substring(beginIndex + 1);
        String folder = enclosurePath.substring(0, beginIndex + 1);
        String filePath = String.valueOf(folder) + THUMB_FILE_PREFIX + fileName;
        return filePath;
    }

    public String getFilePathForPreviewThumbnails(String url, String type) {
        String filePath = String.valueOf(this.getFilePathForDownload(url, PREVIEW_THUMBNAILS_FOLDER)) + this.getExtensionForMimeType(type);
        return filePath;
    }

    public String getExtensionForMimeType(String mime) {
        String extension = null;
        if (mime.indexOf("jpeg") != -1 || mime.indexOf("JPEG") != -1 || mime.indexOf("jpg") != -1 || mime.indexOf("JPG") != -1) {
            extension = ".jpg";
        } else if (mime.indexOf("gif") != -1 || mime.indexOf("GIF") != -1) {
            extension = ".gif";
        }
        return extension;
    }

    public String getDownloadImageDirectory() {
        switch (SystemProperties.getPhonePlatform()) {
            case 3: {
                return "file:///c:/image/";
            }
            case 0: 
            case 1: {
                return Configuration.MOBILE_OSE_DOWNLOAD_IMAGES_DIRECTORY;
            }
            case 2: {
                try {
                    IOUtility.createDirectories(Configuration.MOBILE_SYMBIAN_DOWNLOAD_IMAGES_DIRECTORY);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return Configuration.MOBILE_SYMBIAN_DOWNLOAD_IMAGES_DIRECTORY;
            }
        }
        return this.getPreloadedImagesDirectory();
    }

    public String getPreloadedImagesDirectory() {
        if (this.preloadedImagesDirectory == null) {
            switch (SystemProperties.getPhonePlatform()) {
                case 3: {
                    this.preloadedImagesDirectory = "/img_wqvga/";
                    break;
                }
                case 0: 
                case 1: {
                    this.preloadedImagesDirectory = "/img_wqvga/";
                    break;
                }
                case 2: {
                    this.preloadedImagesDirectory = "/img_nhd/";
                }
            }
        }
        return this.preloadedImagesDirectory;
    }
}

