/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.utils;

import com.nokia.mid.iapinfo.AccessPoint;
import com.nokia.mid.iapinfo.DestinationNetwork;
import com.nokia.mid.iapinfo.IAPInfo;
import com.nokia.mid.iapinfo.IAPInfoException;
import com.sonyericsson.ams.Application;
import com.sonyericsson.ams.ApplicationManager;
import com.sonyericsson.fifa.exceptions.FileAlreadyDownloadedException;
import com.sonyericsson.fifa.exceptions.NoDiskSpaceException;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.RunConnection;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import com.sun.lwuit.Image;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.imageeffect.ImageTransformControl;
import javax.microedition.content.ContentHandler;
import javax.microedition.content.Registry;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.MediaException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class IOUtility {
    public static final String FIFA_DIR = String.valueOf(System.getProperty("fileconn.dir.videos")) + "fifa/";
    public static final String FS_LOCATOR = "file:///";
    public static final String HTTP_LOCATOR = "http:";
    public static final String MOBILE_PATH = "c:/";
    public static final String MEMORY_CARD_PATH = "e:/";
    private static final String VALIDATE_LINK = "http://google.com";
    private static final String LAN_BEARER = "LANBearer";
    private static final String LAN_SERVICE = "LANService";
    private static final String CHAPI_ACTION = "openFootballFan";
    private static final String RESOURCES_TEAM_FLAG_SUFIX = "_TEAM.png";
    private static final long OPEN_INPUT_STREAM_TIMEOUT = 15000L;
    private static final int MAX_INPUTSTREAM_READER_RETRIES = 3;
    static /* synthetic */ Class class$0;

    public static void deleteFiles(String path) {
        block14: {
            if (path != null) {
                Enumeration files = null;
                FileConnection fileConnection = null;
                try {
                    try {
                        fileConnection = (FileConnection)Connector.open((String)path, (int)3);
                        if (!fileConnection.exists()) break block14;
                        if (fileConnection.isDirectory()) {
                            files = fileConnection.list("*", true);
                            while (files.hasMoreElements()) {
                                IOUtility.deleteFiles(String.valueOf(path) + (String)files.nextElement());
                            }
                            fileConnection.delete();
                            break block14;
                        }
                        fileConnection.delete();
                    }
                    catch (IOException iOException) {
                        try {
                            fileConnection.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        fileConnection.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void copyFile(String source, String destination) throws IOException {
        int n;
        InputStream is = null;
        FileConnection fc = null;
        OutputStream os = null;
        is = Connector.openInputStream((String)source);
        fc = (FileConnection)Connector.open((String)destination);
        if (fc.exists()) {
            fc.delete();
        }
        fc.create();
        os = fc.openOutputStream();
        byte[] buffer = new byte[10000];
        while ((n = is.read(buffer)) != -1) {
            os.write(buffer, 0, n);
        }
        is.close();
        os.flush();
        os.close();
        fc.close();
    }

    public static void createDirectories(String fullDirPath) throws IOException {
        FileConnection createDirectory = (FileConnection)Connector.open((String)fullDirPath);
        if (!createDirectory.exists()) {
            createDirectory.mkdir();
            createDirectory.setHidden(true);
            createDirectory.close();
        }
    }

    public static OutputStream createFileAndOpen(String filePath) throws NoDiskSpaceException, FileAlreadyDownloadedException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Logger.logInfo(clazz, "createFileAndOpen: " + filePath);
        try {
            FileConnection fc = (FileConnection)Connector.open((String)filePath);
            if (fc.exists()) {
                throw new FileAlreadyDownloadedException();
            }
            fc.create();
            OutputStream output = fc.openOutputStream();
            return output;
        }
        catch (IOException e) {
            throw new NoDiskSpaceException();
        }
    }

    public static void saveByteAsFile(byte[] data, String filePath) {
        if (filePath != null && data != null && data.length > 0) {
            FilterOutputStream output = null;
            FileConnection fileConnector = null;
            try {
                try {
                    fileConnector = (FileConnection)Connector.open((String)filePath);
                    if (!fileConnector.exists()) {
                        fileConnector.create();
                    }
                    output = fileConnector.openDataOutputStream();
                    ((DataOutputStream)output).write(data, 0, data.length);
                    ((DataOutputStream)output).flush();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (fileConnector != null) {
                            fileConnector.close();
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    try {
                        if (fileConnector != null) {
                            fileConnector.close();
                        }
                    }
                    catch (IOException iOException3) {}
                }
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileConnector != null) {
                        fileConnector.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static OutputStream openOutputStream(String filePath) {
        OutputStream output = null;
        if (filePath != null) {
            FileConnection fileConnector = null;
            try {
                fileConnector = (FileConnection)Connector.open((String)filePath);
                if (!fileConnector.exists()) {
                    fileConnector.create();
                }
                output = fileConnector.openOutputStream();
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream openInputStream(String locator) throws IOException {
        InputStream is = null;
        if (locator == null) return is;
        if (!locator.startsWith(HTTP_LOCATOR)) return IOUtility.openFileInputStream(locator);
        RunConnection runConn = new RunConnection(locator, 15000L);
        runConn.go();
        if (!runConn.isSuccessfull()) throw new IOException();
        return runConn.getInputStream();
    }

    public static InputStream openFileInputStream(String filePath) throws IOException {
        InputStream is = null;
        if (filePath != null && filePath.startsWith(FS_LOCATOR)) {
            FileConnection fc = (FileConnection)Connector.open((String)filePath);
            if (fc != null) {
                is = fc.openInputStream();
                fc.close();
            }
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            is = clazz.getResourceAsStream(filePath);
        }
        return is;
    }

    public static String searchApplicationId(String applicationName) {
        Class<?> clazz;
        String applicationId = null;
        ContentHandler[] contentHandler = IOUtility.getGameList();
        int pos = 0;
        while (pos < contentHandler.length) {
            if (contentHandler[pos].getAppName().equalsIgnoreCase(applicationName)) {
                applicationId = contentHandler[pos].getID();
                break;
            }
            ++pos;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Logger.logError(clazz, "IOUTILITY APPLICATIONID: " + applicationId);
        return applicationId;
    }

    public static InputStream getImageFromRES(String filePath) throws IOException {
        InputStream is = null;
        if (filePath != null) {
            filePath = String.valueOf(FifaResources.getImageFolder()) + filePath;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            is = clazz.getResourceAsStream(filePath);
        }
        return is;
    }

    public static Image getFlagImageFromRES(String teamCode) {
        Image img = null;
        try {
            img = Image.createImage(IOUtility.getImageFromRES(String.valueOf(teamCode) + RESOURCES_TEAM_FLAG_SUFIX));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return img;
    }

    public static void resizeImage(String imageFilePath, String thumbImagePath, int width, int height) throws MediaException, IOException {
        if (imageFilePath != null && thumbImagePath != null && width > 0 && height > 0) {
            int retry = 0;
            InputStream imageFileIS = null;
            InputStreamReader reader = null;
            ByteArrayOutputStream outputStream = null;
            try {
                try {
                    imageFileIS = IOUtility.openFileInputStream(imageFilePath);
                    if (imageFileIS != null) {
                        outputStream = new ByteArrayOutputStream();
                        reader = new InputStreamReader(imageFileIS);
                        while (retry < 3 && !reader.ready()) {
                            try {
                                Thread.sleep(20L);
                                ++retry;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (reader.ready()) {
                            MediaProcessor mediaProc = GlobalManager.createMediaProcessor((String)"image/jpeg");
                            mediaProc.setInput(imageFileIS, -1);
                            mediaProc.setOutput((OutputStream)outputStream);
                            ImageTransformControl imgTransformCtrl = (ImageTransformControl)mediaProc.getControl("javax.microedition.amms.control.imageeffect.ImageTransformControl");
                            imgTransformCtrl.setTargetSize(width, height, 0);
                            imgTransformCtrl.setEnforced(true);
                            imgTransformCtrl.setEnabled(true);
                            mediaProc.complete();
                            IOUtility.saveByteAsFile(outputStream.toByteArray(), thumbImagePath);
                        }
                    }
                }
                catch (IOException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logInfo(clazz, "IOException: " + e.getMessage());
                    throw e;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logError(clazz, "IOException: " + e.getMessage());
                }
                try {
                    if (imageFileIS != null) {
                        imageFileIS.close();
                    }
                }
                catch (IOException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logError(clazz, "IOException: " + e.getMessage());
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logError(clazz, "IOException: " + e.getMessage());
                }
                throw throwable;
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "IOException: " + e.getMessage());
            }
            try {
                if (imageFileIS != null) {
                    imageFileIS.close();
                }
            }
            catch (IOException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "IOException: " + e.getMessage());
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "IOException: " + e.getMessage());
            }
        }
    }

    public static void assertFileDoesntExist(String filePath) throws FileAlreadyDownloadedException {
        block24: {
            FileConnection fc = null;
            InputStream is = null;
            try {
                try {
                    if (filePath == null) break block24;
                    if (filePath.startsWith(FS_LOCATOR)) {
                        fc = (FileConnection)Connector.open((String)filePath);
                        if (fc.exists()) {
                            throw new FileAlreadyDownloadedException();
                        }
                        break block24;
                    }
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((is = clazz.getResourceAsStream(filePath)) != null) {
                        throw new FileAlreadyDownloadedException();
                    }
                }
                catch (IOException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logError(clazz, "IOException: " + e.getMessage());
                    try {
                        if (fc != null) {
                            fc.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    if (fc != null) {
                        fc.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isMemoryAvailable() {
        boolean memoryAvailable = false;
        try {
            long availablePhoneMemory = IOUtility.getMobileFreeSpace();
            RecordStore rs = RecordStore.openRecordStore((String)"/fifa_config", (boolean)true);
            int storageAvailable = rs.getSizeAvailable();
            rs.closeRecordStore();
            if (availablePhoneMemory >= 250000L && storageAvailable >= 15000) {
                memoryAvailable = true;
            }
        }
        catch (IOException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, "IOException: " + e.getMessage());
        }
        catch (RecordStoreFullException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, "RecordStoreFullException: " + e.getMessage());
        }
        catch (RecordStoreNotFoundException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, "RecordStoreNotFoundException: " + e.getMessage());
        }
        catch (RecordStoreException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, "RecordStoreException: " + e.getMessage());
        }
        return memoryAvailable;
    }

    public static boolean isMemoryAvailableInCardOrPhone(int size) {
        boolean memoryAvailable = false;
        try {
            IOUtility.assertCardSpaceAvailable(size);
            memoryAvailable = true;
        }
        catch (NoDiskSpaceException e) {
            try {
                IOUtility.assertMemorySpaceAvailable(size);
                memoryAvailable = true;
            }
            catch (NoDiskSpaceException e1) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logInfo(clazz, "No memory space available: " + size);
            }
        }
        return memoryAvailable;
    }

    public static long getMobileFreeSpace() throws IOException {
        long free = -1L;
        FileConnection fc = (FileConnection)Connector.open((String)"file:///c:/");
        if (fc != null) {
            free = fc.availableSize();
            fc.close();
        }
        return free;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getMemoryCardFreeSpace() {
        long free = -1L;
        FileConnection fc = null;
        try {
            try {
                fc = (FileConnection)Connector.open((String)"file:///e:/");
                free = fc.availableSize();
                return free;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fc == null) return free;
                try {
                    fc.close();
                    return free;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return free;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                if (fc == null) return free;
                try {
                    fc.close();
                    return free;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return free;
            }
        }
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void assertMemorySpaceAvailable(long space) throws NoDiskSpaceException {
        try {
            if (IOUtility.getMobileFreeSpace() < space) {
                throw new NoDiskSpaceException();
            }
        }
        catch (IOException e) {
            throw new NoDiskSpaceException();
        }
    }

    public static void assertCardSpaceAvailable(long space) throws NoDiskSpaceException {
        if (IOUtility.getMemoryCardFreeSpace() < space) {
            throw new NoDiskSpaceException();
        }
    }

    public static boolean hasNetworkingConnection() {
        boolean hasNetwork = false;
        try {
            HttpConnection connection = (HttpConnection)Connector.open((String)VALIDATE_LINK, (int)1, (boolean)true);
            if (connection != null) {
                if (SystemProperties.getPhonePlatform() == 2) {
                    connection.getResponseCode();
                }
                hasNetwork = true;
                connection.close();
            }
        }
        catch (Exception e) {
            hasNetwork = false;
        }
        return hasNetwork;
    }

    public static boolean hasInternetSettings() {
        if (IOUtility.getAccessPoint() == null) {
            try {
                HttpConnection connection = (HttpConnection)Connector.open((String)VALIDATE_LINK, (int)1, (boolean)true);
                if (connection != null) {
                    if (SystemProperties.getPhonePlatform() == 2) {
                        connection.getResponseCode();
                    }
                    connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return IOUtility.getAccessPoint() != null;
        }
        return true;
    }

    private static AccessPoint getAccessPoint() {
        AccessPoint ap;
        block5: {
            ap = null;
            try {
                if (SystemProperties.getPhonePlatform() == 2) {
                    DestinationNetwork[] dns = IAPInfo.getIAPInfo().getDestinationNetworks();
                    int i = 0;
                    while (i < dns.length) {
                        ap = IOUtility.getAccessPoint(dns[i]);
                        if (ap == null) {
                            ++i;
                            continue;
                        }
                        break block5;
                    }
                    break block5;
                }
                ap = IOUtility.getAccessPoint(null);
            }
            catch (IAPInfoException iAPInfoException) {
                // empty catch block
            }
        }
        return ap;
    }

    private static AccessPoint getAccessPoint(DestinationNetwork dns) throws IAPInfoException {
        AccessPoint[] aps = null;
        if (dns != null) {
            aps = dns.getAccessPoints();
        } else {
            IAPInfo iapInfo = IAPInfo.getIAPInfo();
            if (iapInfo != null) {
                aps = iapInfo.getConnectionPreferences();
            }
        }
        if (aps != null) {
            int i = 0;
            while (i < aps.length) {
                if (dns != null && aps[i] != null) {
                    return aps[i];
                }
                if (!IOUtility.isLocalConnection(aps[i])) {
                    return aps[i];
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean isLocalConnection(AccessPoint ap) {
        return ap.getBearerType().equals(LAN_BEARER) && ap.getServiceType().equals(LAN_SERVICE);
    }

    public static boolean isFileAvailable(String filePath) {
        boolean result;
        block38: {
            result = false;
            FileConnection fc = null;
            try {
                fc = (FileConnection)Connector.open((String)filePath);
                if (fc.exists()) {
                    result = true;
                }
            }
            catch (IOException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logInfo(clazz, "Excetion on isFileAvailable: " + e.getMessage());
                e.printStackTrace();
                try {
                    if (fc != null) {
                        fc.close();
                    }
                    break block38;
                }
                catch (IOException e2) {
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logInfo(clazz2, "IOExcetion to close file: " + e2.getMessage());
                }
                break block38;
            }
            catch (Exception e) {
                try {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logInfo(clazz, "Excetion on isFileAvailable: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        if (fc != null) {
                            fc.close();
                        }
                    }
                    catch (IOException e3) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Logger.logInfo(clazz, "IOExcetion to close file: " + e3.getMessage());
                    }
                    throw throwable;
                }
                try {
                    if (fc != null) {
                        fc.close();
                    }
                    break block38;
                }
                catch (IOException e4) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logInfo(clazz, "IOExcetion to close file: " + e4.getMessage());
                }
                break block38;
            }
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logInfo(clazz, "IOExcetion to close file: " + e.getMessage());
            }
        }
        return result;
    }

    public static boolean isResourceFileAvailable(String filePath) {
        boolean result = false;
        try {
            InputStream in;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.utils.IOUtility");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((in = clazz.getResourceAsStream(filePath)) != null) {
                result = true;
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Application getJavaApplication(String appName) {
        Application result = null;
        Application[] instaledApps = null;
        try {
            instaledApps = ApplicationManager.getApplicationManager().getApplications();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (instaledApps != null && instaledApps.length != 0) {
            int i = 0;
            while (i < instaledApps.length) {
                if (instaledApps[i].getSuiteName().equals(appName)) {
                    result = instaledApps[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static int sizeGameList() {
        int size;
        int sizeList = 0;
        ContentHandler[] contentHandler = IOUtility.getGameList();
        if (contentHandler != null && (size = contentHandler.length) > 0) {
            int pos = 0;
            while (pos < size) {
                if (!contentHandler[pos].getAppName().equalsIgnoreCase("FIFA 10") && !contentHandler[pos].getAppName().equalsIgnoreCase("FIFA 10 DEMO")) {
                    ++sizeList;
                }
                ++pos;
            }
        }
        return sizeList;
    }

    public static ContentHandler[] getGameList() {
        Registry registry = Registry.getRegistry((String)SystemProperties.getMainMidletPath());
        ContentHandler[] contenthandler = registry.forAction(CHAPI_ACTION);
        return contenthandler;
    }
}

