/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.utils;

import com.sonyericsson.ams.Application;
import com.sonyericsson.fifa.controller.ChapiHandler;
import com.sonyericsson.fifa.utils.DateConstants;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.RunConnection;
import com.sun.lwuit.plaf.UIManager;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

public class SystemProperties {
    public static final int OSE_PLATFORM_HB108 = 0;
    public static final int OSE_PLATFORM_HB209 = 1;
    public static final int SYMBIAN_PLATFORM = 2;
    public static final int EMULATOR_PLATFORM = 3;
    public static final int MAX_NUMBER_FEEDS_ITEMS_TO_PARSER = 25;
    private static final int CONNECTION_TIME_OUT = 15000;
    private static final String HOMESCREEN_APP_NAME = "footballfanhs";
    private static String MIDletVersion;
    private static String MIDletName;
    private static String PhoneLanguage;
    private static String PhoneModel;
    private static String UpgradeUrl;
    private static String UpgradeParameters;
    private static String UpgradeParametersHS;
    private static MIDlet midlet;
    private static com.sun.lwuit.Display displayProp;
    private static int displayWidth;
    private static int displayHeight;
    private static SystemProperties instance;
    private static int phonePlatform;
    public static String EMULATOR_USER_AGENT;
    private static final String DEFAULT_STRING = "???";

    static {
        EMULATOR_USER_AGENT = "SonyEricssonW980i/R3AA Profile/MIDP-2.1 Configuration/CLDC-1.1";
    }

    public static void initialize(MIDlet m) {
        if (instance == null) {
            midlet = m;
            displayProp = com.sun.lwuit.Display.getInstance();
            instance = new SystemProperties();
        }
    }

    private SystemProperties() {
        displayWidth = displayProp.getDisplayWidth();
        displayHeight = displayProp.getDisplayHeight();
        MIDletVersion = midlet.getAppProperty("MIDlet-Version");
        MIDletName = midlet.getClass().getName();
        PhoneLanguage = System.getProperty("microedition.locale");
        MIDletVersion = midlet.getAppProperty("MIDlet-Version");
        PhoneModel = System.getProperty("microedition.platform");
        PhoneModel = PhoneModel.substring(0, PhoneModel.indexOf("/"));
        UpgradeUrl = midlet.getAppProperty("SEMC-Server-URL");
        UpgradeParameters = "?type=app&revision=" + MIDletVersion;
        UpgradeParametersHS = "?type=hs&revision=" + MIDletVersion;
    }

    public static String getAppProperty(String property) {
        return midlet.getAppProperty(property);
    }

    public static String getMidletVersion() {
        return MIDletVersion;
    }

    public static void minimizeApplication() {
        Display display = Display.getDisplay((MIDlet)midlet);
        display.setCurrent(null);
    }

    public static void restoreApplication() {
        try {
            com.sun.lwuit.Display.getInstance().minimizeApplication();
            com.sun.lwuit.Display.getInstance().restoreMinimizedApplication();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMainMidletPath() {
        String midletPath = null;
        if (midlet != null) {
            midletPath = midlet.getClass().getName();
        }
        return midletPath;
    }

    public static void platformRequest(String param) throws ConnectionNotFoundException {
        midlet.platformRequest(param);
    }

    public static boolean upgradeApplication(ChapiHandler chapiHandler) throws ConnectionNotFoundException {
        boolean isUpgradeOK = false;
        try {
            int responseCode = 0;
            boolean hasNet = IOUtility.hasNetworkingConnection();
            if (hasNet) {
                RunConnection runConn = new RunConnection(String.valueOf(UpgradeUrl) + UpgradeParameters, 15000L);
                runConn.setHttpRequestMode("GET");
                runConn.setHttpRequestProperty("User-Agent", PhoneModel);
                runConn.go();
                responseCode = runConn.getResponseCode();
                if (responseCode == 200 || responseCode == 302) {
                    isUpgradeOK = true;
                    midlet.platformRequest(String.valueOf(UpgradeUrl) + UpgradeParameters);
                    if (2 != SystemProperties.getPhonePlatform() && chapiHandler != null && SystemProperties.isHomescreenStarted()) {
                        chapiHandler.changeWidgetStatus("stopHomescreen", true);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isUpgradeOK;
    }

    public static boolean upgradeHomeScreen(ChapiHandler chapiHandler) throws ConnectionNotFoundException {
        boolean isUpgradeOK = false;
        try {
            int responseCode = 0;
            String versionHS = "1.0";
            boolean hasNet = IOUtility.hasNetworkingConnection();
            if (hasNet && SystemProperties.getPhonePlatform() != 2) {
                Application application = IOUtility.getJavaApplication(HOMESCREEN_APP_NAME);
                if (application != null) {
                    versionHS = application.getProperty("MIDlet-Version");
                }
                UpgradeParametersHS = "?type=hs&revision=" + versionHS;
                RunConnection runConn = new RunConnection(String.valueOf(UpgradeUrl) + UpgradeParametersHS, 15000L);
                runConn.setHttpRequestMode("GET");
                runConn.setHttpRequestProperty("User-Agent", PhoneModel);
                runConn.go();
                responseCode = runConn.getResponseCode();
                if (responseCode == 200 || responseCode == 302) {
                    isUpgradeOK = true;
                    midlet.platformRequest(String.valueOf(UpgradeUrl) + UpgradeParametersHS);
                    if (chapiHandler != null && SystemProperties.isHomescreenStarted()) {
                        chapiHandler.changeWidgetStatus("stopHomescreen", true);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isUpgradeOK;
    }

    private static boolean isHomescreenStarted() {
        Application appHomescreen = IOUtility.getJavaApplication(HOMESCREEN_APP_NAME);
        if (appHomescreen != null) {
            return appHomescreen.isStarted();
        }
        return false;
    }

    public static boolean isHSInstalled() {
        return IOUtility.getJavaApplication(HOMESCREEN_APP_NAME) != null;
    }

    public static int getDisplayWidth() {
        return displayWidth;
    }

    public static int getDisplayHeight() {
        return displayHeight;
    }

    public static int getPhonePlatform() {
        String platform = System.getProperty("microedition.platform");
        com.sun.lwuit.Display.getInstance().setTouchScreenDevice(false);
        if (platform.indexOf("SDK") != -1) {
            phonePlatform = 3;
        } else {
            String javaPlatform = System.getProperty("com.sonyericsson.java.platform");
            if (javaPlatform.indexOf("SJP") != -1) {
                com.sun.lwuit.Display.getInstance().setTouchScreenDevice(true);
                UIManager.getInstance().getLookAndFeel().setTactileTouchDuration(10);
                phonePlatform = 2;
            } else {
                phonePlatform = javaPlatform.indexOf("JP-8.5") != -1 ? 1 : 0;
            }
        }
        return phonePlatform;
    }

    public static boolean isNoInternetSettingsException(Exception e) {
        String message = "No network settings";
        if (SystemProperties.getPhonePlatform() == 2) {
            message = "-3";
        }
        String exception = e.getMessage();
        boolean contains = false;
        if (exception != null && exception.indexOf(message) != -1) {
            contains = true;
        }
        return contains;
    }

    public static boolean isConnectionNotFoundException(Exception e) {
        boolean contains = false;
        if (e instanceof ConnectionNotFoundException) {
            contains = true;
        } else {
            String message = "Host not found";
            String exception = e.getMessage();
            if (exception != null) {
                if (exception.indexOf(message) != -1) {
                    contains = true;
                }
            } else {
                contains = true;
            }
        }
        return contains;
    }

    public static Display getLCDUIDisplay() {
        return Display.getDisplay((MIDlet)midlet);
    }

    public static String getMidletName() {
        return MIDletName;
    }

    public static String getContentType(String filename) {
        String contentType = null;
        if (filename.endsWith(".3gp")) {
            contentType = "video/3gpp";
        } else if (filename.endsWith(".mp4")) {
            contentType = "video/mpeg4";
        }
        return contentType;
    }

    public static String getFilename(String filepath) {
        int index = filepath.lastIndexOf(47) + 1;
        String filename = filepath.substring(index);
        if (filename.endsWith(".mp4")) {
            index = filename.indexOf(".mp4");
            if (index > -1) {
                return filename.substring(0, index);
            }
            return null;
        }
        if (filename.endsWith(".3gp")) {
            index = filename.indexOf(".3gp");
            if (index > -1) {
                return filename.substring(0, index);
            }
            return null;
        }
        return null;
    }

    public static final String clearHtmlString(String string) {
        StringBuffer newString = new StringBuffer(string.length());
        boolean blankChar = false;
        boolean clearAfter = false;
        char[] stringChars = string.toCharArray();
        int i = 0;
        while (i < stringChars.length) {
            char character = stringChars[i];
            if (!clearAfter || character == '>' || character == ';') {
                if (character == ' ') {
                    if (blankChar) {
                        blankChar = false;
                    } else {
                        blankChar = true;
                        newString.append(' ');
                    }
                } else {
                    blankChar = false;
                    if (character == '<' || character == '#') {
                        clearAfter = true;
                    } else if (character == '>' || character == ';') {
                        clearAfter = false;
                    } else {
                        newString.append(character);
                    }
                }
            }
            ++i;
        }
        return newString.toString();
    }

    public static final String removeTrashCharacters(String input) {
        String newString = input.replace('?', '_');
        newString = newString.replace('=', '_');
        newString = newString.replace('%', '_');
        newString = newString.replace('&', '_');
        return newString;
    }

    public static Calendar getTimeCalendar(String time) {
        int dayOfWeek = -1;
        int day = -1;
        int month = -1;
        int year = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        String timeZone = null;
        int i = 0;
        String[] timeSplit = SystemProperties.splitString(time, ' ');
        while (i < timeSplit.length) {
            switch (i) {
                case 0: {
                    dayOfWeek = DateConstants.getDayOfWeek(timeSplit[i]);
                    break;
                }
                case 1: {
                    day = Integer.parseInt(timeSplit[i]);
                    break;
                }
                case 2: {
                    month = DateConstants.getMonthOfYear(timeSplit[i]);
                    break;
                }
                case 3: {
                    year = Integer.parseInt(timeSplit[i]);
                    break;
                }
                case 4: {
                    int[] timeArray = SystemProperties.parseTimeToInt(timeSplit[i]);
                    hour = timeArray[0];
                    minute = timeArray[1];
                    second = timeArray[2];
                    break;
                }
                case 5: {
                    timeZone = timeSplit[i];
                    break;
                }
            }
            ++i;
        }
        if (timeZone == null) {
            timeZone = "GMT";
        }
        TimeZone defaultTimeZone = TimeZone.getTimeZone(timeZone);
        Calendar calendar = Calendar.getInstance(defaultTimeZone);
        if (dayOfWeek != -1) {
            calendar.set(7, dayOfWeek);
        }
        if (day != -1) {
            calendar.set(5, day);
        }
        if (month != -1) {
            calendar.set(2, month);
        }
        if (year != -1) {
            calendar.set(1, year);
        }
        if (hour != -1) {
            calendar.set(10, hour);
        }
        if (minute != -1) {
            calendar.set(12, minute);
        }
        if (second != -1) {
            calendar.set(13, second);
        }
        return calendar;
    }

    public static int[] parseTimeToInt(String time) {
        int[] timeArray = new int[3];
        String[] timeSplit = SystemProperties.splitString(time, ':');
        int hour = -1;
        int minute = -1;
        int second = -1;
        int i = 0;
        while (i < timeSplit.length) {
            switch (i) {
                case 0: {
                    hour = Integer.parseInt(timeSplit[i]);
                    break;
                }
                case 1: {
                    minute = Integer.parseInt(timeSplit[i]);
                    break;
                }
                case 2: {
                    second = Integer.parseInt(timeSplit[i]);
                    break;
                }
            }
            ++i;
        }
        timeArray[0] = hour;
        timeArray[1] = minute;
        timeArray[2] = second;
        return timeArray;
    }

    public static final String[] splitString(String input, char separator) {
        if (input == null) {
            return null;
        }
        int textSize = input.length();
        if (textSize == 0) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        int i = 0;
        int start = 0;
        boolean allow = false;
        while (i < textSize) {
            if (input.charAt(i) == separator) {
                if (allow) {
                    list.addElement(input.substring(start, i).trim());
                    allow = false;
                }
                start = ++i;
                continue;
            }
            allow = true;
            ++i;
        }
        if (allow) {
            list.addElement(input.substring(start, i).trim());
        }
        Object[] elements = new String[list.size()];
        list.copyInto(elements);
        return elements;
    }

    public static final int compareCalendar(Calendar first, Calendar second) {
        int i = 0;
        i = second.after(first) ? 1 : -1;
        return i;
    }

    public static boolean isRoaming() {
        boolean retValue = false;
        String isHome = System.getProperty("com.sonyericsson.net.isonhomeplmn");
        String rat = System.getProperty("com.sonyericsson.net.rat");
        String netstatus = System.getProperty("com.sonyericsson.net.status");
        if (rat != null && netstatus != null && !netstatus.equalsIgnoreCase("No Network") && !netstatus.equalsIgnoreCase("Home PLMN") && !netstatus.equalsIgnoreCase("Forbidden") && isHome != null && isHome.equalsIgnoreCase("false")) {
            retValue = true;
        }
        return retValue;
    }

    public static boolean isFlightMode() {
        boolean retValue = false;
        String isFlightMode = System.getProperty("com.sonyericsson.net.rat");
        if (isFlightMode == null) {
            retValue = true;
        }
        return retValue;
    }

    public static String getPhoneLanguage() {
        return PhoneLanguage;
    }

    public static void setPhoneLanguage(String phoneLanguage) {
        PhoneLanguage = phoneLanguage;
    }

    public static String convertUnicodeToString(String str) {
        char[] chars = str.toCharArray();
        StringBuffer ret = new StringBuffer();
        int x = 0;
        while (x < chars.length) {
            char ch;
            if ((ch = chars[x++]) == '\\') {
                if ((ch = chars[x++]) == 'u') {
                    int code = 0;
                    int i = 0;
                    while (i < 4) {
                        if ((ch = chars[x++]) >= '0' && ch <= '9') {
                            code = (code << 4) + ch - 48;
                        } else if (ch >= 'a' && ch <= 'f') {
                            code = (code << 4) + 10 + ch - 97;
                        } else if (ch >= 'A' && ch <= 'F') {
                            code = (code << 4) + 10 + ch - 65;
                        } else {
                            return DEFAULT_STRING;
                        }
                        ++i;
                    }
                    ret.append((char)code);
                    continue;
                }
                switch (ch) {
                    case 't': {
                        ch = '\t';
                        break;
                    }
                    case 'r': {
                        ch = '\r';
                        break;
                    }
                    case 'n': {
                        ch = '\n';
                        break;
                    }
                    case 'f': {
                        ch = '\f';
                    }
                }
                ret.append(ch);
                continue;
            }
            ret.append(ch);
        }
        return ret.toString();
    }
}

