/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view;

import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.language.Language;
import com.sun.lwuit.Font;
import com.sun.lwuit.util.Resources;
import java.io.IOException;
import java.util.Hashtable;

public class FifaResources {
    private static Resources resources = null;
    private static String imageFolder = null;
    private static volatile Hashtable hashLocalization = null;
    private static String currentLocale = null;
    private static Language language;
    private static final String RESOURCES_NAME_WQVGA = "/Fifa_WQVGA.res";
    private static final String RESOURCES_NAME_NHD = "/Fifa_NHD.res";
    public static final String FONT_SANSSERIF_MINI_REGULAR = "Font_SansSerif_Mini_Regular";
    public static final String FONT_SANSSERIF_MEDIUM_REGULAR = "Font_SansSerif_Medium_Regular";
    public static final String FONT_SANSSERIF_SMALL_BOLD = "Font_SansSerif_Small_Bold";
    public static final String FONT_SANSSERIF_SMALL_REGULAR = "Font_SansSerif_Small_Regular";
    public static final String FONT_SANSSERIF_MEDIUM_BOLD = "Font_SansSerif_Medium_Bold";
    public static final String FONT_SANSSERIF_LARGE_REGULAR = "Font_SansSerif_Large_Regular";
    public static final String FONT_SANSSERIF_LARGE_BOLD = "Font_SansSerif_Large_Bold";
    private static final String DEFAULT_STRING = "???";
    static /* synthetic */ Class class$0;

    private static synchronized void init() {
        try {
            if (resources == null) {
                if (SystemProperties.getPhonePlatform() == 2) {
                    resources = Resources.open(RESOURCES_NAME_NHD);
                    imageFolder = "/img_nhd/";
                } else {
                    resources = Resources.open(RESOURCES_NAME_WQVGA);
                    imageFolder = "/img_wqvga/";
                }
            }
        }
        catch (IOException io) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.view.FifaResources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logInfo(clazz, "Error to open Resources file");
        }
    }

    public static Font getFont(String fontName) {
        FifaResources.init();
        if (fontName != null) {
            return resources.getFont(fontName);
        }
        return null;
    }

    public static String getImageFolder() {
        FifaResources.init();
        return imageFolder;
    }

    public static Hashtable getTheme(String themeName) {
        FifaResources.init();
        if (themeName != null) {
            return resources.getTheme(themeName);
        }
        return null;
    }

    public static synchronized Language getLanguage() {
        if (language == null) {
            language = new Language();
        }
        return language;
    }

    public static String getMessage(String key) {
        Object value;
        FifaResources.init();
        if (currentLocale == null || !currentLocale.equals(FifaResources.getLanguage().getCurrentLocale())) {
            String currentLocale = FifaResources.getLanguage().getCurrentLocale();
            if (currentLocale != null) {
                hashLocalization = resources.getL10N("Fifa_Localization", currentLocale);
            }
            if (currentLocale == null || hashLocalization == null) {
                hashLocalization = resources.getL10N("Fifa_Localization", "en");
            }
        }
        if ((value = hashLocalization.get(key)) == null) {
            value = DEFAULT_STRING;
        }
        return SystemProperties.convertUnicodeToString("" + value);
    }

    public static boolean checkLanguageAvailability(String language) {
        FifaResources.init();
        Hashtable hash = resources.getL10N("Fifa_Localization", language);
        return hash != null;
    }
}

