/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.VideoPlayerListener;
import com.sonyericsson.fifa.view.exceptions.VideoPlayerException;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;

public class VideoPlayer
implements PlayerListener {
    private int locationX;
    private int locationY;
    private int width;
    private int height;
    private static final int VIDEO_OVERLAY_ENABLED = 257;
    private static final int VIDEO_LANDSCAPE = 80;
    public static final int NOT_STARTED = 0;
    public static final int VIDEO_LOADED = 1;
    public static final int VIDEO_CONTROL_SETUP = 2;
    public static final int PLAY_PRESSED = 3;
    public static final int PLAYING = 4;
    public static final int STOP_PRESSED = 5;
    public static final int STOPPED = 6;
    public static final int FINISHED = 7;
    private int currentState = 0;
    private Player player;
    private VideoControl videoControl;
    private VideoPlayerListener videoPlayerListener;

    public void setDisplayLocation(int locationX, int locationY) {
        this.locationX = locationX;
        this.locationY = locationY;
    }

    public void setDisplaySize(int width, int height) throws VideoPlayerException {
        if (width <= 0 && height <= 0) {
            throw new VideoPlayerException("Parameters given are null or invalid");
        }
        this.width = width;
        this.height = height;
    }

    public void setVideoPlayerListener(VideoPlayerListener videoPlayerListener) {
        this.videoPlayerListener = videoPlayerListener;
    }

    public void loadVideo(String filename) throws VideoPlayerException {
        InputStream inputStream = null;
        try {
            inputStream = IOUtility.openInputStream(filename);
            this.player = Manager.createPlayer((InputStream)inputStream, (String)SystemProperties.getContentType(filename));
            this.player.addPlayerListener((PlayerListener)this);
            this.player.realize();
            this.currentState = 1;
        }
        catch (IOException e) {
            throw new VideoPlayerException("Error on loading the video");
        }
        catch (MediaException e) {
            throw new VideoPlayerException("Error on loading the video");
        }
    }

    public void setCanvas(Canvas canvas) throws VideoPlayerException {
        if (canvas == null) {
            throw new VideoPlayerException("Parameters given are null or invalid");
        }
        this.videoControl = (VideoControl)this.player.getControl("VideoControl");
        if (this.videoControl != null) {
            this.videoControl.initDisplayMode(337, (Object)canvas);
            if (this.width != 0 && this.height != 0) {
                try {
                    this.videoControl.setDisplaySize(this.width, this.height);
                }
                catch (MediaException e) {
                    throw new VideoPlayerException("Error on playing the video");
                }
            }
            this.videoControl.setDisplayLocation(this.locationX, this.locationY);
            this.videoControl.setVisible(true);
            this.currentState = 2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void play() throws VideoPlayerException {
        if (this.currentState != 2 && this.currentState != 6 && this.currentState != 7) throw new VideoPlayerException("Error on playing the video");
        if (this.player == null) throw new VideoPlayerException("Error on playing the video");
        this.currentState = 3;
        try {
            this.player.setLoopCount(-1);
            this.player.prefetch();
            this.player.start();
            return;
        }
        catch (MediaException e) {
            throw new VideoPlayerException("Error on playing the video");
        }
    }

    public void close() {
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }

    public void stop() throws VideoPlayerException {
        if (this.currentState == 4) {
            if (this.player != null) {
                this.currentState = 5;
                try {
                    this.player.stop();
                }
                catch (Exception e) {
                    throw new VideoPlayerException("Error on stopping the video");
                }
            } else {
                throw new VideoPlayerException("Error on stopping the video");
            }
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equalsIgnoreCase("started")) {
            this.currentState = 4;
        } else if (event.equalsIgnoreCase("stopped") || event.equalsIgnoreCase("endOfMedia")) {
            this.currentState = event.equalsIgnoreCase("stopped") ? 6 : 7;
            if (this.videoPlayerListener != null) {
                this.videoPlayerListener.notifyVideoStopped();
            }
        }
    }

    public byte getCurrentPercentage() {
        byte percentage = 0;
        if (this.currentState == 4 || this.currentState == 6) {
            long currentTime = this.player.getMediaTime();
            long totalTime = this.player.getDuration();
            if (currentTime == -1L || totalTime == -1L) {
                return 0;
            }
            percentage = (byte)(currentTime * 100L / totalTime);
        }
        return percentage;
    }

    public void seekVideo(byte percentage) throws VideoPlayerException {
        try {
            if (this.currentState == 4) {
                long totalTime = this.player.getDuration();
                if (totalTime == -1L) {
                    return;
                }
                long newCurrentTime = totalTime * (long)percentage / 100L;
                this.player.setMediaTime(newCurrentTime);
            }
        }
        catch (MediaException e) {
            throw new VideoPlayerException("Error on seaking the video");
        }
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public String getTotalDuration() {
        return this.timeToString(this.player.getDuration());
    }

    public String getCurrentTime() {
        return this.timeToString(this.player.getMediaTime());
    }

    public String getTimeString(byte percentage) {
        return this.timeToString(this.player.getDuration() * (long)percentage / 100L);
    }

    private String timeToString(long time) {
        String duration = "0:00";
        if (this.player != null && this.currentState != 0) {
            int seconds = 0;
            double valorReal = (double)time / 1000000.0;
            double valorCeil = Math.ceil((double)time / 1000000.0);
            double valor = valorCeil - 0.5;
            seconds = valorReal >= valor ? (int)valorCeil : (int)Math.floor((double)time / 1000000.0);
            int minute = 0;
            if (seconds > 59) {
                minute = this.numberOfMinutes(seconds);
                seconds -= minute * 60;
            }
            String minuteString = minute >= 10 ? String.valueOf(minute) : "0" + String.valueOf(minute);
            String secondsString = seconds >= 10 ? String.valueOf(seconds) : "0" + String.valueOf(seconds);
            duration = String.valueOf(minuteString) + ":" + secondsString;
        }
        return duration;
    }

    private int numberOfMinutes(long totalTime) {
        return (int)totalTime / 60;
    }

    public int getSourceWidth() throws VideoPlayerException {
        int result = -1;
        try {
            if (this.videoControl != null) {
                result = this.videoControl.getSourceWidth();
            }
        }
        catch (Exception e) {
            throw new VideoPlayerException("Error on loading the video");
        }
        return result;
    }

    public int getSourceHeight() throws VideoPlayerException {
        int result = -1;
        try {
            if (this.videoControl != null) {
                result = this.videoControl.getSourceHeight();
            }
        }
        catch (Exception e) {
            throw new VideoPlayerException("Error on loading the video");
        }
        return result;
    }

    public int getDisplayWidth() throws VideoPlayerException {
        int result = -1;
        try {
            if (this.videoControl != null) {
                result = this.videoControl.getDisplayWidth();
            }
        }
        catch (Exception e) {
            throw new VideoPlayerException("Error on loading the video");
        }
        return result;
    }

    public int getDisplayHeight() throws VideoPlayerException {
        int result = -1;
        try {
            if (this.videoControl != null) {
                result = this.videoControl.getDisplayHeight();
            }
        }
        catch (Exception e) {
            throw new VideoPlayerException("Error on loading the video");
        }
        return result;
    }

    public int getDisplayLocationX() {
        return this.locationX;
    }

    public int getDisplayLocationY() {
        return this.locationY;
    }
}

