/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components;

import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.Container;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;

public class FifaCheckBox
extends Container {
    private Attributes attributes = VerifyScreenDimension.getAttributesInstance();
    private static final int COLOR_WHITE = 0xFFFFFF;
    private static final int COLOR_GREY = 0x909090;
    private TextArea infoTextArea = null;
    private String fifaCheckBoxInfoText = null;
    private String fifaCheckboxText = null;
    private CheckBox checkBox = null;

    protected void focusGained() {
        this.getStyle().setBgImage(Images.getHighlightImg());
        this.getInfoTextArea().getStyle().setFgColor(0xFFFFFF);
    }

    protected void focusLost() {
        super.focusLost();
        this.getInfoTextArea().getStyle().setFgColor(0x909090);
    }

    public FifaCheckBox(String fifaCheckboxText, String fifaCheckBoxInfoText) {
        this.fifaCheckBoxInfoText = fifaCheckBoxInfoText;
        this.fifaCheckboxText = fifaCheckboxText;
        this.setLayout(new BoxLayout(2));
        this.setFocus(false);
        this.setFocusable(true);
        if (fifaCheckBoxInfoText != null) {
            this.addComponent(this.getCheckBox(true));
            this.addComponent(this.getInfoTextArea());
        } else {
            this.addComponent(this.getCheckBox(false));
        }
    }

    protected TextArea getInfoTextArea() {
        if (this.infoTextArea == null) {
            this.infoTextArea = new TextArea();
            this.setTextAreaStyle(this.infoTextArea.getStyle());
            this.infoTextArea.setEditable(false);
            this.infoTextArea.setFocusable(false);
            this.infoTextArea.setFocusPainted(false);
            this.infoTextArea.setGrowByContent(true);
            this.infoTextArea.setRowsGap(0);
            this.infoTextArea.setText(this.fifaCheckBoxInfoText);
        }
        return this.infoTextArea;
    }

    protected CheckBox getCheckBox(boolean hasTextInfo) {
        if (this.checkBox == null) {
            this.checkBox = new CheckBox();
            this.checkBox.setGap(this.attributes.getOptions_Checkbox_Gap());
            this.setCheckBoxStyle(this.checkBox.getStyle(), hasTextInfo);
            this.checkBox.setFocus(false);
            this.checkBox.setFocusable(false);
            this.checkBox.setFocusPainted(false);
            this.checkBox.setText(this.fifaCheckboxText);
        }
        return this.checkBox;
    }

    public void setTextAreaText(String text) {
        this.infoTextArea.setText(text);
    }

    public void setChechBoxText(String text) {
        this.checkBox.setText(text);
    }

    private void setTextAreaStyle(Style style) {
        style.setFont(FifaResources.getFont("Font_SansSerif_Mini_Regular"));
        style.setBorder(Border.createEmpty());
        style.setMargin(0, this.attributes.getSquadTitleMarginLeftRight(), this.attributes.getOptions_Checkbox_Info_Text_Margin_Height(), 0);
        style.setPadding(0, 0, 0, 0);
        style.setBgTransparency(0);
        style.setFgColor(0x909090);
    }

    private void setCheckBoxStyle(Style style, boolean hasTextInfo) {
        style.setFont(FifaResources.getFont("Font_SansSerif_Small_Bold"));
        if (hasTextInfo) {
            style.setMargin(this.attributes.getSquadTitleMarginLeftRight(), 0, this.attributes.getSquadTitleMarginLeftRight(), 0);
        } else {
            style.setMargin(this.attributes.getSquadTitleMarginLeftRight(), this.attributes.getSquadTitleMarginLeftRight(), this.attributes.getSquadTitleMarginLeftRight(), 0);
        }
        style.setPadding(0, 0, 0, 0);
        style.setBgTransparency(0);
        style.setFgColor(0xFFFFFF);
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public void setSelected() {
        this.checkBox.setSelected(!this.checkBox.isSelected());
    }

    public void setSelected(boolean selected) {
        this.checkBox.setSelected(selected);
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -5) {
            this.setSelected();
            this.repaint();
        } else {
            super.keyPressed(keyCode);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.checkBox.getStyle().setFgColor(0xFFFFFF);
        } else {
            this.checkBox.getStyle().setFgColor(0x909090);
        }
    }
}

