/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components;

import com.sun.lwuit.Component;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.Style;

public class FifaTextAreaCentered
extends TextArea {
    private int disableColor = 0xCCCCCC;

    public void paint(Graphics g) {
        this.setFG(g, this);
        int line = this.getLines();
        int oX = g.getClipX();
        int oY = g.getClipY();
        int oWidth = g.getClipWidth();
        int oHeight = g.getClipHeight();
        Font f = this.getStyle().getFont();
        int fontHeight = f.getHeight();
        int leftPadding = this.getStyle().getPadding(this.isRTL(), 1);
        int rightPadding = this.getStyle().getPadding(this.isRTL(), 3);
        int topPadding = this.getStyle().getPadding(false, 0);
        boolean shouldBreak = false;
        int i = 0;
        while (i < line) {
            int y;
            int x = this.getX() + leftPadding;
            if (Rectangle.intersects(x, y = this.getY() + topPadding + (this.getRowsGap() + fontHeight) * i, this.getWidth(), fontHeight, oX, oY, oWidth, oHeight)) {
                StringBuffer rowText = new StringBuffer(this.getTextAt(i));
                StringBuffer displayText = new StringBuffer();
                if ((this.getConstraint() & 0x10000) != 0) {
                    int j = 0;
                    while (j < rowText.length()) {
                        displayText.append("*");
                        ++j;
                    }
                } else {
                    displayText = rowText;
                }
                g.drawString(displayText.toString(), x += (this.getWidth() - leftPadding - rightPadding - f.stringWidth(displayText.toString())) / 2, y);
                shouldBreak = true;
            } else if (shouldBreak) break;
            ++i;
        }
    }

    public void setFG(Graphics g, Component c) {
        Style s = c.getStyle();
        g.setFont(s.getFont());
        if (c.isEnabled()) {
            g.setColor(s.getFgColor());
        } else {
            g.setColor(this.disableColor);
        }
    }
}

