/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sonyericsson.fifa.view.components.Softkey;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Border;
import java.io.IOException;

public class SoftkeyContainer
extends Container {
    public static final int UP = 0;
    public static final int DOWN = 1;
    private static final String MIDDLE_UP = "MSKup.png";
    private static final String MIDDLE_DOWN = "MSKdn.png";
    private static Image background;
    private static Image right_down;
    private static Image left_down;
    private Attributes attributes = VerifyScreenDimension.getAttributesInstance();
    private Softkey rightSoftKey;
    private Softkey middleSoftKey;
    private Softkey leftSoftKey;
    private int softkey = -100;

    public SoftkeyContainer() {
        this.setLayout(new CoordinateLayout(new Dimension(SystemProperties.getDisplayWidth(), this.attributes.getSoftkeyHeight())));
        this.setStyle();
        this.addComponent(this.getRightSoftkey());
        this.addComponent(this.getLeftSoftkey());
        if (SystemProperties.getPhonePlatform() != 2) {
            this.addComponent(this.getMiddleSoftkey());
        }
        this.readImages();
        this.getStyle().setBgImage(background);
    }

    private void readImages() {
        String left_img = "LSKdn.png";
        String right_img = "RSKdn.png";
        String background_img = "softkey-background.png";
        try {
            background = Image.createImage(IOUtility.getImageFromRES(background_img));
            left_down = Image.createImage(IOUtility.getImageFromRES(left_img));
            right_down = Image.createImage(IOUtility.getImageFromRES(right_img));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setStyle() {
        this.getStyle().setBgTransparency(0);
        this.getStyle().setBorder(Border.createEmpty());
        this.getStyle().setMargin(0, 0, 0, 0);
        this.getStyle().setPadding(0, 0, 0, 0);
    }

    public void setBgImage() {
        if (SystemProperties.getPhonePlatform() != 2) {
            this.getStyle().setBgImage(background);
            this.removeComponent(this.getMiddleSoftkey());
            this.removeComponent(this.getLeftSoftkey());
        }
    }

    public void clearSoftkeyBkGround() {
        this.getStyle().setBgImage(background);
        this.repaint();
    }

    private void clearMidSoftkeyBkGround() {
        this.middleSoftKey.switchState(MIDDLE_UP);
    }

    private Softkey getRightSoftkey() {
        if (this.rightSoftKey == null) {
            this.rightSoftKey = new Softkey();
            this.rightSoftKey.setDimension(this.attributes.getSoftkeyWidth(), this.attributes.getSoftkeyHeight());
            this.rightSoftKey.setX(this.attributes.getWidth() - this.rightSoftKey.getPreferredW());
            this.rightSoftKey.setEnabled(true);
            FifaLookAndFeelManager.configToLeftRightSoftkey(this.rightSoftKey);
        }
        return this.rightSoftKey;
    }

    private Softkey getMiddleSoftkey() {
        if (this.middleSoftKey == null) {
            this.middleSoftKey = new Softkey();
            this.middleSoftKey.setBackground(MIDDLE_UP);
            this.middleSoftKey.setDimension(this.attributes.getMiddleSoftkeyWidth(), this.attributes.getSoftkeyHeight() - 2);
            this.middleSoftKey.setX((this.attributes.getWidth() - this.attributes.getMiddleSoftkeyWidth()) / 2);
            this.middleSoftKey.setY(2);
            FifaLookAndFeelManager.configToMiddleSoftkey(this.middleSoftKey);
        }
        return this.middleSoftKey;
    }

    private Softkey getLeftSoftkey() {
        if (this.leftSoftKey == null) {
            this.leftSoftKey = new Softkey();
            this.leftSoftKey.setDimension(this.attributes.getSoftkeyWidth(), this.attributes.getSoftkeyHeight());
            this.leftSoftKey.setX(0);
            this.leftSoftKey.setEnabled(false);
            FifaLookAndFeelManager.configToLeftRightSoftkey(this.leftSoftKey);
        }
        return this.leftSoftKey;
    }

    public void setLeftSoftkeyText(String text) {
        this.getLeftSoftkey().setText(text);
        this.getLeftSoftkey().setAlignment(1);
    }

    public void setMiddleSoftkeyText(String text) {
        if (SystemProperties.getPhonePlatform() != 2) {
            this.getMiddleSoftkey().setText(text);
            this.getMiddleSoftkey().setAlignment(4);
            this.getMiddleSoftkey().repaint();
        }
    }

    public void setRightSoftkeyText(String text) {
        this.getRightSoftkey().setText(text);
        this.getRightSoftkey().setAlignment(3);
    }

    public void setMiddleSoftkeyBackground(String imageName) {
        this.getMiddleSoftkey().setBackground(imageName);
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -7: {
                this.simulateSoftkeyPressed(-7);
                this.softkey = -7;
                break;
            }
            case -5: {
                this.simulateSoftkeyPressed(-5);
                this.softkey = -5;
                break;
            }
            case -6: {
                this.simulateSoftkeyPressed(-6);
                this.softkey = -6;
                break;
            }
            default: {
                this.softkey = -100;
                super.keyPressed(keyCode);
            }
        }
        this.clearSoftkeyBkGround();
        if (SystemProperties.getPhonePlatform() != 2) {
            this.clearMidSoftkeyBkGround();
        }
    }

    public void keyReleased(int keyCode) {
        switch (keyCode) {
            case -7: {
                this.softkey = -7;
                break;
            }
            case -5: {
                this.simulateMiddleSoftkeyReleased();
                this.softkey = -5;
                break;
            }
            case -6: {
                this.softkey = -6;
                break;
            }
            default: {
                this.softkey = -100;
                super.keyReleased(keyCode);
            }
        }
    }

    public void pointerPressed(int valX, int ValY) {
        if (Display.getInstance().isTouchScreenDevice()) {
            if (this.getLeftSoftkey().contains(valX, ValY)) {
                this.softkey = -6;
                this.simulateSoftkeyPressed(-6);
            } else if (this.getRightSoftkey().contains(valX, ValY)) {
                this.softkey = -7;
                this.simulateSoftkeyPressed(-7);
            } else {
                this.softkey = -100;
            }
        }
        this.clearSoftkeyBkGround();
    }

    public void pointerReleased(int valX, int ValY) {
        if (Display.getInstance().isTouchScreenDevice()) {
            if (this.getLeftSoftkey().contains(valX, ValY)) {
                this.softkey = -100;
                this.clearSoftkeyBkGround();
            } else {
                this.softkey = this.getRightSoftkey().contains(valX, ValY) ? -7 : -100;
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    public int getSelectedSoftkey() {
        return this.softkey;
    }

    public void setPreferredH(int preferredH) {
        super.setPreferredH(preferredH);
        if (preferredH == this.attributes.getSoftkeyHeightWithoutTab()) {
            this.getMiddleSoftkey().setY(8);
            this.getRightSoftkey().setY(8);
            this.getLeftSoftkey().setY(8);
        }
    }

    public void addMiddleSoftkey() {
        if (SystemProperties.getPhonePlatform() != 2 && this.getComponentIndex(this.getMiddleSoftkey()) == -1) {
            this.addComponent(this.getMiddleSoftkey());
        }
    }

    public void removeMiddleSoftkey() {
        if (SystemProperties.getPhonePlatform() != 2 && this.getComponentIndex(this.getMiddleSoftkey()) != -1) {
            this.removeComponent(this.getMiddleSoftkey());
        }
    }

    private void simulateSoftkeyPressed(final int keyCode) {
        Display.getInstance().invokeAndBlock(new Runnable(){

            public void run() {
                if (keyCode == -6 && SoftkeyContainer.this.getLeftSoftkey().isEnabled()) {
                    SoftkeyContainer.this.getStyle().setBgImage(left_down);
                    SoftkeyContainer.this.repaint();
                } else if (keyCode == -7 && SoftkeyContainer.this.getRightSoftkey().isEnabled()) {
                    SoftkeyContainer.this.getStyle().setBgImage(right_down);
                    SoftkeyContainer.this.repaint();
                } else if (keyCode == -5) {
                    SoftkeyContainer.this.getMiddleSoftkey().switchState(SoftkeyContainer.MIDDLE_DOWN);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void simulateMiddleSoftkeyReleased() {
        if (SystemProperties.getPhonePlatform() != 2) {
            this.getMiddleSoftkey().switchState(MIDDLE_UP);
        }
    }

    public void setSoftkeyEnabled(int keyCode, boolean isEnabled) {
        if (keyCode == -6) {
            this.getLeftSoftkey().setEnabled(isEnabled);
        } else if (keyCode == -7) {
            this.getRightSoftkey().setEnabled(isEnabled);
        }
    }
}

