/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.list.Item;
import com.sonyericsson.fifa.view.components.list.ListItemMore;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;

public abstract class AbstractAboutForm
extends BaseForm {
    private Container bodyContainer = null;
    private AboutListItemMore button = null;
    private TextArea aboutText = null;
    private String mainText = null;
    private String buttonLabel = null;
    private SelectableItemListener selectListener = null;

    public AbstractAboutForm(String mainText, String buttonLabel) {
        this.mainText = mainText;
        this.buttonLabel = buttonLabel;
        this.getBodyContainer().addComponent("Center", (Component)this.getAboutTextArea());
        if (buttonLabel != null) {
            this.getBodyContainer().addComponent("South", (Component)this.getButton());
        }
        this.addComponent(this.getBodyContainer());
        this.setSoftkeys();
    }

    public AbstractAboutForm(String mainText, String buttonLabel, Action buttonAction) {
        this(mainText, buttonLabel);
        this.getButton().setAction(buttonAction);
    }

    private void setSoftkeys() {
        try {
            this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
            this.setSoftkeyBgImage();
            this.addSoftkey();
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    public AbstractAboutForm(String mainText) {
        this(mainText, null);
    }

    private Container getBodyContainer() {
        if (this.bodyContainer == null) {
            this.bodyContainer = new Container();
            this.bodyContainer.setLayout(new BorderLayout());
            this.bodyContainer.setPreferredW(this.getAttributes().getWidth());
            this.bodyContainer.setPreferredH(this.getAttributes().getHeight() - this.getAttributes().getSoftKeyContainerGap());
            this.bodyContainer.getStyle().setBgImage(Images.getBackgroundImg());
        }
        return this.bodyContainer;
    }

    protected TextArea getAboutTextArea() {
        if (this.aboutText == null) {
            this.aboutText = new TextArea();
            this.setTextAreaStyle(this.aboutText.getStyle());
            this.setDescriptionTextAreaMarginFont(this.aboutText.getStyle());
            this.aboutText.setEditable(false);
            this.aboutText.setFocusable(true);
            this.aboutText.setFocusPainted(false);
            this.aboutText.setGrowByContent(true);
            this.aboutText.setText(this.mainText);
        }
        return this.aboutText;
    }

    protected AboutListItemMore getButton() {
        if (this.button == null) {
            this.button = new AboutListItemMore();
            this.button.setText(this.buttonLabel);
        }
        return this.button;
    }

    private void setTextAreaStyle(Style style) {
        style.setPadding(0, 0, 0, 7);
        style.setBgTransparency(0);
        style.setFgColor(0xFFFFFF);
        style.setBorder(Border.createEmpty());
    }

    private void setDescriptionTextAreaMarginFont(Style style) {
        style.setMargin(this.getAttributes().getSquadTitleMarginLeftRight(), this.getAttributes().getSquadTitleMarginLeftRight(), this.getAttributes().getSquadTitleMarginLeftRight(), 0);
        style.setFont(FifaResources.getFont("Font_SansSerif_Medium_Regular"));
    }

    public void setSelectableItemListener(SelectableItemListener selectableItemListener) {
        this.selectListener = selectableItemListener;
    }

    protected void notifySelectedItem(Item item) {
        if (this.selectListener != null) {
            this.selectListener.selectedItem(item.getAction());
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -5) {
            if (this.getButton().hasFocus()) {
                this.notifySelectedItem(this.getButton());
            }
        } else {
            super.keyPressed(keyCode);
        }
    }

    private Component searchInstance(Component cmp) {
        while (!(cmp instanceof ListItemMore)) {
            if ((cmp = cmp.getParent()) != null) continue;
            return null;
        }
        return cmp;
    }

    public void pointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            Component c = this.searchInstance(this.getComponentAt(x, y += this.attributes.getPointerPressedY()));
            if (c != null) {
                if (c instanceof Item && c.hasFocus()) {
                    this.notifySelectedItem((Item)c);
                } else {
                    c.requestFocus();
                }
            } else {
                super.pointerPressed(x, y -= this.attributes.getPointerPressedY());
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    class AboutListItemMore
    extends ListItemMore {
        AboutListItemMore() {
        }

        protected void focusGained() {
            super.focusGained();
            try {
                AbstractAboutForm.this.addMiddleSoftkey();
                AbstractAboutForm.this.setMiddleSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_SELECT_TXT"));
            }
            catch (ComponentException componentException) {
                // empty catch block
            }
        }

        protected void focusLost() {
            super.focusLost();
            AbstractAboutForm.this.removeMiddleSoftkey();
        }
    }
}

