/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.action.FifaWebSiteAction;
import com.sonyericsson.fifa.view.components.FifaTextArea;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.list.ListItemFifaButton;
import com.sonyericsson.fifa.view.components.list.ListItemMore;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import java.io.IOException;

public class ArticleForm
extends BaseForm {
    private static final String LABEL_SELECT = FifaResources.getMessage("FANAPP_SK_SELECT_TXT");
    private static final String LABEL_VIEW = FifaResources.getMessage("RSS_VIEW_MSK");
    private TextArea titleText = null;
    private FifaTextArea descriptionText = null;
    private Container headerContainer = null;
    private Container bodyContainer = null;
    private Container bottomContainer = null;
    private Label picture = null;
    private ListItemFifaButton fifaButton = null;
    private Component selectedComponent = null;

    public ArticleForm() {
        this.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
        this.getStyle().setBgColor(0);
        this.getHeaderContainer().addComponent(this.getPicture());
        this.getHeaderContainer().addComponent(this.getTitleTextArea());
        this.getBodyContainer().addComponent(this.getHeaderContainer());
        this.getBodyContainer().addComponent(this.getLineDivider());
        this.getBodyContainer().addComponent(this.getDescriptionTextArea());
        this.getBottomContainer().addComponent(this.getFifaButton());
        if (SystemProperties.getPhonePlatform() == 2) {
            this.getBottomContainer().addComponent(this.getLineDivider());
            this.getBottomContainer().addComponent(this.getViewButton());
        } else {
            this.getBottomContainer().addComponent(this.getFakeItem());
        }
        this.addComponent(this.getBodyContainer());
        this.addComponent(this.getBottomContainer());
        this.setSoftkeys();
        this.setScrollableY(true);
    }

    private ListItemFifaButton getFifaButton() {
        if (this.fifaButton == null) {
            this.fifaButton = new ListItemFifaButton();
            this.fifaButton.setAction(new FifaWebSiteAction());
        }
        return this.fifaButton;
    }

    private Container getFakeItem() {
        Container fakeItem = new Container();
        try {
            Image bg = Image.createImage(IOUtility.getImageFromRES("other_item_bg.png"));
            fakeItem.getStyle().setBgImage(bg);
            fakeItem.setPreferredSize(new Dimension(VerifyScreenDimension.getAttributesInstance().getWidth(), VerifyScreenDimension.getAttributesInstance().getArticleFakeItemHeight()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fakeItem;
    }

    private void setSoftkeys() {
        this.addSoftkey();
        this.refreshSoftKeys();
    }

    public void clearLeftSoftKeyBkGround() {
        this.getSoftkeyComponent().clearSoftkeyBkGround();
    }

    public void refreshSoftKeys() {
        try {
            if (SystemProperties.getPhonePlatform() == 2) {
                this.setLeftSoftkeyLabel(FifaResources.getMessage("FANAPP_SHARE_SK_TXT"));
                this.setMiddleSoftkeyLabel(null);
                this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
                this.setSoftkeyEnabled(-6, true);
            } else {
                this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
                this.setMiddleSoftkeyLabel(FifaResources.getMessage("RSS_VIEW_MSK"));
                this.setLeftSoftkeyLabel(FifaResources.getMessage("FANAPP_SHARE_SK_TXT"));
                this.setSoftkeyEnabled(-6, true);
            }
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    public void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        if (keyCode == -1 || keyCode == -2) {
            try {
                if (this.getFifaButton().hasFocus()) {
                    this.setMiddleSoftkeyLabel(LABEL_SELECT);
                } else {
                    this.setMiddleSoftkeyLabel(LABEL_VIEW);
                }
            }
            catch (ComponentException componentException) {
                // empty catch block
            }
        }
    }

    public Component getFocusedComponent() {
        if (this.getFifaButton().hasFocus()) {
            return this.getFifaButton();
        }
        return null;
    }

    public void pointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            Attributes attributes = VerifyScreenDimension.getAttributesInstance();
            Component c = this.getComponentAt(x, y += attributes.getPointerPressedY());
            if (c != null) {
                if (c.hasFocus()) {
                    if (c instanceof ListItemMore || c instanceof ListItemFifaButton) {
                        this.selectedComponent = c;
                    }
                } else {
                    c.requestFocus();
                    this.selectedComponent = null;
                }
            } else {
                this.selectedComponent = null;
            }
            super.pointerPressed(x, y);
        }
    }

    private Container getHeaderContainer() {
        if (this.headerContainer == null) {
            this.headerContainer = new Container();
            this.headerContainer.setLayout(new BoxLayout(1));
            this.headerContainer.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getSquadHeaderHeight()));
            this.headerContainer.getStyle().setMargin(0, 0, 0, 0);
            this.headerContainer.setFocusable(false);
        }
        return this.headerContainer;
    }

    private Container getBodyContainer() {
        if (this.bodyContainer == null) {
            this.bodyContainer = new Container();
            this.bodyContainer.setLayout(new BoxLayout(2));
            this.bodyContainer.setPreferredW(this.getAttributes().getArticleBodyContainerWidth());
            this.bodyContainer.setPreferredH(this.getAttributes().getArticleBodyContainerHeight());
            this.bodyContainer.getStyle().setBgImage(Images.getBackgroundImg());
        }
        return this.bodyContainer;
    }

    private Container getBottomContainer() {
        if (this.bottomContainer == null) {
            this.bottomContainer = new Container();
            this.bottomContainer.setLayout(new BoxLayout(2));
            this.bottomContainer.setY(this.getBodyContainer().getPreferredH());
        }
        return this.bottomContainer;
    }

    private Label getLineDivider() {
        Label lineDivider = new Label();
        lineDivider.getStyle().setBgTransparency(0);
        lineDivider.setIcon(Images.getLitsDividerImg());
        lineDivider.getStyle().setMargin(0, 0, 0, 0);
        lineDivider.getStyle().setPadding(0, 0, 0, 0);
        lineDivider.setFocusable(false);
        return lineDivider;
    }

    private Label getPicture() {
        if (this.picture == null) {
            this.picture = new Label();
            this.picture.getStyle().setBgImage(Images.getArticlePhotoFrame());
            this.picture.setFocusable(false);
            this.picture.getStyle().setBgTransparency(0);
            this.picture.setPreferredW(this.getAttributes().getSquadPictureDimension() - 2);
            this.picture.setPreferredH(this.getAttributes().getSquadPictureDimension() - 2);
            this.picture.getStyle().setMargin(this.getAttributes().getListItemPictureTop(), this.getAttributes().getListItemPictureBotton(), this.getAttributes().getListItemPictureLeft(), this.getAttributes().getListItemPictureRight());
            this.picture.getStyle().setPadding(0, 0, 1, 0);
        }
        return this.picture;
    }

    private TextArea getTitleTextArea() {
        if (this.titleText == null) {
            this.titleText = new TextArea();
            this.setTitleTextAreaMarginFont(this.titleText.getStyle());
            this.setTextAreaStyle(this.titleText.getStyle());
            this.titleText.setPreferredSize(new Dimension(this.getAttributes().getSquadTitleWidth(), this.getAttributes().getSquadTitleHeight()));
            this.titleText.setRows(4);
            this.titleText.setEditable(false);
            this.titleText.setFocusable(false);
            this.titleText.setGrowByContent(false);
            this.titleText.setText("Loading...");
        }
        return this.titleText;
    }

    private FifaTextArea getDescriptionTextArea() {
        if (this.descriptionText == null) {
            this.descriptionText = new FifaTextArea();
            this.setTextAreaStyle(this.descriptionText.getStyle());
            this.setDescriptionTextAreaMarginFont(this.descriptionText.getStyle());
            this.descriptionText.setEditable(false);
            this.descriptionText.setFocusable(true);
            this.descriptionText.setFocusPainted(false);
            this.descriptionText.setGrowByContent(true);
            this.descriptionText.setText("Loading...");
        }
        return this.descriptionText;
    }

    private ListItemMore getViewButton() {
        ListItemMore viewButton = new ListItemMore();
        viewButton.getStyle().setBgImage(Images.getBackgroundImg());
        viewButton.setText(FifaResources.getMessage("RSS_VIEW_MSK"));
        return viewButton;
    }

    private void setTitleTextAreaMarginFont(Style style) {
        style.setMargin(this.getAttributes().getSquadTitleMarginTopBottom(), this.getAttributes().getSquadTitleMarginTopBottom(), this.getAttributes().getSquadTitleMarginLeftRight(), this.getAttributes().getSquadTitleMarginLeftRight());
        style.setFont(FifaResources.getFont("Font_SansSerif_Medium_Bold"));
    }

    private void setDescriptionTextAreaMarginFont(Style style) {
        style.setMargin(this.getAttributes().getSquadTitleMarginLeftRight(), this.getAttributes().getSquadTitleMarginLeftRight(), this.getAttributes().getSquadTitleMarginLeftRight(), 0);
        style.setFont(FifaResources.getFont("Font_SansSerif_Medium_Regular"));
    }

    private void setTextAreaStyle(Style style) {
        style.setPadding(0, 0, 0, 7);
        style.setBgTransparency(0);
        style.setFgColor(0xFFFFFF);
        style.setBorder(Border.createEmpty());
    }

    public void setTitle(String text) {
        this.getTitleTextArea().setText(SystemProperties.clearHtmlString(text));
    }

    public void setDescription(String text) {
        this.getDescriptionTextArea().setText(SystemProperties.clearHtmlString(text));
    }

    public void setPicture(String picturePath) throws IOException {
        Image img = Image.createImage(IOUtility.openFileInputStream(picturePath));
        img = img.scaled(this.getAttributes().getSquadPictureDimension() - 4, this.getAttributes().getSquadPictureDimension() - 4);
        this.getPicture().setIcon(img);
    }

    public void setPicture(Image picture) {
        picture = picture.scaled(this.getAttributes().getSquadPictureDimension() - 4, this.getAttributes().getSquadPictureDimension() - 4);
        this.getPicture().setIcon(picture);
    }

    public Component getSelectedComponent() {
        return this.selectedComponent;
    }

    public void refreshAll() {
        this.refreshSoftKeys();
    }
}

