/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.list.Item;
import com.sonyericsson.fifa.view.components.list.ListComponentsContainer;
import com.sonyericsson.fifa.view.components.list.ListItem;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.geom.Dimension;
import java.util.Vector;

public class ChangeTeamForm
extends BaseForm {
    private SelectableItemListener selectListener = null;
    private ListComponentsContainer listTeams = null;
    private static final int FIRST_TITLE_TOP = 18;

    public ChangeTeamForm() {
        Container container = new Container();
        container.addComponent(this.getTeamList());
        container.setPreferredSize(new Dimension(this.attributes.getWidth(), this.attributes.getTabContentHeight() + this.attributes.getTabsMenuHeight()));
        this.addComponent(container);
        this.setSoftkeyLabel();
        this.addSoftkey();
    }

    public void setSelectedItemListener(SelectableItemListener selectListener) {
        this.selectListener = selectListener;
    }

    public void keyPressed(int keyCode) {
        this.getTeamList().keyPressed(keyCode);
        if (keyCode == -5) {
            this.selectedItem = this.getTeamList().getSelectedItem();
        }
        super.keyPressed(keyCode);
    }

    public void keyReleased(int keyCode) {
        if (keyCode == -5 && this.selectedItem != null) {
            this.notifySelectedItem(this.selectedItem);
            this.selectedItem = null;
        }
        super.keyReleased(keyCode);
    }

    public void pointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            int action = this.getTeamList().verifyPointerPressed(x, y);
            if (action == 2) {
                this.selectedItem = this.getTeamList().getSelectedItem();
            }
            super.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        if (this.selectedItem != null) {
            this.notifySelectedItem(this.selectedItem);
            this.selectedItem = null;
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    public void addNewTeam(String group, String titleText, String iconPath, Action action) {
        this.getTeamList().addItem(group, this.newListItem(titleText, iconPath, action));
    }

    private ListComponentsContainer getTeamList() {
        if (this.listTeams == null) {
            this.listTeams = new ListComponentsContainer();
        }
        return this.listTeams;
    }

    private void notifySelectedItem(Item item) {
        if (this.selectListener != null) {
            this.selectListener.selectedItem(item.getAction());
        }
    }

    private ListItem newListItem(String titleText, String iconPath, Action action) {
        ListItem listItem = new ListItem();
        listItem.setListItemDimension(this.attributes.getListItemWidth(), this.attributes.getListItemHeight());
        listItem.setTitleText(titleText);
        listItem.setPicture(String.valueOf(FifaResources.getImageFolder()) + iconPath + ".png");
        listItem.setTitlePadding(0, 18);
        listItem.setAction(action);
        return listItem;
    }

    private void setSoftkeyLabel() {
        try {
            this.setMiddleSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_SELECT_TXT"));
            this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    public void addGroup(Vector groupName) {
        int count = groupName.size();
        int i = 0;
        while (i < count) {
            this.getTeamList().addGroup(false, groupName.elementAt(i).toString());
            ++i;
        }
    }

    public void refreshAll() {
        this.getTeamList().removeAllComponents(false);
        this.getTeamList().removeCountryDataItem();
        this.setSoftkeyLabel();
    }

    public void focusFirstItem(String groupName) {
        this.getTeamList().focusFirstItem(groupName);
        this.scrollComponentToVisible(this.getTeamList().getFirstComponent(groupName, false));
    }

    public boolean isTeamItems() {
        return this.getTeamList().isGroupEmpty();
    }
}

