/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.action.UserAuthAction;
import com.sonyericsson.fifa.view.components.FifaTextAreaCentered;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;

public class DialogForm
extends BaseForm {
    private FifaTextAreaCentered textArea = null;
    private FifaTextAreaCentered AdditionaltextArea = null;
    private Container background = null;
    private String message = null;
    private String additionalComment = null;
    private int viewId;
    private SelectableItemListener selectListener = null;
    public static final int DIALOG_YESNO_VIEW_ID = 18;
    public static final int YES_OPTION = 1;
    public static final int NO_OPTION = 2;
    public static final int COLOR_ADDITIONAL_COMMENT = 8885637;

    public DialogForm(String message, int viewId) {
        this.message = message;
        this.viewId = viewId;
        this.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
    }

    public DialogForm(String message, String additionalComment, int viewId) {
        this.message = message;
        this.additionalComment = additionalComment;
        this.viewId = viewId;
        this.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
    }

    public void addComponents() {
        block11: {
            this.initBackground();
            this.initTextArea();
            if (this.hasAdditionalComment()) {
                this.initAdditionalText();
            }
            this.addComponent(this.background);
            this.addSoftkey();
            if (this.viewId == 18) {
                try {
                    if (SystemProperties.getPhonePlatform() == 2) {
                        this.setLeftSoftkeyLabel(FifaResources.getMessage("FANAPP_YES_TXT"));
                        this.setMiddleSoftkeyLabel(null);
                        this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_NO_TXT"));
                        this.setSoftkeyEnabled(-6, true);
                        break block11;
                    }
                    this.setMiddleSoftkeyLabel(FifaResources.getMessage("FANAPP_YES_TXT"));
                    this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_NO_TXT"));
                }
                catch (ComponentException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    if (SystemProperties.getPhonePlatform() == 2) {
                        this.setMiddleSoftkeyLabel(null);
                        this.setRightSoftkeyLabel(FifaResources.getMessage("FIFA_MSK_OK_SK"));
                    } else {
                        this.setMiddleSoftkeyLabel(FifaResources.getMessage("FIFA_MSK_OK_SK"));
                        this.setRightSoftkeyLabel(null);
                        this.setSoftkeyEnabled(-7, false);
                    }
                }
                catch (ComponentException e) {
                    e.printStackTrace();
                }
            }
        }
        this.background.addComponent(this.textArea);
        if (this.hasAdditionalComment()) {
            this.background.addComponent(this.AdditionaltextArea);
        }
    }

    public void refreshAll() {
        if (this.background.getComponentCount() > 0) {
            this.background.removeAll();
        }
        this.removeComponent(this.background);
    }

    public void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        if (this.viewId == 18) {
            if (SystemProperties.getPhonePlatform() == 2) {
                if (keyCode == -6) {
                    this.notifySelectedItem(1);
                } else if (keyCode == -7) {
                    this.notifySelectedItem(2);
                }
            } else if (keyCode == -5) {
                this.notifySelectedItem(1);
            } else if (keyCode == -7) {
                this.notifySelectedItem(2);
            }
        } else if (keyCode == -5) {
            this.notifySelectedItem(1);
        }
    }

    public void setSelectedItemListener(SelectableItemListener selectListener) {
        this.selectListener = selectListener;
    }

    private void notifySelectedItem(int item) {
        if (this.selectListener != null) {
            UserAuthAction action = new UserAuthAction();
            if (item == 2) {
                action.setAuthorization((byte)2);
            } else {
                action.setAuthorization((byte)1);
            }
            this.selectListener.selectedItem(action);
        }
    }

    private void initTextArea() {
        this.textArea = new FifaTextAreaCentered();
        this.setTextAreaStyle(this.textArea.getStyle());
        if (this.hasAdditionalComment()) {
            this.textArea.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight() / 2));
            this.textArea.getStyle().setPadding(this.attributes.getDialogAdditionalTextPosY(), 0, 15, 20);
        } else {
            this.textArea.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
            this.textArea.getStyle().setPadding(this.attributes.getDialogOkTextPosY(), 0, 15, 20);
        }
        this.textArea.setRows(10);
        this.textArea.setEditable(false);
        this.textArea.setFocusable(false);
        this.textArea.setGrowByContent(false);
        this.textArea.setText(FifaResources.getMessage(this.message));
    }

    private void initAdditionalText() {
        this.AdditionaltextArea = new FifaTextAreaCentered();
        this.setTextAreaStyle(this.AdditionaltextArea.getStyle());
        this.AdditionaltextArea.getStyle().setFgColor(8885637);
        this.AdditionaltextArea.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight() / 2));
        this.AdditionaltextArea.getStyle().setPadding(this.attributes.getDialogAdditionalTextPosY(), 0, 15, 20);
        this.AdditionaltextArea.setRows(10);
        this.AdditionaltextArea.setEditable(false);
        this.AdditionaltextArea.setFocusable(false);
        this.AdditionaltextArea.setGrowByContent(false);
        this.AdditionaltextArea.setText(FifaResources.getMessage(this.additionalComment));
    }

    private Container initBackground() {
        this.background = new Container();
        this.background.setLayout(new BoxLayout(2));
        this.background.setPreferredW(this.getAttributes().getWidth());
        this.background.setPreferredH(this.getAttributes().getHeight());
        this.background.getStyle().setBgTransparency(160);
        this.background.getStyle().setBgColor(0);
        this.background.setY(0);
        return this.background;
    }

    private void setTextAreaStyle(Style style) {
        style.setMargin(0, 0, 0, 0);
        style.setBgColor(0);
        style.setBgTransparency(0);
        style.setFgColor(0xFFFFFF);
        style.setFont(FifaResources.getFont("Font_SansSerif_Small_Bold"));
        style.setBorder(Border.createEmpty());
    }

    private boolean hasAdditionalComment() {
        boolean hasAdditional = false;
        if (this.additionalComment != null) {
            hasAdditional = true;
        }
        return hasAdditional;
    }
}

