/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.list.CountryDataItem;
import com.sonyericsson.fifa.view.components.list.Item;
import com.sonyericsson.fifa.view.components.list.ListComponentsContainer;
import com.sonyericsson.fifa.view.components.list.ListItem;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import java.io.IOException;
import java.util.Vector;

public class ListItemsForm
extends BaseForm {
    protected ListComponentsContainer listComponents = new ListComponentsContainer();
    protected int subGroupHeight = 0;
    private SelectableItemListener selectListener = null;

    public ListItemsForm() {
        Container container = new Container();
        container.addComponent(this.listComponents);
        container.setPreferredSize(new Dimension(this.attributes.getWidth(), this.attributes.getTabContentHeight() + this.attributes.getTabsMenuHeight()));
        this.addComponent(container);
        this.setSoftkeyLabel();
        this.addSoftkey();
    }

    protected void setSoftkeyLabel() {
        try {
            this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
            if (SystemProperties.getPhonePlatform() != 2) {
                this.setMiddleSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_SELECT_TXT"));
            }
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    protected void addGroup(String groupName) {
        this.listComponents.addGroup(groupName);
    }

    protected void addItem(String subGroup, String titleText, String subtitleText, String iconPath, Action action) {
        this.listComponents.addItem(subGroup, this.newListItem(titleText, subtitleText, iconPath, action));
    }

    protected void addItem(String subGroup, String titleText, String subtitleText, Image icon, Action action) {
        this.listComponents.addItem(subGroup, this.newListItem(titleText, subtitleText, icon, action));
    }

    protected void addFifaButton(String subGroup) {
        this.listComponents.addFifaButton(subGroup);
    }

    protected void addItem(String subGroup, Component component) {
        try {
            this.listComponents.addItem(subGroup, component);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addItem(int componentIndex, String subGroup, Component component) {
        try {
            this.listComponents.addItem(componentIndex, subGroup, component);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addGroup(boolean anotherBg, String groupName) {
        this.listComponents.addGroup(anotherBg, groupName);
    }

    private CountryDataItem newCountryDataItem(String countryGroup, String countryFlagPath) {
        CountryDataItem countryData = null;
        if (countryFlagPath == null) {
            countryData = new CountryDataItem(countryGroup, null);
        } else {
            try {
                countryData = new CountryDataItem(countryGroup, Image.createImage(IOUtility.openFileInputStream(String.valueOf(FifaResources.getImageFolder()) + countryFlagPath + ".png")));
            }
            catch (IOException e) {
                Logger.logError(this.getClass(), "Exception to read image " + FifaResources.getImageFolder() + countryFlagPath + ".png");
            }
        }
        return countryData;
    }

    protected ListItem newListItem(String title, String subTitle, String picturePath, Action action) {
        ListItem item = this.createListItem(title, subTitle);
        item.setPicture(picturePath);
        item.setAction(action);
        return item;
    }

    protected ListItem newListItem(String title, String subTitle, Image picture, Action action) {
        ListItem item = this.createListItem(title, subTitle);
        item.setPicture(picture);
        item.setAction(action);
        return item;
    }

    private ListItem createListItem(String title, String subTitle) {
        ListItem item = new ListItem();
        item.setListItemDimension(this.getAttributes().getListItemWidth(), this.getAttributes().getListItemHeight());
        item.setTitleText(SystemProperties.clearHtmlString(title));
        if (subTitle == null) {
            item.setTitlePadding(0, this.getAttributes().getListItemTopMoreExtras());
        } else {
            item.setTitlePadding(0, this.getAttributes().getListItemTop());
            item.setSubtitleText(SystemProperties.clearHtmlString(subTitle));
        }
        item.setFocusable(true);
        return item;
    }

    protected void setCrossfadeHeadline(String[] imagesPath, int borderType, int posX) {
        this.listComponents.setCrossfadeHeadline(imagesPath, borderType);
    }

    protected void setCrossfadeHeadline(Vector images, int borderType) {
        this.listComponents.setCrossfadeHeadline(images, borderType);
    }

    protected void setFlagHeadline(String teamCode) {
        this.listComponents.setFlagHeadline(teamCode);
    }

    protected void showWaitIndicator(String subGroup, int height) {
        this.listComponents.showWaitIndicator(subGroup, height);
    }

    public void addCountryDataItemToFlag(String countryGroup, String countryFlagPath) {
        this.listComponents.addCountryDataItemToFlag(this.newCountryDataItem(countryGroup, countryFlagPath));
    }

    public void setSelectableItemListener(SelectableItemListener selectableItemListener) {
        this.selectListener = selectableItemListener;
    }

    public void setItemPicture(String subGroup, int itemIndex, String picturePath) {
        this.listComponents.setItemPicture(subGroup, itemIndex, picturePath);
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -5) {
            this.selectedItem = this.listComponents.getSelectedItem();
        }
        super.keyPressed(keyCode);
    }

    public void keyReleased(int keyCode) {
        if (keyCode == -5 && this.selectedItem != null) {
            this.notifySelectedItem(this.selectedItem);
            this.selectedItem = null;
        }
        super.keyReleased(keyCode);
    }

    private void notifySelectedItem(Item item) {
        if (this.selectListener != null) {
            this.selectListener.selectedItem(item.getAction());
        }
    }

    public void removeAll(String subgroupName) {
        this.listComponents.removeAll(subgroupName);
    }

    public void removeWaitIndicator(String subgroupName) {
        this.listComponents.removeWaitIndicator(subgroupName);
    }

    public void pointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            int action = this.listComponents.verifyPointerPressed(x, y);
            if (action == 2) {
                this.selectedItem = this.listComponents.getSelectedItem();
            }
            super.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        if (this.selectedItem != null) {
            this.notifySelectedItem(this.selectedItem);
            this.selectedItem = null;
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    public void refreshAll(boolean removeHeadline) {
        this.listComponents.removeAllComponents(removeHeadline);
        this.setSoftkeyLabel();
    }

    public void focusFirstItem(String groupName) {
        this.listComponents.focusFirstItem(groupName);
        this.scrollComponentToVisible(this.listComponents.getFirstComponent(groupName, true));
    }

    protected void fillEmptySpace(String groupName) {
        this.listComponents.fillEmptySpaceWithoutCrossfade(groupName);
    }

    protected void fillEmptySpaceWithTeamFlag(String groupName) {
        this.listComponents.fillEmptySpaceWithTeamFlag(groupName);
    }
}

