/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.ChangeTeamAction;
import com.sonyericsson.fifa.view.action.MoreExtrasSelected;
import com.sonyericsson.fifa.view.action.MoreSelectedAction;
import com.sonyericsson.fifa.view.action.OpenExtraVideosAction;
import com.sonyericsson.fifa.view.action.OptionsAction;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.list.Item;
import com.sonyericsson.fifa.view.components.list.ListItemButton;
import com.sonyericsson.fifa.view.components.list.ListItemMore;
import com.sonyericsson.fifa.view.components.listener.KeyListener;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sonyericsson.fifa.view.components.listener.TouchListener;
import com.sonyericsson.fifa.view.components.tabs.TabsManager;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import java.util.Vector;

public class MainForm
extends BaseForm {
    private SelectableItemListener selectListener = null;
    public static final int ID_MY_TEAM = 0;
    public static final int ID_TOURNAMENT = 1;
    public static final int ID_ENTERTAINMENT = 2;
    private TabsManager tabsManager = null;

    public MainForm() {
        this.addComponent(this.getTabsManager());
        this.addSoftkey();
    }

    public void setSoftKeyLabel(int tabIndex) {
        try {
            if (tabIndex == 0) {
                this.setLeftSoftkeyLabel(FifaResources.getMessage("FANAPP_UPDATE_SK"));
                this.setSoftkeyEnabled(-6, true);
            } else {
                this.setLeftSoftkeyLabel(null);
                this.setSoftkeyEnabled(-6, false);
            }
            this.setMiddleSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_SELECT_TXT"));
            this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    private TabsManager getTabsManager() {
        if (this.tabsManager == null) {
            this.tabsManager = new TabsManager();
        }
        return this.tabsManager;
    }

    private void notifySelectedItem(Item item) {
        if (this.selectListener != null) {
            this.selectListener.selectedItem(item.getAction());
        }
    }

    private ListItemButton getChangeTeamItem() {
        ListItemButton changeTeam = new ListItemButton(false, true);
        changeTeam.setListItemLayout();
        changeTeam.setPreferredH(this.getAttributes().getListItemHeight() - 5);
        changeTeam.setText(FifaResources.getMessage("FANAPP_MYTEAM_TITLE_CHANGE_TEAM_TXT"));
        changeTeam.setAction(new ChangeTeamAction());
        return changeTeam;
    }

    public void setKeyListener(KeyListener keyListener) {
        super.setKeyListener(keyListener);
    }

    public void addSelectedItemListener(SelectableItemListener selectableListener) {
        this.selectListener = selectableListener;
    }

    public void removeSelectedItemListener(SelectableItemListener selectableListener) {
        this.selectListener = null;
    }

    public void setTouchListener(TouchListener touchListener) {
        super.setTouchListener(touchListener);
    }

    public void pointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            int action = this.getTabsManager().verifyPointerPressed(x, y);
            if (action == -1) {
                super.pointerPressed(x, y);
            } else if (action == 2) {
                this.selectedItem = this.getTabsManager().getSelectedItem();
            } else {
                this.notifyTouchPressed(0, action);
            }
        }
        this.setSoftKeyLabel(this.getTabsManager().getCurrentTab());
    }

    public void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        if (this.selectedItem != null) {
            this.notifySelectedItem(this.selectedItem);
            this.selectedItem = null;
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -5) {
            this.selectedItem = this.getTabsManager().getSelectedItem();
            super.keyPressed(keyCode);
        } else if (this.getTabsManager().verifyKeyPressed(keyCode)) {
            super.keyPressed(keyCode);
        }
    }

    public void show() {
        this.setSoftKeyLabel(this.getTabsManager().getCurrentTab());
        super.show();
    }

    public void keyReleased(int keyCode) {
        super.keyReleased(keyCode);
        if (keyCode == -5 && this.selectedItem != null) {
            this.notifySelectedItem(this.selectedItem);
            this.selectedItem = null;
        }
    }

    public void addItem(int tabIndex, String subGroup, String titleText, String subtitleText) {
        this.getTabsManager().addItem(tabIndex, subGroup, titleText, subtitleText);
    }

    public void addFeedTicker(boolean status) {
        this.getTabsManager().addFeedTicker(status);
    }

    public void removeFeedTicker() {
        this.getTabsManager().removeFeedTicker();
    }

    public boolean isTickerFinished() {
        return this.getTabsManager().isFeedTickerFinished();
    }

    public void addFifaButton() {
        this.getTabsManager().showFifaButton(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"));
    }

    public void addMoreItem(String teamCode) {
        MoreSelectedAction action = new MoreSelectedAction(teamCode);
        this.getTabsManager().addItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), this.createMoreButton(FifaResources.getMessage("FANAPP_MYTEAM_MORE_TXT"), action));
    }

    public void addChangeTeamItem() {
        this.getTabsManager().addItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TEAM_TXT"), this.getChangeTeamItem());
    }

    public void addOptionsItem() {
        OptionsAction action = new OptionsAction();
        this.getTabsManager().addItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TEAM_TXT"), this.createMoreButton(FifaResources.getMessage("FANAPP_OPTIONS_TXT"), action));
    }

    public void addMoreExtrasItem() {
        MoreExtrasSelected action = new MoreExtrasSelected();
        this.getTabsManager().addItem(2, FifaResources.getMessage("FANAPP_EXTRAS_TXT"), this.createMoreButton(FifaResources.getMessage("FANAPP_MORE_EXTRAS_TXT"), action));
    }

    public void fillEmptySpace(int tab) {
        this.getTabsManager().fillEmptySpace(tab);
    }

    public void setItemPicture(int itemIndex, String picturePath) {
        this.getTabsManager().setItemPicture(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), itemIndex, picturePath);
    }

    public void addItem(int tabIndex, String subGroup, String titleText, String subtitleText, String iconPath, Action action) {
        this.getTabsManager().addItem(tabIndex, subGroup, titleText, subtitleText, iconPath, action);
    }

    public void addItem(int tabIndex, String subGroup, String titleText, String subtitleText, Image icon, Action action) {
        this.getTabsManager().addItem(tabIndex, subGroup, titleText, subtitleText, icon, action);
    }

    public void addExtraVideosItem() {
        OpenExtraVideosAction action = new OpenExtraVideosAction();
        this.getTabsManager().addItem(2, FifaResources.getMessage("FANAPP_ENTERTAINMENT_VIDEOS_TXT"), this.createMoreButton(FifaResources.getMessage("FANAPP_DOWNLOADABLE_VIDEOS_TXT"), action));
    }

    private ListItemMore createMoreButton(String text, Action action) {
        ListItemMore more = new ListItemMore();
        more.setText(text);
        more.setAction(action);
        return more;
    }

    public void myTeamRemoveAll() {
        this.getTabsManager().removeWaitIndicator(0);
        this.getTabsManager().removeAll(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"));
        this.getTabsManager().removeAll(0, FifaResources.getMessage("FANAPP_MYTEAM_TEAM_TXT"));
        this.getTabsManager().removeFlagHeadline(0);
        this.getTabsManager().removeCountryDataItem(0);
    }

    public void setFlagHeadline(String teamCode) {
        this.getTabsManager().setFlagHeadline(0, teamCode);
    }

    public void setEntertainmentHeadline(String[] imagesPath) {
        this.getTabsManager().setCrossfadeHeadline(2, imagesPath, 1);
    }

    public void setCrossfadePosition(int tabIndex, int posX) {
        this.getTabsManager().setCrossfadePosition(tabIndex, posX);
    }

    public void startCrossfade(int subgroup) {
        this.getTabsManager().startCrossfade(subgroup, this);
    }

    public void pauseCrossfade(int subgroup) {
        this.getTabsManager().pauseCrossfade(subgroup, this);
    }

    public void addCountryDataItemToFlag(String countryGroup, String countryFlagPath) {
        this.getTabsManager().addCountryDataItemToFlag(0, countryGroup, countryFlagPath);
    }

    public void refreshAll(int tabIndex, boolean isLanguageChanged) {
        this.getTabsManager().removeAll(tabIndex);
        switch (tabIndex) {
            case 0: {
                this.getTabsManager().removeFlagHeadline(tabIndex);
                this.getTabsManager().removeCountryDataItem(tabIndex);
                this.myTeamAddGroups();
                break;
            }
            case 2: {
                this.entertainmentAddGroups();
                break;
            }
            default: {
                Logger.logError(this.getClass(), "Invalid tab index");
            }
        }
        if (isLanguageChanged) {
            this.setSoftKeyLabel(tabIndex);
        }
    }

    public void myTeamAddGroups() {
        this.getTabsManager().addGroup(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"));
        this.getTabsManager().addGroup(0, FifaResources.getMessage("FANAPP_MYTEAM_TEAM_TXT"));
    }

    public void tournamentAddGroups(Vector groupName) {
        int count = groupName.size();
        int i = 0;
        while (i < count) {
            this.getTabsManager().addGroup(1, false, groupName.elementAt(i).toString());
            ++i;
        }
    }

    public void entertainmentAddGroups() {
        this.getTabsManager().addGroup(2, FifaResources.getMessage("FANAPP_EXTRAS_TXT"));
        this.getTabsManager().addGroup(2, FifaResources.getMessage("FANAPP_ENTERTAINMENT_VIDEOS_TXT"));
    }

    public void removeWaitIndicator(int tabIndex) {
        this.getTabsManager().removeWaitIndicator(tabIndex);
    }

    public void showWaitIndicator(int tabIndex, String groupName) {
        this.getTabsManager().showWaitIndicator(tabIndex, groupName);
    }

    public void focusFirstItem(int tabIndex, String groupName, boolean scrollToHeadline) {
        this.getTabsManager().focusFirstItem(tabIndex, groupName);
        this.scrollComponentToVisible(this.getTabsManager().getFirstComponent(tabIndex, groupName, scrollToHeadline));
    }

    public boolean isFirstItemFocused(int tabIndex, String groupName) {
        return this.getTabsManager().isFirstItemFocused(tabIndex, groupName);
    }

    public boolean isGroupEmpty(int tabIndex) {
        return this.getTabsManager().isGroupEmpty(tabIndex);
    }

    public void setTab(int tabId) {
        this.getTabsManager().setCurrentTab(tabId);
    }

    protected void hideNotify() {
        super.hideNotify();
        this.pauseCrossfade(0);
        this.pauseCrossfade(2);
    }

    protected void showNotify() {
        super.showNotify();
        if (this.getTabsManager().getCurrentTab() == 0) {
            this.startCrossfade(0);
        } else if (this.getTabsManager().getCurrentTab() == 2) {
            this.startCrossfade(2);
        }
    }
}

