/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.action.AboutLicenseAction;
import com.sonyericsson.fifa.view.components.FifaCheckBox;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.list.Item;
import com.sonyericsson.fifa.view.components.list.ListItemButton;
import com.sonyericsson.fifa.view.components.list.ListItemMore;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import java.io.IOException;

public class OptionsForm
extends BaseForm {
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int COLOR_GREY = 0x909090;
    public static final int COLOR_GREYOUT = 0x606060;
    public static final int COLOR_BUTTON_GREYOUT = 0x414141;
    private static final String OTHER_TITLE_LIST = "other_title_list.png";
    public static final int MAIN_CONTAINER_SIZE = 540;
    public static final int DOWNLOAD_LABEL_SIZE = 30;
    private Container mainContainer = null;
    private Container textContainer = null;
    private Container homescreenContainer = null;
    private Container automaticUpdateContainer = null;
    private Container homeNetworkOnlyContainer = null;
    private Container mainDownloadContainer = null;
    private Container openSourceContainer = null;
    private static final String applicationName = FifaResources.getMessage("FANAPP_APPLICATION_NAME_TXT");
    private static final String mainLabel = FifaResources.getMessage("FANAPP_APPLICATION_NAME_VERSION_TXT");
    private static final String warningText = FifaResources.getMessage("FANAPP_WARNING_CONNECT_MSG_COST_TXT");
    private static final String homescreenCheckboxText = FifaResources.getMessage("FANAPP_HOMESCREEN_WIDGET_TXT");
    private static final String updateCheckboxText = FifaResources.getMessage("FANAPP_AUTOMATIC_UPDATES_TXT");
    private static final String infoUpdateCheckboxText = FifaResources.getMessage("FANAPP_AUTOMATIC_TIME_TXT");
    private static final String homeNetworkOnlyCheckboxText = FifaResources.getMessage("FANAPP_HOME_NETWORK_TXT");
    private static final String infoHomeNetworkOnlyCheckboxText = FifaResources.getMessage("FANAPP_HOME_UNCHECK_TXT");
    private static final String FANAPP_CHECK_FOR_UPGRADE_TXT = FifaResources.getMessage("FANAPP_CHECK_FOR_UPGRADE_TXT");
    private static final String FOOTBALL_FAN_WIDGET = FifaResources.getMessage("FANAPP_FOOTBALLFAN_WIDGET_TXT");
    private static final String buttonLabel = FifaResources.getMessage("FANAPP_OPEN_SOURCE_TXT");
    private Label footballFanVersionLabel = null;
    private TextArea warningCostText = null;
    private ListItemMore button = null;
    private ListItemButton downloadUgradeButton;
    private ListItemButton downloadUgradeWidgetButton;
    private SelectableItemListener selectListener = null;
    private FifaCheckBox homescreenCheckbox = null;
    private FifaCheckBox updateCheckbox = null;
    private FifaCheckBox homeNetworkOnlyCheckbox = null;
    private boolean isHomescreenCheckboxSelected;
    private boolean isHomeNetworkOnlyCheckboxSelected;
    private boolean isApplicationUpgradePressed;
    private boolean isWidgetUpgradePressed;
    private int platform = SystemProperties.getPhonePlatform();

    public OptionsForm() {
        this.getMainContainer().addComponent(this.getTextContainer());
        if (this.platform != 2) {
            this.getMainContainer().addComponent(this.getHomescreenContainer());
        }
        this.getMainContainer().addComponent(this.getFootballFanContainer());
        if (this.platform != 2) {
            this.getMainContainer().addComponent(this.getOpenSourceContainer());
        }
        this.addComponent(this.getMainContainer());
        if (this.platform == 2) {
            this.addComponent(this.getOpenSourceContainer());
        }
        this.setSoftkeys();
    }

    private Container getMainContainer() {
        if (this.mainContainer == null) {
            this.mainContainer = new Container();
            this.mainContainer.setScrollableY(true);
            this.mainContainer.setLayout(new BoxLayout(2));
            this.mainContainer.setPreferredW(this.getAttributes().getWidth());
            this.mainContainer.setPreferredH(540);
        }
        return this.mainContainer;
    }

    private Container getTextContainer() {
        if (this.textContainer == null) {
            this.textContainer = new Container();
            this.setContainerFormat(this.textContainer);
            this.textContainer.setPreferredH(this.getAttributes().getOptions_Text_Height());
            this.textContainer.getStyle().setBgImage(Images.getBackgroundImg());
            this.textContainer.getStyle().setBgColor(0xFFFF00);
            this.textContainer.addComponent(this.getFootballFanVersionLabel());
            this.textContainer.addComponent(this.getWarningCostTextArea());
        }
        return this.textContainer;
    }

    private Container getHomescreenContainer() {
        if (this.homescreenContainer == null) {
            this.homescreenContainer = new Container();
            Label homeScreenLabel = this.getGroupLabel(FOOTBALL_FAN_WIDGET);
            int height = homeScreenLabel.getPreferredH();
            this.setContainerFormat(this.homescreenContainer);
            this.homescreenContainer.addComponent(homeScreenLabel);
            this.homescreenContainer.addComponent(this.getDownloadUpgradeWidgetButton());
            this.homescreenContainer.addComponent(this.getHomescreenCheckBox());
            this.homescreenContainer.setPreferredH(height += this.getHomescreenCheckBox().getPreferredH() + this.getDownloadUpgradeWidgetButton().getPreferredH());
        }
        return this.homescreenContainer;
    }

    private Container getAutomaticUpdateContainer() {
        if (this.automaticUpdateContainer == null) {
            this.automaticUpdateContainer = new Container();
            this.setContainerFormat(this.automaticUpdateContainer);
            this.automaticUpdateContainer.setPreferredH(this.getAttributes().getOptions_Checkbox_Height());
            this.automaticUpdateContainer.getStyle().setBgImage(Images.getFakeItemBackground());
            this.automaticUpdateContainer.addComponent(this.getLineDivider());
            this.automaticUpdateContainer.addComponent(this.getUpdateCheckBox());
            this.automaticUpdateContainer.addComponent(this.getLineDivider());
        }
        return this.automaticUpdateContainer;
    }

    private Container getFootballFanContainer() {
        if (this.homeNetworkOnlyContainer == null) {
            Label groupLabel = this.getGroupLabel(applicationName);
            int height = groupLabel.getPreferredH();
            this.homeNetworkOnlyContainer = new Container();
            this.setContainerFormat(this.homeNetworkOnlyContainer);
            this.homeNetworkOnlyContainer.addComponent(groupLabel);
            this.homeNetworkOnlyContainer.addComponent(this.getDownloadUpgradeButton());
            height += this.getDownloadUpgradeButton().getPreferredH();
            if (this.platform == 2) {
                this.homeNetworkOnlyContainer.addComponent(this.getMainDownloadContainer());
                this.getMainDownloadContainer().setPreferredH(this.calculateHeight());
                height += this.getMainDownloadContainer().getPreferredH();
            } else {
                this.homeNetworkOnlyContainer.addComponent(this.getHomeNetworkOnlyCheckBox());
                height += this.getHomeNetworkOnlyCheckBox().getPreferredH();
            }
            this.homeNetworkOnlyContainer.setPreferredH(height);
        }
        return this.homeNetworkOnlyContainer;
    }

    private Container getOpenSourceContainer() {
        if (this.openSourceContainer == null) {
            this.openSourceContainer = new Container();
            this.setContainerFormat(this.openSourceContainer);
            this.openSourceContainer.setPreferredH(this.getAttributes().getOptions_Open_Source_Button_Height());
            this.openSourceContainer.getStyle().setBgImage(Images.getFakeItemBackground());
            if (buttonLabel != null) {
                if (2 == SystemProperties.getPhonePlatform()) {
                    this.openSourceContainer.addComponent(this.getLineDivider());
                }
                this.openSourceContainer.addComponent(this.getButton());
            }
        }
        return this.openSourceContainer;
    }

    private void setContainerFormat(Container container) {
        container.setScrollableY(false);
        container.setLayout(new BoxLayout(2));
        container.setPreferredW(this.getAttributes().getWidth());
        container.getStyle().setPadding(0, 0, 0, 0);
        container.getStyle().setMargin(0, 0, 0, 0);
    }

    private Label getLineDivider() {
        Label lineDivider = new Label();
        lineDivider.getStyle().setBgTransparency(0);
        lineDivider.setIcon(Images.getLitsDividerImg());
        lineDivider.getStyle().setMargin(0, 0, 0, 0);
        lineDivider.getStyle().setPadding(0, 0, 0, 0);
        lineDivider.setFocusable(false);
        return lineDivider;
    }

    private Label getFootballFanVersionLabel() {
        if (this.footballFanVersionLabel == null) {
            this.footballFanVersionLabel = new Label();
            this.footballFanVersionLabel.getStyle().setMargin(this.getAttributes().getSquadTitleMarginLeftRight(), 0, this.getAttributes().getSquadTitleMarginLeftRight(), 0);
            this.footballFanVersionLabel.getStyle().setFont(FifaResources.getFont("Font_SansSerif_Mini_Regular"));
            this.setOptionsStyle(this.footballFanVersionLabel.getStyle());
            this.footballFanVersionLabel.getStyle().setFgColor(0xFFFFFF);
            this.footballFanVersionLabel.setFocusable(false);
            this.footballFanVersionLabel.setText(String.valueOf(mainLabel) + SystemProperties.getMidletVersion());
        }
        return this.footballFanVersionLabel;
    }

    private TextArea getWarningCostTextArea() {
        if (this.warningCostText == null) {
            this.warningCostText = new TextArea();
            this.setOptionsStyle(this.warningCostText.getStyle());
            this.warningCostText.getStyle().setMargin(this.getAttributes().getSquadTitleMarginLeftRight(), 0, this.getAttributes().getSquadTitleMarginLeftRight(), 0);
            this.warningCostText.getStyle().setFont(FifaResources.getFont("Font_SansSerif_Mini_Regular"));
            this.warningCostText.getStyle().setFgColor(0x909090);
            this.warningCostText.setEditable(false);
            this.warningCostText.setFocusable(false);
            this.warningCostText.setFocusPainted(false);
            this.warningCostText.setGrowByContent(true);
            this.warningCostText.setRowsGap(0);
            this.warningCostText.setText(warningText);
        }
        return this.warningCostText;
    }

    private FifaCheckBox getHomescreenCheckBox() {
        if (this.homescreenCheckbox == null) {
            this.homescreenCheckbox = new FifaCheckBox(homescreenCheckboxText, null);
            this.homescreenCheckbox.getStyle().setBgImage(Images.getItemBackground());
            this.homescreenCheckbox.setSelected(this.isHomescreenCheckboxSelected);
            if (!SystemProperties.isHSInstalled()) {
                this.homescreenCheckbox.setFocusable(false);
                this.homescreenCheckbox.setEnabled(false);
            } else {
                this.homescreenCheckbox.setFocusable(true);
            }
        }
        return this.homescreenCheckbox;
    }

    private FifaCheckBox getUpdateCheckBox() {
        if (this.updateCheckbox == null) {
            this.updateCheckbox = new FifaCheckBox(updateCheckboxText, infoUpdateCheckboxText);
            this.updateCheckbox.setSelected(true);
            this.updateCheckbox.setFocusable(true);
        }
        return this.updateCheckbox;
    }

    private FifaCheckBox getHomeNetworkOnlyCheckBox() {
        if (this.homeNetworkOnlyCheckbox == null) {
            this.homeNetworkOnlyCheckbox = new FifaCheckBox(homeNetworkOnlyCheckboxText, infoHomeNetworkOnlyCheckboxText);
            this.homeNetworkOnlyCheckbox.getStyle().setBgImage(Images.getItemBackground());
            this.homeNetworkOnlyCheckbox.setSelected(this.isHomeNetworkOnlyCheckboxSelected);
            this.homeNetworkOnlyCheckbox.setFocusable(true);
            this.homeNetworkOnlyCheckbox.setPreferredH(this.getAttributes().getOptions_Checkbox_Height());
        }
        return this.homeNetworkOnlyCheckbox;
    }

    private Label getGroupLabel(String text) {
        Label groupLabel = new Label();
        try {
            groupLabel.getStyle().setBgImage(Image.createImage(IOUtility.getImageFromRES(OTHER_TITLE_LIST)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        groupLabel.setAlignment(4);
        groupLabel.getStyle().setMargin(0, 0, 0, 0);
        groupLabel.getStyle().setFgColor(0xFFFFFF);
        groupLabel.getStyle().setFont(FifaResources.getFont("Font_SansSerif_Large_Regular"));
        groupLabel.setFocusable(false);
        groupLabel.setText(text);
        this.setOptionsStyle(groupLabel.getStyle());
        return groupLabel;
    }

    private ListItemButton getDownloadUpgradeButton() {
        if (this.downloadUgradeButton == null) {
            this.downloadUgradeButton = new ListItemButton(false, true);
            this.downloadUgradeButton.setText(FANAPP_CHECK_FOR_UPGRADE_TXT);
            this.downloadUgradeButton.setLayout(new BoxLayout(2));
            this.downloadUgradeButton.getStyle().setBgImage(Images.getFirstItemBackground());
            this.downloadUgradeButton.setPreferredW(this.attributes.getWidth());
            this.downloadUgradeButton.setPreferredH(this.attributes.getOptions_Button_Height());
        }
        return this.downloadUgradeButton;
    }

    private ListItemButton getDownloadUpgradeWidgetButton() {
        if (this.downloadUgradeWidgetButton == null) {
            this.downloadUgradeWidgetButton = new ListItemButton(false, true);
            this.downloadUgradeWidgetButton.setText(FANAPP_CHECK_FOR_UPGRADE_TXT);
            this.downloadUgradeWidgetButton.setLayout(new BoxLayout(2));
            this.downloadUgradeWidgetButton.getStyle().setBgImage(Images.getFirstItemBackground());
            this.downloadUgradeWidgetButton.setPreferredW(this.attributes.getWidth());
            this.downloadUgradeWidgetButton.setPreferredH(this.attributes.getOptions_Button_Height());
        }
        return this.downloadUgradeWidgetButton;
    }

    private Container getMainDownloadContainer() {
        if (this.mainDownloadContainer == null) {
            this.mainDownloadContainer = new Container();
            this.setContainerFormat(this.mainDownloadContainer);
            this.mainDownloadContainer.getStyle().setBgImage(Images.getFakeItemBackground());
            this.getHomeNetworkOnlyCheckBox().getStyle().setBgImage(null);
            this.mainDownloadContainer.addComponent(this.getHomeNetworkOnlyCheckBox());
        }
        return this.mainDownloadContainer;
    }

    private int calculateHeight() {
        return 510 - (this.getTextContainer().getPreferredH() + this.getFootballFanContainer().getPreferredH() + this.getOpenSourceContainer().getPreferredH());
    }

    private void setOptionsStyle(Style style) {
        style.setPadding(0, 0, 0, 7);
        style.setBgTransparency(0);
        style.setBorder(Border.createEmpty());
    }

    public void show() {
        super.show();
        this.getDownloadUpgradeWidgetButton().requestFocus();
        this.getHomescreenCheckBox().setSelected(this.isHomescreenCheckboxSelected);
        this.getHomeNetworkOnlyCheckBox().setSelected(this.isHomeNetworkOnlyCheckboxSelected);
        this.getHomescreenCheckBox().repaint();
        this.getHomeNetworkOnlyCheckBox().repaint();
    }

    protected ListItemMore getButton() {
        if (this.button == null) {
            this.button = new ListItemMore();
            this.button.setText(buttonLabel);
            this.button.setAction(new AboutLicenseAction());
        }
        return this.button;
    }

    private void setSoftkeys() {
        this.addSoftkey();
        try {
            this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
            this.setMiddleSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_SELECT_TXT"));
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    public void setSelectableItemListener(SelectableItemListener selectableItemListener) {
        this.selectListener = selectableItemListener;
    }

    protected void notifySelectedItem(Item item) {
        if (this.selectListener != null) {
            this.selectListener.selectedItem(item.getAction());
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -5) {
            if (this.getButton().hasFocus()) {
                this.notifySelectedItem(this.getButton());
            } else if (this.getHomescreenCheckBox().hasFocus()) {
                this.getHomescreenCheckBox().keyPressed(keyCode);
                this.setHomescreenCheckBox(this.isHomescreenCheckboxSelected());
            } else if (this.getUpdateCheckBox().hasFocus()) {
                this.getUpdateCheckBox().keyPressed(keyCode);
            } else if (this.getHomeNetworkOnlyCheckBox().hasFocus()) {
                this.getHomeNetworkOnlyCheckBox().keyPressed(keyCode);
                this.setHomeNetworkOnlyCheckBox(this.isHomeNetworkOnlyCheckboxSelected());
            } else if (this.getDownloadUpgradeButton().hasFocus()) {
                this.getDownloadUpgradeButton().keyPressed(keyCode);
                this.setApplicationUgradeStatus(true);
                super.keyPressed(keyCode);
            } else if (this.getDownloadUpgradeWidgetButton().hasFocus()) {
                this.getDownloadUpgradeWidgetButton().keyPressed(keyCode);
                this.getHomescreenCheckBox().setSelected(false);
                this.getHomescreenCheckBox().setFocusable(true);
                this.getHomescreenCheckBox().setEnabled(true);
                this.setHomescreenCheckBox(false);
                if (SystemProperties.getPhonePlatform() != 2) {
                    this.setWidgetUgradeStatus(true);
                }
                super.keyPressed(keyCode);
            }
        } else {
            super.keyPressed(keyCode);
        }
    }

    public void pointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            Component c = this.searchInstance(this.getComponentAt(x, y));
            if (c != null) {
                if (c.hasFocus()) {
                    if (c instanceof FifaCheckBox) {
                        if (this.getUpdateCheckBox().hasFocus()) {
                            this.getUpdateCheckBox().setSelected();
                        } else if (this.getHomeNetworkOnlyCheckBox().hasFocus()) {
                            this.getHomeNetworkOnlyCheckBox().setSelected();
                            this.setHomeNetworkOnlyCheckBox(this.isHomeNetworkOnlyCheckboxSelected());
                        }
                    } else if (c instanceof ListItemButton) {
                        this.getDownloadUpgradeButton().pointerPressed(x, y);
                        this.setApplicationUgradeStatus(true);
                        super.pointerPressed(x, y);
                    } else if (c instanceof ListItemMore) {
                        this.notifySelectedItem((Item)c);
                    }
                } else {
                    c.requestFocus();
                }
            } else {
                super.pointerPressed(x, y);
            }
        }
    }

    Component searchInstance(Component cmp) {
        while (!(cmp instanceof FifaCheckBox || cmp instanceof ListItemButton || cmp instanceof ListItemMore)) {
            if (cmp != null) {
                cmp = cmp.getParent();
            }
            if (cmp != null) continue;
            return null;
        }
        return cmp;
    }

    public void setApplicationUgradeStatus(boolean pressed) {
        this.isApplicationUpgradePressed = pressed;
    }

    public boolean getApplicationUgradeStatus() {
        return this.isApplicationUpgradePressed;
    }

    public void setWidgetUgradeStatus(boolean pressed) {
        this.isWidgetUpgradePressed = pressed;
    }

    public boolean getWidgetUgradeStatus() {
        return this.isWidgetUpgradePressed;
    }

    public void setHomescreenCheckBox(boolean selected) {
        this.isHomescreenCheckboxSelected = selected;
    }

    public void setHomeNetworkOnlyCheckBox(boolean selected) {
        this.isHomeNetworkOnlyCheckboxSelected = selected;
    }

    public boolean isHomescreenCheckboxSelected() {
        boolean isSelected = false;
        if (this.homescreenCheckbox != null) {
            isSelected = this.homescreenCheckbox.isSelected();
        }
        return isSelected;
    }

    public boolean isUpdateCheckboxSelected() {
        boolean isSelected = false;
        if (this.updateCheckbox != null) {
            isSelected = this.updateCheckbox.isSelected();
        }
        return isSelected;
    }

    public boolean isHomeNetworkOnlyCheckboxSelected() {
        boolean isSelected = false;
        if (this.homeNetworkOnlyCheckbox != null) {
            isSelected = this.homeNetworkOnlyCheckbox.isSelected();
        }
        return isSelected;
    }
}

