/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.action.ChangeTeamAction;
import com.sonyericsson.fifa.view.components.FifaTextAreaCentered;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.list.Item;
import com.sonyericsson.fifa.view.components.list.ListItemButton;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;

public class WelcomeForm
extends BaseForm {
    private FifaTextAreaCentered textArea = null;
    private Container background = null;
    private ListItemButton changeTeam;
    private boolean notifySelectedItem = false;
    private SelectableItemListener selectListener = null;

    public WelcomeForm() {
        this.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
        this.addComponent(this.getBackground());
        this.getBackground().addComponent(this.getTextArea());
        this.getBackground().addComponent(this.getChangeTeamItem());
        this.setText(FifaResources.getMessage("FANAPP_MYTEAM1STTIME_INFO_CHOOSE_TXT"));
        this.setSoftkeyLabel();
        this.addSoftkey();
    }

    private FifaTextAreaCentered getTextArea() {
        if (this.textArea == null) {
            this.textArea = new FifaTextAreaCentered();
            this.setTextAreaStyle(this.textArea.getStyle());
            this.textArea.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getWelcomeTextAreaHeight()));
            this.textArea.setY(this.getAttributes().getWelcomeTextPosY());
            this.textArea.setRows(10);
            this.textArea.setEditable(false);
            this.textArea.setFocusable(false);
            this.textArea.setGrowByContent(false);
            this.textArea.setText("UNDEFINED");
        }
        return this.textArea;
    }

    private ListItemButton getChangeTeamItem() {
        if (this.changeTeam == null) {
            this.changeTeam = new ListItemButton(true, true);
            this.changeTeam.setPreferredSize(new Dimension(new Dimension(this.attributes.getWidth(), this.attributes.getChangeTeamHeight() + 5)));
            this.changeTeam.setListItemLayout();
            this.changeTeam.setText(FifaResources.getMessage("FANAPP_MYTEAM_TITLE_CHOOSE_TEAM_TXT"));
            this.changeTeam.setFocusable(true);
            this.changeTeam.setX(this.getAttributes().getChooseTeamWelcomePosX());
            this.changeTeam.setY(this.getAttributes().getChooseTeamWelcomePosY());
            this.changeTeam.setAction(new ChangeTeamAction());
        }
        return this.changeTeam;
    }

    private Container getBackground() {
        if (this.background == null) {
            this.background = new Container();
            this.background.setLayout(new CoordinateLayout(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
            this.background.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
            this.background.getStyle().setBgTransparency(160);
            this.background.getStyle().setBgColor(0);
            this.background.setY(0);
        }
        return this.background;
    }

    private void setTextAreaStyle(Style style) {
        style.setMargin(0, 0, 0, 0);
        style.setBgColor(0);
        style.setBgTransparency(0);
        style.setFgColor(0xFFFFFF);
        style.setFont(FifaResources.getFont("Font_SansSerif_Small_Regular"));
        style.setBorder(Border.createEmpty());
        style.setPadding(0, 0, this.attributes.getChangeTeamWelcomeLeftPadding(), this.attributes.getChangeTeamWelcomeRightPadding());
    }

    public void setText(String text) {
        this.getTextArea().setText(text);
    }

    public void setSelectableItemListener(SelectableItemListener selectableItemListener) {
        this.selectListener = selectableItemListener;
    }

    protected void notifySelectedItem(Item item) {
        if (this.selectListener != null) {
            this.selectListener.selectedItem(item.getAction());
        }
    }

    private Component searchInstance(Component cmp) {
        while (!(cmp instanceof ListItemButton)) {
            if ((cmp = cmp.getParent()) != null) continue;
            return null;
        }
        return cmp;
    }

    private void setSoftkeyLabel() {
        try {
            this.setMiddleSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_SELECT_TXT"));
            this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    public void pointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            Component c = this.searchInstance(this.getComponentAt(x, y));
            if (c != null) {
                if (c.hasFocus()) {
                    this.getChangeTeamItem().pointerPressed(x, y);
                    this.notifySelectedItem = true;
                } else {
                    c.requestFocus();
                }
            } else {
                super.pointerPressed(x, y);
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            if (this.getChangeTeamItem().hasFocus() && this.notifySelectedItem) {
                this.getChangeTeamItem().pointerReleased(x, y);
                this.notifySelectedItem(this.getChangeTeamItem());
                this.notifySelectedItem = false;
            }
            super.pointerReleased(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    public void refreshAll() {
        this.setSoftkeyLabel();
        this.setText(FifaResources.getMessage("FANAPP_MYTEAM1STTIME_INFO_CHOOSE_TXT"));
        this.getChangeTeamItem().setText(FifaResources.getMessage("FANAPP_MYTEAM_TITLE_CHOOSE_TEAM_TXT"));
    }

    public void simulateMiddleSoftkeyReleased() {
        this.getSoftkeyComponent().simulateMiddleSoftkeyReleased();
    }
}

