/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.components.Crossfade;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sonyericsson.fifa.view.components.list.CountryDataItem;
import com.sonyericsson.fifa.view.components.list.Item;
import com.sonyericsson.fifa.view.components.list.Title;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;
import com.sun.lwuit.plaf.Border;
import java.io.IOException;
import java.util.Vector;

class CrossfadeHeadline
extends Item {
    private Crossfade crossFade = null;
    private CountryDataItem countryData;
    private Attributes attributes = VerifyScreenDimension.getAttributesInstance();
    private static final int CROSSFADE_POSY = 6;
    private static final int TITLE_WIDTH = 234;
    private static final int TITLE_HEIGHT = 26;
    private static final String ICON_FRAME = "photo_frame.png";

    public CrossfadeHeadline() {
        this.setFocus(false);
        this.setFocusable(false);
        this.setPreferredSize(new Dimension(this.attributes.getHeadlineWidth(), this.attributes.getHeadlineCrossfadeHeight() + 14));
        this.setLayout(new CoordinateLayout(this.attributes.getHeadlineWidth(), this.attributes.getHeadlineCrossfadeHeight() + 14));
        FifaLookAndFeelManager.configToHeadlineStyle(this);
        this.getCrossFade();
    }

    public void addTitle(Title title) {
        this.addComponent(title);
        title.setPreferredSize(new Dimension(234, 26));
        title.setX(this.attributes.getDividerX());
    }

    public void addListItem(CountryDataItem listItem) {
        if (this.getComponentIndex(listItem) == -1) {
            this.addComponent(listItem);
        } else {
            listItem.revalidate();
        }
        this.countryData = listItem;
    }

    public void removeCountryData() {
        if (this.getComponentIndex(this.countryData) != -1) {
            this.removeComponent(this.countryData);
        }
    }

    private Crossfade getCrossFade() {
        if (this.crossFade == null) {
            this.crossFade = new Crossfade(this.attributes.getCrossfadeImageBoderWidth(), this.attributes.getCrossfadeImageBoderHeight());
            this.crossFade.setY(6);
        }
        return this.crossFade;
    }

    public void setImagesBackground(String[] imagesPath) {
        if (this.getComponentIndex(this.crossFade) == -1) {
            this.addComponent(this.crossFade);
        }
        this.crossFade.setImages(imagesPath);
    }

    public void setImagesBackground(Vector images) {
        if (this.getComponentIndex(this.crossFade) == -1) {
            this.addComponent(this.crossFade);
        }
        this.crossFade.setImages(images);
    }

    public void setCrossfadePosition(int x, int y) {
        if (x >= 0 && x != this.crossFade.getAbsoluteX()) {
            this.crossFade.setX(x);
        }
        if (y >= 0 && y != this.crossFade.getAbsoluteY()) {
            this.crossFade.setY(y);
        }
    }

    public void pauseCrossFade(Form componentForm) {
        if (componentForm != null && this.crossFade != null) {
            this.crossFade.pauseTransition(componentForm);
        }
    }

    public void startCrossFade(Form componentForm) {
        if (componentForm != null && this.crossFade != null) {
            this.crossFade.startTransition(componentForm);
        }
    }

    public void drawWhiteBorder() {
        this.crossFade.getStyle().setBorder(Border.createLineBorder(3, 0xFFFFFF));
        this.crossFade.setPreferredSize(new Dimension(this.attributes.getHeadlineBorderWidth(), this.attributes.getHeadlineBorderHeight()));
        this.setPreferredSize(new Dimension(this.attributes.getHeadlineWidth(), this.attributes.getHeadlineCrossfadeHeight() - 13));
    }

    public void withoutBorder() {
        this.crossFade.setPreferredSize(new Dimension(this.attributes.getHeadlineWidth(), this.attributes.getCrossfadeHeight()));
        this.setPreferredSize(new Dimension(this.attributes.getHeadlineWidth(), this.attributes.getHeadlineCrossfadeHeight()));
    }

    public void drawImageBorder() {
        try {
            this.crossFade.getStyle().setBgImage(Image.createImage(IOUtility.getImageFromRES(ICON_FRAME)));
            this.crossFade.setPadding(13, 10);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void repaint() {
        super.repaint();
        this.crossFade.repaint();
    }
}

