/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.data.OnlineContent;
import com.sonyericsson.fifa.exceptions.NoDiskSpaceException;
import com.sonyericsson.fifa.utils.Configuration;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.components.list.ListItem;
import com.sun.lwuit.Image;
import java.io.IOException;

public class ExtraVideosItem
extends ListItem {
    private OnlineContent content;

    public ExtraVideosItem(OnlineContent content) {
        super(content.getTitle(), content.getArtist(), content.getPreviewPath());
        try {
            if (IOUtility.isFileAvailable(Configuration.getInstance().getFilePathForDownloadableVideo(content.getFormat(), content.getTitle(), content.getFileSize()))) {
                content.setContentStatus((byte)2);
                content.setPath(Configuration.getInstance().getFilePathForDownloadableVideo(content.getFormat(), content.getTitle(), content.getFileSize()));
            }
        }
        catch (NoDiskSpaceException e) {
            e.printStackTrace();
        }
        this.content = content;
        this.refreshIcon();
    }

    public OnlineContent getContent() {
        return this.content;
    }

    public void refreshIcon() {
        if (this.content != null) {
            switch (this.content.getContentStatus()) {
                case 1: {
                    this.setDownloadingIcon();
                    break;
                }
                case 0: {
                    this.setDownloadingIcon();
                    break;
                }
                case 2: {
                    this.setPreviewImage();
                }
            }
        }
    }

    private void setPreviewImage() {
        if (this.content.getPreviewStatus() == 2) {
            this.setPicture(this.content.getPreviewPath());
        } else {
            this.setPicture(Images.getVideoIconDefault());
        }
    }

    private void setDownloadingIcon() {
        String downloadIcon = Images.getDownloadIconName(this.content.getDownloadProgress());
        try {
            this.setPicture(Image.createImage(IOUtility.getImageFromRES(downloadIcon)));
        }
        catch (IOException e) {
            Logger.logInfo(this.getClass(), "IOException to access download icon" + e.getMessage());
            this.setPicture(Images.getVideoIconDefault());
        }
    }
}

