/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.action.UpdateMyTeamAction;
import com.sonyericsson.fifa.view.components.list.CountryDataItem;
import com.sonyericsson.fifa.view.components.list.ListItemFeedTicker;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;

public class FlagHeadline
extends Container {
    private ListItemFeedTicker ticker;
    private Attributes attributes = VerifyScreenDimension.getAttributesInstance();

    public FlagHeadline() {
        this.setFocus(false);
        this.setFocusable(false);
        this.setPreferredSize(new Dimension(this.attributes.getHeadlineWidth(), this.attributes.getHeadlineFlagHeight()));
        this.setLayout(new CoordinateLayout(this.getPreferredSize()));
    }

    public void setCountryFlag(Image flag) {
        if (flag != null) {
            this.getStyle().setBgImage(flag);
        }
    }

    public void setCountryData(CountryDataItem listItem) {
        if (this.getComponentIndex(listItem) == -1) {
            this.addComponent(listItem);
        } else {
            listItem.revalidate();
        }
    }

    private ListItemFeedTicker getFeedTicker() {
        if (this.ticker == null) {
            this.ticker = new ListItemFeedTicker();
            this.ticker.setX(0);
            this.ticker.setY(this.getPreferredH() - this.ticker.getPreferredH());
            this.ticker.setAction(new UpdateMyTeamAction());
        }
        return this.ticker;
    }

    public void addFeedTicker(boolean finished) {
        this.getFeedTicker().setStatus(finished);
        if (!this.contains(this.getFeedTicker())) {
            this.addComponent(this.getFeedTicker());
        }
    }

    public void removeFeedTicker() {
        this.getFeedTicker().removeTicker();
        if (this.contains(this.getFeedTicker())) {
            this.removeComponent(this.getFeedTicker());
        }
    }

    public boolean isTickerFinished() {
        return this.getFeedTicker().isFinished();
    }

    public Component getFocusedItem() {
        if (this.getFeedTicker().hasFocus()) {
            return this.getFeedTicker();
        }
        return null;
    }
}

