/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.action.FifaWebSiteAction;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sonyericsson.fifa.view.components.WaitIndicator;
import com.sonyericsson.fifa.view.components.list.ListItem;
import com.sonyericsson.fifa.view.components.list.ListItemFeedTicker;
import com.sonyericsson.fifa.view.components.list.ListItemFifaButton;
import com.sonyericsson.fifa.view.components.list.Title;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.layouts.BoxLayout;
import java.io.IOException;

class GroupContainer
extends Container {
    private Attributes attributes = VerifyScreenDimension.getAttributesInstance();
    private Title title = null;
    private int countComponent;
    private Container topContainer = null;
    private Container bottomContainer = null;
    private boolean hideTitle = false;
    private ListItemFifaButton fifaButton = null;

    public GroupContainer() {
        FifaLookAndFeelManager.changeContainerBehaviour(this);
        this.setScrollable(false);
        FifaLookAndFeelManager.configToTransparencyStyle(this);
        this.countComponent = 0;
        super.addComponent(this.getTopContainer());
        super.addComponent(this.getBottomContainer());
    }

    private Container getTopContainer() {
        if (this.topContainer == null) {
            this.topContainer = new Container();
            this.topContainer.setLayout(new BoxLayout(2));
        }
        return this.topContainer;
    }

    private Container getBottomContainer() {
        if (this.bottomContainer == null) {
            this.bottomContainer = new Container();
            this.bottomContainer.setLayout(new BoxLayout(2));
        }
        return this.bottomContainer;
    }

    private Title getSubgroupTitle() {
        if (this.title == null) {
            this.title = new Title();
            this.title.setDimension(this.attributes.getWidth(), this.attributes.getSmallDividerTitleHeight());
            this.title.setTitleFont(FifaResources.getFont("Font_SansSerif_Medium_Bold"));
            this.title.setFocusable(false);
            this.title.alignTitleToCenter();
        }
        return this.title;
    }

    public void setBackground(String backgroundImagePath) {
        try {
            this.getSubgroupTitle().setBackground(Image.createImage(IOUtility.getImageFromRES(backgroundImagePath)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setTitle(String titleText) {
        this.getSubgroupTitle().setTitleText(titleText);
    }

    public void showTitle() {
        if (this.topContainer.getComponentCount() <= 0 && !this.hideTitle) {
            this.topContainer.addComponent(this.getSubgroupTitle());
        }
    }

    public void showFifaButton() {
        if (this.topContainer.getComponentIndex(this.getFifaButton()) == -1 && !this.hideTitle) {
            this.topContainer.addComponent(this.getFifaButton());
        }
    }

    private ListItemFifaButton getFifaButton() {
        if (this.fifaButton == null) {
            this.fifaButton = new ListItemFifaButton();
            this.fifaButton.setAction(new FifaWebSiteAction());
        }
        return this.fifaButton;
    }

    public void hideTitle() {
        this.hideTitle = true;
        if (this.topContainer.getComponentIndex(this.getSubgroupTitle()) != -1) {
            this.topContainer.removeComponent(this.getSubgroupTitle());
        }
    }

    public void addComponent(Component component) {
        if (!(component instanceof WaitIndicator)) {
            if (this.countComponent == 0) {
                component.getStyle().setBgImage(Images.getFirstItemBackground());
            } else {
                component.getStyle().setBgImage(Images.getItemBackground());
            }
            ++this.countComponent;
        }
        this.bottomContainer.addComponent(component);
    }

    public void addComponent(int index, Component cmp) {
        if (index > -1) {
            this.bottomContainer.addComponent(index, cmp);
        } else {
            this.bottomContainer.addComponent(cmp);
        }
    }

    public void removeComponent(Component component) {
        this.bottomContainer.removeComponent(component);
    }

    public void setItemPicture(int itemIndex, String picturePath) {
        if (this.bottomContainer != null && this.bottomContainer.getComponentCount() > itemIndex && this.bottomContainer.getComponentAt(itemIndex) instanceof ListItem) {
            ((ListItem)this.bottomContainer.getComponentAt(itemIndex)).setPicture(picturePath);
        }
    }

    public void removeAll() {
        this.getBottomContainer().removeAll();
        this.countComponent = 0;
    }

    public int getComponentAt(Component component) {
        return this.getBottomContainer().getComponentIndex(component);
    }

    public String getGroupName() {
        return this.title.getTitle().getText();
    }

    public void focusFirstItem() {
        if (this.getTopContainer().getComponentIndex(this.getFifaButton()) != -1) {
            this.getFifaButton().requestFocus();
        } else if (this.getBottomContainer().getComponentCount() > 0) {
            Component component = this.getBottomContainer().getComponentAt(0);
            if (component instanceof ListItem && component.hasFocus()) {
                ((ListItem)component).setBackgroundHighlightImg();
            } else {
                component.requestFocus();
                component.repaint();
            }
        }
    }

    public boolean isFirstItemFocused() {
        if (this.getBottomContainer().getComponentCount() > 0) {
            Component component = this.getBottomContainer().getComponentAt(0);
            if (component instanceof ListItemFeedTicker && this.getBottomContainer().getComponentCount() > 1) {
                component = this.getBottomContainer().getComponentAt(1);
            }
            if (component instanceof ListItem) {
                return component.hasFocus();
            }
        }
        return false;
    }

    public Component getFirstComponent() {
        if (this.getTopContainer().getComponentCount() > 0) {
            return this.getTopContainer().getComponentAt(0);
        }
        return null;
    }

    public void setFirstItemBackground(int cmpIndex, boolean isFirstBack) {
        Component component;
        if (this.getBottomContainer().getComponentCount() >= cmpIndex && (component = this.getBottomContainer().getComponentAt(cmpIndex)) != null) {
            if (isFirstBack) {
                component.getStyle().setBgImage(Images.getFirstItemBackground());
            } else {
                component.getStyle().setBgImage(Images.getItemBackground());
            }
        }
    }

    public int getItemsCount() {
        return this.getBottomContainer().getComponentCount();
    }
}

