/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sonyericsson.fifa.view.components.WaitIndicator;
import com.sonyericsson.fifa.view.components.list.CountryDataItem;
import com.sonyericsson.fifa.view.components.list.CrossfadeHeadline;
import com.sonyericsson.fifa.view.components.list.FlagHeadline;
import com.sonyericsson.fifa.view.components.list.GroupContainer;
import com.sonyericsson.fifa.view.components.list.Item;
import com.sonyericsson.fifa.view.components.list.ListItem;
import com.sonyericsson.fifa.view.components.list.ListItemButton;
import com.sonyericsson.fifa.view.components.list.ListItemFeedTicker;
import com.sonyericsson.fifa.view.components.list.ListItemFifaButton;
import com.sonyericsson.fifa.view.components.list.ListItemMore;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ListComponentsContainer
extends Container {
    private static final String FIRST_TITLE_LIST = "first_title_list.png";
    private static final String OTHER_TITLE_LIST = "other_title_list.png";
    public static final int SELECTED_ITEM_ACTION = 2;
    private Container headlineContainer;
    private Hashtable subgroups = null;
    private CrossfadeHeadline crossfadeHeadline = null;
    private FlagHeadline flagHeadline = null;
    private WaitIndicator waitIndicator = null;
    private String lastGroup = null;
    private Label HeadlineLabel = null;

    public ListComponentsContainer() {
        FifaLookAndFeelManager.changeContainerBehaviour(this);
        this.setScrollable(true);
        FifaLookAndFeelManager.configToTransparencyStyle(this);
        this.requestFocus();
    }

    public boolean containsItem(String subGroupName, Component component) {
        return ((GroupContainer)this.getSubgroupTable().get(subGroupName)).contains(component);
    }

    private Hashtable getSubgroupTable() {
        if (this.subgroups == null) {
            this.subgroups = new Hashtable();
        }
        return this.subgroups;
    }

    private GroupContainer newGroupContainer(String groupName) {
        GroupContainer subgroup = new GroupContainer();
        subgroup.setTitle(groupName);
        this.getSubgroupTable().put(groupName, subgroup);
        if (this.getSubgroupTable().size() == 1) {
            subgroup.setBackground(FIRST_TITLE_LIST);
        } else if (this.getSubgroupTable().size() > 1) {
            subgroup.setBackground(OTHER_TITLE_LIST);
        }
        return subgroup;
    }

    private GroupContainer newGroupContainer(boolean anotherBg, String groupName) {
        GroupContainer subgroup = new GroupContainer();
        subgroup.setTitle(groupName);
        this.getSubgroupTable().put(groupName, subgroup);
        if (anotherBg) {
            subgroup.setBackground(FIRST_TITLE_LIST);
        } else {
            subgroup.setBackground(OTHER_TITLE_LIST);
        }
        return subgroup;
    }

    public void fillEmptySpaceWithCrossfade() {
        this.addFakeItem(this.lastGroup, this.newFakeListItemWithCrossfade());
    }

    public void fillEmptySpaceWithoutCrossfade(String groupName) {
        this.addFakeItem(groupName, this.newFakeListItemWithoutCrossfade());
    }

    public void fillEmptySpaceWithTeamFlag(String groupName) {
        this.addFakeItem(groupName, this.newFakeListItemWithTeamFlag());
    }

    private ListItem newFakeListItemWithTeamFlag() {
        ListItem item = new ListItem();
        Attributes attributes = VerifyScreenDimension.getAttributesInstance();
        int height = attributes.getHeight() - attributes.getHeadlineFlagHeight() - attributes.getSoftkeyHeight() - this.getSubGroupsHeight();
        item.setListItemDimension(attributes.getWidth(), height);
        item.setTitleText(null);
        item.setSubtitleText(null);
        item.removePicture();
        item.getStyle().setBgImage(Images.getFakeItemBackground());
        item.setFocusable(false);
        return item;
    }

    private ListItem newFakeListItemWithoutCrossfade() {
        ListItem item = new ListItem();
        Attributes attributes = VerifyScreenDimension.getAttributesInstance();
        int height = attributes.getHeight() - attributes.getSoftkeyHeight() - this.getSubGroupsHeight();
        if (SystemProperties.getPhonePlatform() != 2) {
            height += attributes.getMyTeamFakeItemBottomGap();
        }
        item.setListItemDimension(attributes.getWidth(), height);
        item.setTitleText(null);
        item.setSubtitleText(null);
        item.removePicture();
        item.getStyle().setBgImage(Images.getFakeItemBackground());
        item.setFocusable(false);
        return item;
    }

    private ListItem newFakeListItemWithCrossfade() {
        ListItem item = new ListItem();
        Attributes attributes = VerifyScreenDimension.getAttributesInstance();
        int height = attributes.getHeight() - attributes.getHeadlineCrossfadeHeight() - attributes.getSoftkeyHeight() - attributes.getTabsMenuHeight() - this.getSubGroupsHeight();
        if (SystemProperties.getPhonePlatform() == 2) {
            height += attributes.getMyTeamFakeItemBottomGap();
        }
        item.setListItemDimension(attributes.getWidth(), height);
        item.setTitleText(null);
        item.setSubtitleText(null);
        item.removePicture();
        item.getStyle().setBgImage(Images.getFakeItemBackground());
        item.setFocusable(false);
        return item;
    }

    private int getSubGroupsHeight() {
        int sum = 0;
        Enumeration e = this.getSubgroupTable().elements();
        while (e.hasMoreElements()) {
            GroupContainer groupContainer = (GroupContainer)e.nextElement();
            int i = 0;
            while (i < groupContainer.getComponentCount()) {
                Container container = (Container)groupContainer.getComponentAt(i);
                int k = 0;
                while (k < container.getComponentCount()) {
                    sum += container.getComponentAt(k).getHeight();
                    ++k;
                }
                ++i;
            }
        }
        return sum;
    }

    public Label getTeamFlagLabel(Image image) {
        if (this.HeadlineLabel == null) {
            this.HeadlineLabel = new Label();
            this.HeadlineLabel.getStyle().setBgTransparency(0);
            this.HeadlineLabel.setX(0);
            this.HeadlineLabel.setY(0);
            this.HeadlineLabel.getStyle().setMargin(0, 0, 0, 0);
            this.HeadlineLabel.setIcon(image);
            this.HeadlineLabel.setAlignment(4);
        }
        return this.HeadlineLabel;
    }

    public void addHeadline(Image image) {
        if (this.headlineContainer == null) {
            this.headlineContainer = new Container();
            this.setFocus(false);
            this.setFocusable(false);
            this.headlineContainer.setLayout(new CoordinateLayout(VerifyScreenDimension.getAttributesInstance().getWidth(), 103));
            this.headlineContainer.setPreferredSize(new Dimension(VerifyScreenDimension.getAttributesInstance().getWidth(), 103));
            this.headlineContainer.addComponent(this.getTeamFlagLabel(image));
            this.addComponent(this.headlineContainer);
        }
    }

    public void addGroup(String subgroupName) {
        if (!this.containsGroup(subgroupName)) {
            this.lastGroup = subgroupName;
            this.addComponent(this.newGroupContainer(subgroupName));
        }
    }

    public void addGroup(boolean anotherBg, String subgroupName) {
        if (!this.containsGroup(subgroupName)) {
            this.addComponent(this.newGroupContainer(anotherBg, subgroupName));
        }
    }

    public void addItem(String subgroupName, Component component) {
        this.showTitle(subgroupName);
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).addComponent(component);
    }

    public void addFakeItem(String subgroupName, Component component) {
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).addComponent(-1, component);
    }

    public void addItem(int cmpIndex, String subgroupName, Component component) {
        this.showTitle(subgroupName);
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).addComponent(cmpIndex, component);
    }

    public void removeItem(String subgroupName, Component component) {
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).removeComponent(component);
    }

    public void addFeedTicker(boolean finished) {
        this.getFlagHeadlineCmp().addFeedTicker(finished);
    }

    public void removeFeedTicker() {
        this.getFlagHeadlineCmp().removeFeedTicker();
    }

    public boolean isFeedTickerFinished() {
        return this.getFlagHeadlineCmp().isTickerFinished();
    }

    public void removeAll(String subgroupName) {
        if (this.getSubgroupTable() != null) {
            GroupContainer groupContainer = (GroupContainer)this.getSubgroupTable().get(subgroupName);
            if (groupContainer != null) {
                groupContainer.removeAll();
            }
            this.getCrossfadeHeadlineCmp().removeAll();
        }
    }

    public void removeWaitIndicator(String subgroupName) {
        GroupContainer groupContainer;
        if (this.getSubgroupTable() != null && (groupContainer = (GroupContainer)this.getSubgroupTable().get(subgroupName)) != null) {
            groupContainer.removeComponent(this.getWaitIndicator(0));
            this.waitIndicator = null;
        }
    }

    public void removeWaitIndicator() {
        if (this.getComponentIndex(this.getWaitIndicator()) != -1) {
            this.removeComponent(this.getWaitIndicator());
            this.waitIndicator = null;
        }
    }

    public void showTitle(String subgroupName) {
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).showTitle();
    }

    public void hideTitle(String subgroupName) {
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).hideTitle();
    }

    public void addFifaButton(String subgroupName) {
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).showFifaButton();
        this.hideTitle(subgroupName);
    }

    public void setFlagHeadline(String teamCode) {
        if (this.getComponentIndex(this.getFlagHeadlineCmp()) == -1) {
            this.getFlagHeadlineCmp().setCountryFlag(IOUtility.getFlagImageFromRES(teamCode));
            this.addComponent(0, (Component)this.getFlagHeadlineCmp());
        }
    }

    public void removeFlagHeadline() {
        if (this.getComponentIndex(this.getFlagHeadlineCmp()) != -1) {
            this.removeComponent(this.getFlagHeadlineCmp());
        }
    }

    public void setCrossfadeHeadline(String[] imagesPath, int borderType) {
        this.getCrossfadeHeadlineCmp().setImagesBackground(imagesPath);
        this.setCrossfadeHeadlineBorder(borderType);
    }

    public void setCrossfadeHeadline(Vector images, int borderType) {
        this.getCrossfadeHeadlineCmp().setImagesBackground(images);
        this.setCrossfadeHeadlineBorder(borderType);
        this.getCrossfadeHeadlineCmp().repaint();
    }

    public void addCountryDataItemToFlag(CountryDataItem countryData) {
        this.getFlagHeadlineCmp().setCountryData(countryData);
    }

    public void showWaitIndicator(String subGroup, int height) {
        ((GroupContainer)this.getSubgroupTable().get(subGroup)).addComponent(this.getWaitIndicator(height));
    }

    public void showWaitIndicator(int height) {
        this.addComponent(this.getWaitIndicator(height));
    }

    public void removeCountryDataItem() {
        this.getCrossfadeHeadlineCmp().removeCountryData();
    }

    private WaitIndicator getWaitIndicator(int height) {
        if (this.waitIndicator == null) {
            this.waitIndicator = new WaitIndicator();
        }
        if (height > 0) {
            this.waitIndicator.setPreferredH(height);
        }
        return this.waitIndicator;
    }

    private void setCrossfadeHeadlineBorder(int borderType) {
        switch (borderType) {
            case 0: {
                this.getCrossfadeHeadlineCmp().drawImageBorder();
                break;
            }
            case 1: {
                this.getCrossfadeHeadlineCmp().drawWhiteBorder();
                break;
            }
            case 2: {
                this.getCrossfadeHeadlineCmp().withoutBorder();
            }
        }
        if (this.getComponentIndex(this.getCrossfadeHeadlineCmp()) == -1) {
            this.addComponent(0, (Component)this.getCrossfadeHeadlineCmp());
        }
    }

    public void setCrossfadePosition(int posX, int posY) {
        this.getCrossfadeHeadlineCmp().setCrossfadePosition(posX, posY);
    }

    public void startHeadlineCrossfade(Form componentForm) {
        this.getCrossfadeHeadlineCmp().startCrossFade(componentForm);
    }

    public void pauseHeadlineCrossfase(Form componentForm) {
        this.getCrossfadeHeadlineCmp().pauseCrossFade(componentForm);
    }

    private CrossfadeHeadline getCrossfadeHeadlineCmp() {
        if (this.crossfadeHeadline == null) {
            this.crossfadeHeadline = new CrossfadeHeadline();
        }
        return this.crossfadeHeadline;
    }

    private FlagHeadline getFlagHeadlineCmp() {
        if (this.flagHeadline == null) {
            this.flagHeadline = new FlagHeadline();
        }
        return this.flagHeadline;
    }

    public Item getSelectedItem() {
        int countSubgroupItem = 0;
        int i = 0;
        while (i < this.getComponentCount()) {
            int j;
            Component groupContainer = this.getComponentAt(i);
            if (groupContainer instanceof FlagHeadline) {
                FlagHeadline flagHeadline = (FlagHeadline)groupContainer;
                j = 0;
                while (j < flagHeadline.getComponentCount()) {
                    Component cmp = flagHeadline.getComponentAt(j);
                    if (cmp instanceof Item && cmp.hasFocus()) {
                        return (Item)cmp;
                    }
                    ++j;
                }
            } else if (groupContainer instanceof GroupContainer) {
                GroupContainer itemGroup = (GroupContainer)groupContainer;
                j = 0;
                while (j < itemGroup.getComponentCount()) {
                    Component itemSubGroup = itemGroup.getComponentAt(j);
                    if (itemSubGroup instanceof Container) {
                        Container c = (Container)itemSubGroup;
                        int selectable = 0;
                        while (selectable < c.getComponentCount()) {
                            Container item = (Container)c.getComponentAt(selectable);
                            if (item.hasFocus()) {
                                return (Item)item;
                            }
                            ++selectable;
                        }
                    }
                    ++j;
                }
                ++countSubgroupItem;
            }
            ++i;
        }
        return null;
    }

    public void setItemPicture(String subGroup, int itemIndex, String picturePath) {
        if (subGroup != null) {
            ((GroupContainer)this.getSubgroupTable().get(subGroup)).setItemPicture(itemIndex, picturePath);
        }
    }

    Component searchInstance(Component cmp) {
        while (!(cmp instanceof ListItem || cmp instanceof ListItemButton || cmp instanceof ListItemMore || cmp instanceof ListItemFeedTicker || cmp instanceof ListItemFifaButton)) {
            if (cmp != null) {
                cmp = cmp.getParent();
            }
            if (cmp != null) continue;
            return null;
        }
        return cmp;
    }

    public int verifyPointerPressed(int x, int y) {
        Attributes attributes;
        if (Display.getInstance().isTouchScreenDevice() && (y += (attributes = VerifyScreenDimension.getAttributesInstance()).getPointerPressedY()) > attributes.getTabsMenuHeight() && y < attributes.getHeight() - attributes.getSoftkeyHeight()) {
            Component c = this.searchInstance(this.getComponentAt(x, y));
            if (c != null) {
                if (c.hasFocus()) {
                    return 2;
                }
                c.requestFocus();
            }
            super.pointerPressed(x, y);
        }
        return -1;
    }

    public void pointerReleased(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            Component c = this.searchInstance(this.getComponentAt(x, y += VerifyScreenDimension.getAttributesInstance().getHeightConstant()));
            if (c != null) {
                c.requestFocus();
            }
            super.pointerReleased(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    public void removeAllComponents(boolean removeHeadline) {
        Enumeration e = this.subgroups.elements();
        e = this.subgroups.elements();
        while (e.hasMoreElements()) {
            GroupContainer groupContainer = (GroupContainer)e.nextElement();
            groupContainer.hideTitle();
            groupContainer.removeAll();
            this.removeComponent(groupContainer);
        }
        if (removeHeadline && this.getComponentIndex(this.getCrossfadeHeadlineCmp()) != -1) {
            this.removeComponent(this.getCrossfadeHeadlineCmp());
        }
        this.getSubgroupTable().clear();
    }

    private boolean containsGroup(String groupName) {
        if (this.subgroups != null) {
            Enumeration e = this.subgroups.elements();
            e = this.subgroups.elements();
            while (e.hasMoreElements()) {
                GroupContainer groupContainer = (GroupContainer)e.nextElement();
                if (!groupName.equals(groupContainer.getGroupName())) continue;
                return true;
            }
        }
        return false;
    }

    public void focusFirstItem(String subgroupName) {
        GroupContainer groupContainer;
        if (this.getSubgroupTable() != null && (groupContainer = (GroupContainer)this.getSubgroupTable().get(subgroupName)) != null) {
            groupContainer.focusFirstItem();
        }
    }

    public boolean isFirstItemFocused(String subgroupName) {
        GroupContainer groupContainer;
        if (this.getSubgroupTable() != null && (groupContainer = (GroupContainer)this.getSubgroupTable().get(subgroupName)) != null) {
            return groupContainer.isFirstItemFocused();
        }
        return false;
    }

    public Component getFirstComponent(String subgroupName, boolean scrollToHeadline) {
        GroupContainer groupContainer;
        if (scrollToHeadline) {
            return this.getCrossfadeHeadlineCmp();
        }
        if (this.getSubgroupTable() != null && (groupContainer = (GroupContainer)this.getSubgroupTable().get(subgroupName)) != null) {
            return groupContainer.getFirstComponent();
        }
        return null;
    }

    public void changeFirstItemToSecondItemBack(int cmpIndex, String subgroupName, boolean isFirstBack) {
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).setFirstItemBackground(cmpIndex, isFirstBack);
    }

    public WaitIndicator getWaitIndicator() {
        return this.waitIndicator;
    }

    public boolean isGroupEmpty() {
        Enumeration e = this.subgroups.elements();
        e = this.subgroups.elements();
        while (e.hasMoreElements()) {
            GroupContainer groupContainer = (GroupContainer)e.nextElement();
            if (groupContainer.getItemsCount() <= 0) continue;
            return false;
        }
        return true;
    }
}

