/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sonyericsson.fifa.view.components.WaitIndicator;
import com.sonyericsson.fifa.view.components.list.Item;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;

public class ListItemFeedTicker
extends Item {
    private Label labelText;
    private WaitIndicator indicator;
    private static final int TEXT_SHOWFEEDS_X_POSITION = 0;
    private static final int INDICATOR_X_POSITION = 1;
    private static final int INDICATOR_Y_POSITION = 1;
    private static final int INDICATOR_HEIGHT_GAP = 3;
    private boolean isFinished = false;

    public ListItemFeedTicker() {
        this.setFocus(false);
        this.setFocusable(false);
        this.setPreferredSize(new Dimension(VerifyScreenDimension.getAttributesInstance().getListItemWidth(), VerifyScreenDimension.getAttributesInstance().getFeedTickerHeight()));
        this.setLayout(new CoordinateLayout(this.getPreferredSize()));
        this.addComponent(this.getIndicator());
        this.addComponent(this.getLabelText());
        this.getStyle().setBgImage(Images.getFeedItemBackground());
    }

    private Label getLabelText() {
        if (this.labelText == null) {
            this.labelText = new Label();
            FifaLookAndFeelManager.configToFirstLineStyle(this.labelText);
            FifaLookAndFeelManager.configToTransparencyStyle(this.labelText);
            this.labelText.setY(VerifyScreenDimension.getAttributesInstance().getFeedTickerTextPosY());
            this.labelText.setX(VerifyScreenDimension.getAttributesInstance().getFeedTickerTextPosX());
            this.labelText.getStyle().setFont(FifaResources.getFont("Font_SansSerif_Medium_Regular"));
            this.labelText.setAlignment(1);
        }
        return this.labelText;
    }

    private WaitIndicator getIndicator() {
        if (this.indicator == null) {
            this.indicator = new WaitIndicator();
            this.indicator.setPreferredSize(new Dimension(VerifyScreenDimension.getAttributesInstance().getWaitIndicatorFeedTickerWidth(), this.getPreferredH() - 3));
            this.indicator.setX(1);
            this.indicator.setY(1);
            FifaLookAndFeelManager.configToTransparencyStyle(this.indicator);
        }
        return this.indicator;
    }

    private void removeIndicator() {
        if (this.contains(this.getIndicator())) {
            this.removeComponent(this.getIndicator());
            this.getLabelText().setX(0);
            this.indicator = null;
        }
    }

    private void addIndicator() {
        if (!this.contains(this.getIndicator())) {
            this.addComponent(this.getIndicator());
            this.getLabelText().setX(VerifyScreenDimension.getAttributesInstance().getFeedTickerTextPosX());
        }
    }

    private void setText(String text) {
        if (this.getLabelText() != null) {
            this.getLabelText().setText(text);
        }
    }

    public void setStatus(boolean finished) {
        this.isFinished = finished;
        if (finished) {
            this.setText(FifaResources.getMessage("FANAPP_TICKER_SHOW_FEEDS_TXT"));
            this.removeIndicator();
            this.setFocusable(true);
        } else {
            this.setFocusable(false);
            this.setText(FifaResources.getMessage("FANAPP_UPDATING_TXT"));
            this.addIndicator();
        }
        this.repaint();
    }

    protected void focusGained() {
        super.focusGained();
        this.getStyle().setBgImage(Images.getHighlightImg());
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void removeTicker() {
        if (this.contains(this.getIndicator())) {
            this.removeComponent(this.getIndicator());
            this.indicator = null;
        }
    }
}

