/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.components.list.Item;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.io.IOException;

public class ListItemFifaButton
extends Item {
    private Label fifaLabel = null;
    private static final byte ALIGMENT_NORTH = 0;
    private static final byte ALIGMENT_SOUTH = 1;

    public ListItemFifaButton() {
        this.setFocus(false);
        this.setFocusable(true);
        this.setPreferredSize(new Dimension(VerifyScreenDimension.getAttributesInstance().getListItemWidth(), VerifyScreenDimension.getAttributesInstance().getFifaButtonHeight()));
        this.setLayout(new CoordinateLayout(this.getPreferredSize()));
        try {
            Image imgFifaButtonBackground = Image.createImage(IOUtility.getImageFromRES("other_title_list.png"));
            this.getStyle().setBgImage(imgFifaButtonBackground);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initFifaImage();
        this.addComponent(this.getLineDivider((byte)0));
        this.addComponent(this.fifaLabel);
        this.addComponent(this.getLineDivider((byte)1));
    }

    private void initFifaImage() {
        if (this.fifaLabel == null) {
            this.fifaLabel = new Label();
            this.fifaLabel.getStyle().setBgTransparency(0);
            try {
                Image imgFifaLogo = Image.createImage(IOUtility.getImageFromRES("powered-by-FIFA.png"));
                this.fifaLabel.setIcon(imgFifaLogo);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.fifaLabel.setX(this.getPreferredW() / 2 - this.fifaLabel.getPreferredW() / 2);
            this.fifaLabel.setY(this.getPreferredH() / 2 - this.fifaLabel.getPreferredH() / 2);
        }
    }

    private Label getLineDivider(byte aligment) {
        Label lineDivider = new Label();
        lineDivider.getStyle().setBgTransparency(0);
        lineDivider.setIcon(Images.getLitsDividerImg());
        lineDivider.getStyle().setMargin(0, 0, 0, 0);
        lineDivider.getStyle().setPadding(0, 0, 0, 0);
        lineDivider.setFocusable(false);
        if (aligment == 1) {
            lineDivider.setY(this.getPreferredH() - lineDivider.getIcon().getHeight());
        }
        return lineDivider;
    }

    protected void focusGained() {
        super.focusGained();
        this.getStyle().setBgImage(Images.getHighlightImg());
    }
}

