/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.dialogs;

import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.view.View;
import com.sonyericsson.fifa.view.ViewActionListener;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.UserAuthAction;
import com.sonyericsson.fifa.view.dialogs.DialogCompleteTask;
import com.sonyericsson.fifa.view.dialogs.DialogOkView;
import com.sonyericsson.fifa.view.dialogs.DialogYesNoView;
import com.sonyericsson.fifa.view.tabs.AuthorizationView;
import com.sun.lwuit.Display;

public class DialogsManager {
    private static Model model = null;
    static /* synthetic */ Class class$0;

    public static void start(Model model) {
        if (model != null) {
            DialogsManager.model = model;
        }
    }

    public static boolean getRoamingAuthorization() {
        return DialogsManager.showYesNoDialog(new DialogYesNoView(model, "FANAPP_WARNING_ROAMING_COSTS_TXT", "FANAPP_OPTIONS_LATER_TXT"));
    }

    public static UserAuthAction getNetworkingAuthorization() {
        return DialogsManager.showAuthorizationDialog(new AuthorizationView(model));
    }

    public static void showComingSoonAlert() {
        DialogsManager.showAlert(new DialogOkView(model, "FANAPP_ENTERTAINMENT_COMINGSOON_TXT"));
    }

    public static void showUnableUpdateAlert() {
        DialogsManager.showAlert(new DialogOkView(model, "FANAPP_UNABLE_UPDATE_TXT"));
    }

    public static void showNoNetworkConnectionAlert() {
        DialogsManager.showAlert(new DialogOkView(model, "FANAPP_ERROR_CONNECTION_FAILED_ONLY_TXT"));
    }

    public static void showNoDiskSpaceAlert() {
        DialogsManager.showAlert(new DialogOkView(model, "FANAPP_ERROR_MEMORY_FULL_TXT"));
    }

    public static void showNoAccessAlert() {
        DialogsManager.showAlert(new DialogOkView(model, "FANAPP_INTERNAL_ERROR_TXT"));
    }

    public static void showFlightModeAlert() {
        DialogsManager.showAlert(new DialogOkView(model, "FANAPP_FLIGHT_MODE_TXT"));
    }

    public static void showLanguageChangedAlert() {
        DialogsManager.showAlert(new DialogOkView(model, "FANAPP_LANGUAGE_SHUTDOWN_APPLICATION_TXT"));
    }

    private static void showAlert(View alert) {
        DialogsManager.showAuthorizationDialog(alert);
    }

    private static boolean showYesNoDialog(View dialog) {
        boolean auth = false;
        UserAuthAction action = DialogsManager.showAuthorizationDialog(dialog);
        if (action.getAuthorization() != 2) {
            auth = true;
        }
        return auth;
    }

    private static UserAuthAction showAuthorizationDialog(final View dialog) {
        final UserAuthAction auth = new UserAuthAction();
        final DialogCompleteTask completeTask = new DialogCompleteTask();
        dialog.addViewActionListener(new ViewActionListener(){

            public void viewActionPerformed(Action action) {
                if (action instanceof UserAuthAction) {
                    UserAuthAction authAction = (UserAuthAction)action;
                    auth.setAuthorization(authAction.getAuthorization());
                }
                dialog.hide();
                completeTask.complete();
            }
        });
        try {
            dialog.show();
        }
        catch (ViewException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.view.dialogs.DialogsManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Logger.logError(clazz, "ViewException: " + e.getMessage());
        }
        Display.getInstance().invokeAndBlock(new Runnable(){

            public void run() {
            }
        });
        Display.getInstance().invokeAndBlock(completeTask);
        return auth;
    }
}

