/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.player;

import com.nokia.mid.ui.DeviceControl;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.AbstractView;
import com.sonyericsson.fifa.view.VideoPlayer;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.exceptions.VideoPlayerException;
import com.sonyericsson.fifa.view.player.VideoPlayerGui;
import java.io.IOException;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;

public class VideoPlayerView
extends AbstractView
implements com.sonyericsson.fifa.view.components.BackAction {
    private VideoPlayerGui gui = null;
    private VideoPlayer videoPlayer = null;
    private LightsOn thread = null;

    public VideoPlayerView(int name, Model model) {
        super(name, model);
        model.setVideoPlayer(this);
    }

    public void startVideo(String videoPath) throws IOException, VideoPlayerException {
        this.gui = new VideoPlayerGui(this);
        this.videoPlayer = new VideoPlayer();
        this.gui.setPlayer(this.videoPlayer, videoPath, SystemProperties.getFilename(videoPath));
        this.gui.playVideo();
    }

    public int getViewId() {
        return 0;
    }

    public void hide() {
        try {
            this.gui.stopVideo();
            this.gui.close();
        }
        catch (VideoPlayerException e) {
            e.printStackTrace();
        }
    }

    public void show() throws ViewException {
        Display lcdui = SystemProperties.getLCDUIDisplay();
        this.keepLightsOn();
        lcdui.setCurrent((Displayable)this.gui);
    }

    public void back() {
        if (this.videoPlayer != null) {
            this.videoPlayer.close();
            this.videoPlayer = null;
        }
        BackAction b = new BackAction();
        this.turnLightsOff();
        this.fireViewActionPerformed(b);
    }

    private void keepLightsOn() {
        this.thread = new LightsOn();
        new Thread(this.thread).start();
    }

    private void turnLightsOff() {
        this.thread.stop();
    }

    public void turnLitghtsOffByHomeScreen() {
        if (this.thread != null) {
            this.thread.stop();
        }
    }

    public void showNotify() {
    }

    public void pausedNotify() {
        try {
            this.gui.stopVideo();
        }
        catch (VideoPlayerException e) {
            e.printStackTrace();
        }
    }

    public void notifyMoveTabLeft() {
    }

    public void notifyMoveTabRigth() {
    }

    public void notifyRigthSoftKeySelected() {
    }

    public void onKeyPressed(int keyCode) {
    }

    public void onKeyReleased(int keyCode) {
    }

    public void onLongKeyPressed(int keyCode) {
    }

    public void onLongTouchPressed(int valX, int ValY) {
    }

    public void onTouchDragged(int valX, int valY) {
    }

    public void onTouchPressed(int valX, int ValY) {
    }

    public void onTouchReleased(int valX, int ValY) {
    }

    public void selectedItem(int item) {
    }

    static class LightsOn
    implements Runnable {
        private boolean running = false;

        LightsOn() {
        }

        public void stop() {
            this.running = false;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                Thread.yield();
                DeviceControl.setLights((int)0, (int)100);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

