/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.FifaWebSiteAction;
import com.sonyericsson.fifa.view.action.ShareAction;
import com.sonyericsson.fifa.view.action.ViewArticleAction;
import com.sonyericsson.fifa.view.components.forms.ArticleForm;
import com.sonyericsson.fifa.view.components.list.ListItemFifaButton;
import com.sonyericsson.fifa.view.components.list.ListItemMore;
import com.sun.lwuit.Component;
import java.io.IOException;
import java.util.Vector;

public class ArticleView
extends FifaAbstractView {
    private ArticleForm articleForm = new ArticleForm();
    private FeedItem item;

    public ArticleView(Model model) {
        super(7, model);
    }

    protected void doHide() {
        super.doHide();
        this.articleForm.setKeyListener(null);
        this.articleForm.setTouchListener(null);
    }

    protected void doShow() throws ViewException {
        this.articleForm.show();
        this.articleForm.setKeyListener(this);
        this.articleForm.setTouchListener(this);
    }

    public void onKeyPressed(int keyCode) {
        this.performSoftkey();
    }

    public void onTouchPressed(int valX, int valY) {
        this.performSoftkey();
        this.articleForm.clearLeftSoftKeyBkGround();
        this.performTouchPressed();
    }

    public void updateData(int index, String teamCode) {
        Vector items = this.model.getTeam(teamCode).getLatestNews().getItems();
        if (items != null) {
            this.item = (FeedItem)items.elementAt(index);
            this.updateView();
        }
    }

    public void updateData(FeedItem feed) {
        if (feed != null) {
            this.item = feed;
            this.updateView();
        }
    }

    public void performSoftkey() {
        int selectedSoftKey = this.articleForm.getSelectedSoftkey();
        if (-7 == selectedSoftKey) {
            BackAction backAction = new BackAction();
            this.fireViewActionPerformed(backAction);
        } else if (SystemProperties.getPhonePlatform() == 2) {
            if (-6 == selectedSoftKey) {
                this.fireViewActionPerformed(new ShareAction(this.item));
            }
        } else if (-6 == selectedSoftKey) {
            this.fireViewActionPerformed(new ShareAction(this.item));
        } else if (-5 == selectedSoftKey) {
            Component selectedItem = this.articleForm.getFocusedComponent();
            if (selectedItem != null && selectedItem instanceof ListItemFifaButton) {
                this.fireViewActionPerformed(new FifaWebSiteAction());
            } else {
                ViewArticleAction viewArticleAction = new ViewArticleAction(this.item.getLink());
                this.fireViewActionPerformed(viewArticleAction);
            }
        }
    }

    public void performTouchPressed() {
        Component c = this.articleForm.getSelectedComponent();
        if (c != null) {
            if (c instanceof ListItemMore) {
                ViewArticleAction viewArticleAction = new ViewArticleAction(this.item.getLink());
                this.fireViewActionPerformed(viewArticleAction);
            } else if (c instanceof ListItemFifaButton) {
                this.fireViewActionPerformed(new FifaWebSiteAction());
            }
        }
    }

    protected void doUpdateView() {
        if (this.item != null) {
            this.articleForm.setTitle(this.item.getTitle());
            this.articleForm.setDescription(this.item.getDescription());
            Enclosure enclosure = this.item.getEnclosure();
            String picturePath = null;
            if (enclosure != null) {
                picturePath = this.item.getEnclosure().getPath();
            }
            try {
                if (picturePath == null) {
                    this.articleForm.setPicture(Images.getArticleIconDefault());
                } else {
                    this.articleForm.setPicture(picturePath);
                }
            }
            catch (IOException e) {
                Logger.logError(this.getClass(), "Error to read image: " + picturePath);
                this.articleForm.setPicture(Images.getArticleIconDefault());
            }
        }
    }

    protected void doClearFormText() {
        this.articleForm.refreshAll();
        this.articleForm.revalidate();
    }
}

