/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.PreloadedContent;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.preloadedContent.PreloadedContentListener;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.OpenGameAction;
import com.sonyericsson.fifa.view.action.OpenLinkAction;
import com.sonyericsson.fifa.view.action.OpenVideoAction;
import com.sonyericsson.fifa.view.action.SelectedAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.tabs.TabView;
import java.util.Enumeration;

public class EntertaimentView
extends TabView
implements PreloadedContentListener {
    private String firstGroup = null;
    private int sizeMoreExtras = 0;
    private int sizeExtraVideos = 0;

    public EntertaimentView(Model model) {
        super(3, model);
        TabView.mainForm.entertainmentAddGroups();
        if (model.isPreloadedContentUpdated()) {
            this.updateView();
        }
        model.addPreloadedContentListener(this);
    }

    protected int getNextTab() {
        return 1;
    }

    protected int getPreviousTab() {
        return 2;
    }

    protected void doHide() {
        super.doHide();
        TabView.mainForm.pauseCrossfade(2);
    }

    protected void doShow() throws ViewException {
        TabView.mainForm.setTab(2);
        this.viewId = 3;
        if (!this.selectedItem && this.firstGroup != null || this.firstGroup != null && this.model.getCallByHomeScreen()) {
            TabView.mainForm.focusFirstItem(2, this.firstGroup, true);
            TabView.mainForm.revalidate();
        }
        this.selectedItem = false;
        this.model.setCallByHomeScreen(false);
        TabView.mainForm.startCrossfade(2);
        TabView.mainForm.setKeyListener(this);
        TabView.mainForm.setTouchListener(this);
        TabView.mainForm.addSelectedItemListener(this);
        TabView.mainForm.show();
    }

    public void preloadedContentReady() {
        this.updateView();
    }

    public void selectedItem(Action action) {
        this.selectedItem = true;
        this.fireViewActionPerformed(action);
    }

    public void performSoftkey() {
    }

    protected void doClearFormText() {
        if (!TabView.mainForm.isGroupEmpty(2)) {
            TabView.mainForm.refreshAll(2, true);
            this.updateView();
        } else {
            TabView.mainForm.refreshAll(2, true);
        }
    }

    protected void doUpdateView() {
        PreloadedContent content;
        SelectedAction action;
        TabView.mainForm.removeWaitIndicator(2);
        this.sizeMoreExtras = 0;
        String[] imagesPath = null;
        int index = 0;
        Enumeration en = this.model.getPreloadedExtras().elements();
        while (en.hasMoreElements()) {
            PreloadedContent content2 = (PreloadedContent)en.nextElement();
            String subTitle = content2.getSubtitle();
            subTitle = subTitle != null ? FifaResources.getMessage(subTitle) : content2.getSubtitle();
            action = null;
            action = this.sizeMoreExtras < 2 ? new OpenLinkAction(this.sizeMoreExtras) : new OpenGameAction(this.sizeMoreExtras);
            TabView.mainForm.addItem(2, FifaResources.getMessage("FANAPP_EXTRAS_TXT"), content2.getTitle(), subTitle, content2.getIcon(), (Action)action);
            ++this.sizeMoreExtras;
        }
        int hasMoreExtras = IOUtility.sizeGameList();
        if (hasMoreExtras > 0) {
            TabView.mainForm.addMoreExtrasItem();
        }
        Enumeration en2 = this.model.getPreloadedVideos().elements();
        while (en2.hasMoreElements()) {
            content = (PreloadedContent)en2.nextElement();
            action = new OpenVideoAction(this.sizeExtraVideos);
            TabView.mainForm.addItem(2, FifaResources.getMessage("FANAPP_ENTERTAINMENT_VIDEOS_TXT"), FifaResources.getMessage(content.getTitle()), content.getSubtitle(), content.getIcon(), (Action)action);
            ++this.sizeExtraVideos;
        }
        TabView.mainForm.addExtraVideosItem();
        imagesPath = new String[this.model.getPreloadedPictures().size()];
        en2 = this.model.getPreloadedPictures().elements();
        while (en2.hasMoreElements()) {
            content = (PreloadedContent)en2.nextElement();
            imagesPath[index] = content.getLink();
            ++index;
        }
        TabView.mainForm.setEntertainmentHeadline(imagesPath);
        TabView.mainForm.setCrossfadePosition(2, FifaAbstractView.attributes.getCrossfadePosX());
        TabView.mainForm.startCrossfade(2);
        TabView.mainForm.revalidate();
        TabView.mainForm.fillEmptySpace(2);
        if (this.model.getPreloadedExtras().size() > 0) {
            this.firstGroup = FifaResources.getMessage("FANAPP_EXTRAS_TXT");
        } else if (this.model.getPreloadedVideos().size() > 0) {
            this.firstGroup = FifaResources.getMessage("FANAPP_ENTERTAINMENT_VIDEOS_TXT");
        }
        TabView.mainForm.focusFirstItem(2, this.firstGroup, true);
        TabView.mainForm.revalidate();
    }

    public void preloadedContentFailed(byte reason) {
        this.fireViewActionPerformed(new UpdateFailureAction(reason, this.model.isPreloadedContentUpdated()));
    }
}

