/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.OnlineContent;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.onlineContent.OnlineContentListListener;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.ExtraVideoSelectedAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.components.forms.ExtraVideosForm;
import com.sonyericsson.fifa.view.components.list.ExtraVideosItem;
import com.sonyericsson.fifa.view.tabs.BackgroundTask;
import java.util.Enumeration;
import java.util.Hashtable;

public class ExtraVideosView
extends FifaAbstractView
implements OnlineContentListListener {
    private ExtraVideosForm extraVideosForm;
    private Hashtable itemList = new Hashtable();

    public ExtraVideosView(Model model) {
        super(20, model);
        this.extraVideosForm = new ExtraVideosForm();
        this.extraVideosForm.addGroup();
        model.setOnlineContentListListener(this);
        this.doUpdateView();
    }

    protected void doClearFormText() {
    }

    protected void doHide() {
        this.extraVideosForm.setSelectableItemListener(null);
        this.extraVideosForm.setKeyListener(null);
        this.extraVideosForm.setTouchListener(null);
    }

    protected void doShow() throws ViewException {
        this.extraVideosForm.setSelectableItemListener(this);
        this.extraVideosForm.setKeyListener(this);
        this.extraVideosForm.setTouchListener(this);
        this.extraVideosForm.show();
    }

    protected void doUpdateView() {
        this.extraVideosForm.removeAllItems();
        this.extraVideosForm.removeWaitIndicator();
        if (this.model.isOnlineContentListUpdated()) {
            this.addListItems();
            this.extraVideosForm.focusFirstItem();
            this.extraVideosForm.revalidate();
        } else {
            this.extraVideosForm.showWaitIndicator();
        }
    }

    private void addListItems() {
        int index = 0;
        this.itemList.clear();
        Enumeration onlineContentList = this.model.getOnlineContentEnumeration();
        while (onlineContentList.hasMoreElements()) {
            OnlineContent content = (OnlineContent)onlineContentList.nextElement();
            if (content != null) {
                ExtraVideosItem item = new ExtraVideosItem(content);
                item.setAction(new ExtraVideoSelectedAction(index));
                this.extraVideosForm.addItem(item);
                this.itemList.put(content, item);
            }
            ++index;
        }
        this.extraVideosForm.revalidate();
        this.extraVideosForm.fillEmptySpace();
    }

    public void onTouchPressed(int valX, int valY) {
        this.performSoftkey();
    }

    public void onKeyPressed(int keyCode) {
        this.performSoftkey();
    }

    public void performSoftkey() {
        if (-7 == this.extraVideosForm.getSelectedSoftkey()) {
            this.model.setOnlineContentListListener(null);
            BackAction backAction = new BackAction();
            this.fireViewActionPerformed(backAction);
        }
    }

    public void selectedItem(Action action) {
        this.fireViewActionPerformed(action);
    }

    public void updateContent(byte reason, OnlineContent content) {
        if (reason != 0 && reason != 8) {
            this.handleError(reason, content);
        } else {
            this.updateItemOnEdt(content);
        }
    }

    private void updateItemOnEdt(final OnlineContent content) {
        new BackgroundTask(){

            public void performTask() {
                ExtraVideosItem item;
                if (content != null && (item = (ExtraVideosItem)ExtraVideosView.this.itemList.get(content)) != null) {
                    item.refreshIcon();
                }
            }
        }.start();
    }

    public void updateList(byte reason) {
        Logger.logInfo(this.getClass(), "updateList, reason: " + reason);
        switch (reason) {
            case 0: {
                this.updateView();
                break;
            }
            case 8: {
                break;
            }
            default: {
                this.handleError(reason, null);
            }
        }
    }

    private void handleError(byte error, OnlineContent content) {
        boolean viewDisplayable = false;
        if (this.model.isOnlineContentListUpdated()) {
            viewDisplayable = true;
            if (content == null) {
                this.updateView();
            } else {
                this.updateItemOnEdt(content);
            }
        }
        this.fireViewActionPerformed(new UpdateFailureAction(error, viewDisplayable));
    }
}

