/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.ams.Application;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.OpenGameExtrasAction;
import com.sonyericsson.fifa.view.components.forms.MoreExtrasForm;
import com.sun.lwuit.Image;

public class MoreExtrasView
extends FifaAbstractView {
    private MoreExtrasForm moreExtrasForm;
    private static String[] applicationIdList;

    public MoreExtrasView(Model model) {
        super(19, model);
        this.model = model;
        this.moreExtrasForm = new MoreExtrasForm();
        this.moreExtrasForm.addGroup(FifaResources.getMessage("FANAPP_MORE_EXTRAS_TXT"));
    }

    private void addListItems() {
        Image image = null;
        int pos = 0;
        applicationIdList = new String[IOUtility.sizeGameList()];
        applicationIdList = this.model.getApplicationIdList();
        String[] applicationListName = this.model.getApplicationGameName();
        if (SystemProperties.getPhonePlatform() != 2) {
            pos = 0;
            while (pos < applicationListName.length) {
                Application application = IOUtility.getJavaApplication(applicationListName[pos]);
                if (application != null) {
                    String iconPath = application.getProperty("MIDlet-Icon");
                    image = this.model.getIconMainApplication(iconPath, application);
                    OpenGameExtrasAction action = new OpenGameExtrasAction(applicationIdList[pos]);
                    if (image != null) {
                        this.moreExtrasForm.addItem(applicationListName[pos], image, action);
                    } else {
                        this.moreExtrasForm.addItem(applicationListName[pos], Images.getListIconGameDefault(), action);
                    }
                } else {
                    Logger.logError(this.getClass(), "Application not Found");
                }
                ++pos;
            }
        } else {
            pos = 0;
            while (pos < applicationListName.length) {
                OpenGameExtrasAction action = new OpenGameExtrasAction(applicationIdList[pos]);
                this.moreExtrasForm.addItem(applicationListName[pos], Images.getListIconGameDefault(), action);
                ++pos;
            }
        }
        this.moreExtrasForm.revalidate();
        this.moreExtrasForm.fillEmptySpace();
    }

    protected void doShow() throws ViewException {
        this.updateView();
        this.moreExtrasForm.setKeyListener(this);
        this.moreExtrasForm.setTouchListener(this);
        this.moreExtrasForm.setSelectableItemListener(this);
        this.moreExtrasForm.show();
    }

    protected void doHide() {
        this.moreExtrasForm.setSelectableItemListener(null);
        this.moreExtrasForm.setKeyListener(null);
        this.moreExtrasForm.setTouchListener(null);
    }

    public void selectedItem(Action action) {
        this.fireViewActionPerformed(action);
    }

    public void onKeyPressed(int keyCode) {
        this.performSoftkey();
    }

    public void onTouchPressed(int valX, int valY) {
        this.performSoftkey();
    }

    public void performSoftkey() {
        if (-7 == this.moreExtrasForm.getSelectedSoftkey()) {
            BackAction backAction = new BackAction();
            this.fireViewActionPerformed(backAction);
        }
    }

    protected void doUpdateView() {
        this.addListItems();
        this.moreExtrasForm.revalidate();
        this.moreExtrasForm.focusFirstItem(FifaResources.getMessage("FANAPP_MORE_EXTRAS_TXT"));
    }

    protected void doClearFormText() {
        this.moreExtrasForm.refreshAll();
        this.moreExtrasForm.addGroup(FifaResources.getMessage("FANAPP_MORE_EXTRAS_TXT"));
        this.updateView();
    }
}

