/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.teamList.TeamListener;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.TeamItemSelectedAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.components.forms.MyTeamForm;
import java.util.Vector;

public class MoreNewsView
extends FifaAbstractView
implements TeamListener {
    private Team myTeam;
    private MyTeamForm myTeamForm;
    private boolean teamUpdated = true;
    private String teamCode;
    private boolean firstUpdate;
    private static final int FEEDS_FIRST_PAGE = 5;

    public MoreNewsView(Model model, String teamCode) {
        super(8, model);
        this.model = model;
        this.teamCode = teamCode;
        this.model.addTeamListener(this.teamCode, this);
        this.myTeamForm = new MyTeamForm();
        this.myTeamForm.addGroup(FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"));
        this.firstUpdate = true;
        this.teamUpdated = true;
    }

    private Vector getLatestNews() {
        Feed latestNews;
        this.myTeam = this.model.getTeam(this.teamCode);
        if (this.myTeam != null && (latestNews = this.myTeam.getLatestNews()) != null) {
            return latestNews.getItems();
        }
        return null;
    }

    private void addListItems() {
        Vector itemList = this.getLatestNews();
        Enclosure enclosure = null;
        if (itemList != null && !itemList.isEmpty()) {
            int countList = itemList.size();
            int i = 5;
            while (i < countList) {
                FeedItem item = (FeedItem)itemList.elementAt(i);
                if (item != null) {
                    enclosure = item.getEnclosure();
                    TeamItemSelectedAction action = new TeamItemSelectedAction(i, this.teamCode);
                    if (enclosure != null && enclosure.getThumbPath() != null) {
                        this.myTeamForm.addItem(item.getTitle(), item.getDescription(), enclosure.getThumbPath(), (Action)action);
                    } else {
                        this.myTeamForm.addItem(item.getTitle(), item.getDescription(), Images.getListIconDefault(), (Action)action);
                    }
                }
                ++i;
            }
        }
        this.myTeamForm.removeWaitIndicator();
    }

    private void addComponents() {
        this.addListItems();
        this.myTeamForm.addCountryDataItemToFlag(this.getTeamGroup(this.teamCode), String.valueOf(this.teamCode) + "_SMALL");
        this.myTeamForm.revalidate();
    }

    protected void doShow() throws ViewException {
        this.viewId = 8;
        if (this.teamUpdated && this.firstUpdate) {
            this.firstUpdate = false;
            this.myTeamForm.showWaitIndicator(VerifyScreenDimension.getAttributesInstance().getWaitIndicatorHeightWithHeadline());
            this.updateView();
        }
        this.teamUpdated = false;
        this.myTeamForm.setKeyListener(this);
        this.myTeamForm.setTouchListener(this);
        this.myTeamForm.setSelectableItemListener(this);
        this.myTeamForm.show();
    }

    protected void doHide() {
        this.myTeamForm.setSelectableItemListener(null);
        this.myTeamForm.setKeyListener(null);
        this.myTeamForm.setTouchListener(null);
    }

    public void teamUpdateFinished(boolean newItemsAvailable, String teamCode) {
        this.teamUpdated = true;
    }

    public void thumbnailDownloaded(int index, Enclosure thumbnail) {
        if (index >= 5) {
            this.updateThumbnail(index -= 5, thumbnail);
        }
    }

    public void selectedItem(Action action) {
        this.fireViewActionPerformed(action);
    }

    public void onKeyPressed(int keyCode) {
        this.performSoftkey();
    }

    public void onTouchPressed(int valX, int valY) {
        this.performSoftkey();
    }

    public void performSoftkey() {
        if (-7 == this.myTeamForm.getSelectedSoftkey()) {
            this.getLanguage().removeLanguageListener(this);
            this.model.removeTeamListener(this.teamCode, this);
            BackAction backAction = new BackAction();
            this.fireViewActionPerformed(backAction);
        }
    }

    protected void doUpdateView() {
        this.addComponents();
        this.myTeamForm.focusFirstItem(FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"));
    }

    protected void doUpdateThumbnail(int index, Enclosure thumbnail) {
        this.myTeamForm.setItemPicture(index, thumbnail.getThumbPath());
    }

    public void teamUpdateStarted() {
    }

    protected void doClearFormText() {
        if (!this.myTeamForm.isTeamItems()) {
            this.myTeamForm.refreshAll();
            this.myTeamForm.addGroup(FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"));
            this.updateView();
        } else {
            this.myTeamForm.refreshAll();
            this.myTeamForm.addGroup(FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"));
        }
    }

    public void teamUpdateFailed(byte reason) {
        boolean viewDisplayable = false;
        Team team = this.model.getTeam(this.teamCode);
        if (team != null && team.getLatestNews() != null) {
            viewDisplayable = true;
        }
        this.fireViewActionPerformed(new UpdateFailureAction(reason, viewDisplayable));
    }
}

