/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.teamList.TeamListener;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.ManualUpdateAction;
import com.sonyericsson.fifa.view.action.TeamItemSelectedAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.action.UpdateMyTeamAction;
import com.sonyericsson.fifa.view.tabs.BackgroundTask;
import com.sonyericsson.fifa.view.tabs.TabView;
import java.util.Vector;

public class MyTeamView
extends TabView
implements TeamListener {
    private Model model = null;
    private boolean isShowingWaitIndicator = false;
    private boolean isFirstUpdate = true;
    private boolean isFirstShow = true;
    private boolean updateOrdered = false;
    private String teamCode;
    public static final String FLAG_NAME = "_SMALL";
    public boolean isTickerVisible;

    public MyTeamView(Model model) {
        super(1, model);
        this.model = model;
        TabView.mainForm.myTeamAddGroups();
        TabView.mainForm.setSoftKeyLabel(0);
    }

    protected int getNextTab() {
        return 2;
    }

    protected int getPreviousTab() {
        return 3;
    }

    protected void doShow() throws ViewException {
        TabView.mainForm.setTab(0);
        this.teamCode = this.model.getMyTeam().getTeamCode();
        this.model.addTeamListener(this.teamCode, this);
        this.viewId = 1;
        if (this.isFirstShow) {
            this.isShowingWaitIndicator = true;
            if (this.selectedItem) {
                TabView.mainForm.showWaitIndicator(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"));
            }
        } else if (!this.isShowingWaitIndicator) {
            if (this.model.getMyTeam().isTeamNewsUpdating()) {
                this.isTickerVisible = true;
                TabView.mainForm.addFeedTicker(false);
            } else {
                if (this.model.getMyTeam().isTeamNewsUpdatedWithNewItems()) {
                    this.isTickerVisible = true;
                    TabView.mainForm.addFeedTicker(true);
                }
                if (!this.selectedItem) {
                    this.focusFirstItem();
                }
            }
        }
        this.isFirstShow = false;
        this.selectedItem = false;
        TabView.mainForm.show();
        TabView.mainForm.addSelectedItemListener(this);
        TabView.mainForm.setKeyListener(this);
        TabView.mainForm.setTouchListener(this);
    }

    public void focusFirstItem() {
        TabView.mainForm.focusFirstItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), true);
    }

    protected void doHide() {
        super.doHide();
    }

    public void teamUpdateStarted() {
        new BackgroundTask(){

            public void performTask() {
                if (!MyTeamView.this.isShowingWaitIndicator) {
                    MyTeamView.this.isTickerVisible = true;
                    TabView.mainForm.addFeedTicker(false);
                    if (TabView.mainForm.isFirstItemFocused(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"))) {
                        MyTeamView.this.focusFirstItem();
                    }
                }
            }
        }.start();
    }

    public void teamUpdateFinished(final boolean newItemsAvailable, String teamCodeUpdated) {
        if (teamCodeUpdated.compareTo(this.teamCode) == 0) {
            new BackgroundTask(){

                public void performTask() {
                    if (newItemsAvailable) {
                        MyTeamView.this.updateView();
                    } else {
                        if (MyTeamView.this.isTickerVisible && !MyTeamView.this.model.getMyTeam().isTeamNewsUpdatedWithNewItems()) {
                            TabView.mainForm.removeFeedTicker();
                            MyTeamView.this.isTickerVisible = false;
                        }
                        if (MyTeamView.this.isFirstUpdate) {
                            MyTeamView.this.updateView();
                        }
                    }
                    if (TabView.mainForm.isFirstItemFocused(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT")) && !MyTeamView.this.model.getMyTeam().isTeamNewsUpdating()) {
                        MyTeamView.this.focusFirstItem();
                    }
                    TabView.mainForm.revalidate();
                }
            }.start();
        }
    }

    private void addComponents() {
        TabView.mainForm.setFlagHeadline(this.teamCode);
        TabView.mainForm.addCountryDataItemToFlag(this.getTeamGroup(this.teamCode), String.valueOf(this.teamCode) + FLAG_NAME);
        this.addNewsItems();
        this.addTeamItems();
        this.focusFirstItem();
    }

    private void addNewsItems() {
        Enclosure enclosure = null;
        int maxItensDisp = FifaAbstractView.attributes.getMaxItemsDisplayed();
        TabView.mainForm.addFifaButton();
        Vector items = this.model.getTeam(this.teamCode).getLatestNews().getItems();
        int countItems = items.size();
        int i = 0;
        while (i < countItems && i < maxItensDisp) {
            FeedItem item = (FeedItem)items.elementAt(i);
            enclosure = item.getEnclosure();
            TeamItemSelectedAction teamItemAction = new TeamItemSelectedAction(i, this.teamCode);
            if (enclosure != null && enclosure.getThumbPath() != null) {
                TabView.mainForm.addItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), item.getTitle(), SystemProperties.clearHtmlString(item.getDescription()), enclosure.getThumbPath(), (Action)teamItemAction);
            } else {
                TabView.mainForm.addItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), item.getTitle(), SystemProperties.clearHtmlString(item.getDescription()), Images.getListIconDefault(), (Action)teamItemAction);
            }
            ++i;
        }
        TabView.mainForm.addMoreItem(this.teamCode);
    }

    private void addTeamItems() {
        TabView.mainForm.addChangeTeamItem();
        TabView.mainForm.addOptionsItem();
    }

    public void thumbnailDownloaded(int index, Enclosure thumbnail) {
        this.updateThumbnail(index, thumbnail);
    }

    public void selectedItem(Action action) {
        this.selectedItem = true;
        if (action instanceof UpdateMyTeamAction) {
            if (this.isTickerVisible) {
                this.isTickerVisible = false;
                TabView.mainForm.removeFeedTicker();
            }
            this.updateOrdered = true;
        }
        this.fireViewActionPerformed(action);
    }

    public void performSoftkey() {
    }

    protected void doUpdateView() {
        if (this.isFirstShow) {
            this.addComponents();
            TabView.mainForm.removeWaitIndicator(0);
            this.isFirstShow = false;
        } else if (this.isFirstUpdate || this.updateOrdered) {
            this.isTickerVisible = false;
            this.isFirstUpdate = false;
            this.updateOrdered = false;
            TabView.mainForm.myTeamRemoveAll();
            this.isShowingWaitIndicator = false;
            this.addComponents();
        } else if (!this.isShowingWaitIndicator && this.isTickerVisible && this.model.getMyTeam().isTeamNewsUpdatedWithNewItems()) {
            this.isTickerVisible = true;
            TabView.mainForm.addFeedTicker(true);
        }
        TabView.mainForm.revalidate();
    }

    public void setFirstUpdate(boolean isFirstUpdate) {
        TabView.mainForm.refreshAll(0, false);
        this.isFirstUpdate = isFirstUpdate;
        this.isFirstShow = true;
    }

    protected void doUpdateThumbnail(int index, Enclosure thumbnail) {
        if (index < FifaAbstractView.attributes.getMaxItemsDisplayed()) {
            TabView.mainForm.setItemPicture(index, thumbnail.getThumbPath());
        }
    }

    protected void doClearFormText() {
        if (!TabView.mainForm.isGroupEmpty(0)) {
            TabView.mainForm.refreshAll(0, true);
            this.isFirstShow = true;
            this.updateView();
        } else {
            TabView.mainForm.refreshAll(0, true);
        }
    }

    public void teamUpdateFailed(byte reason) {
        Team myTeam = this.model.getMyTeam();
        if (myTeam != null && myTeam.getLatestNews() != null) {
            this.fireViewActionPerformed(new UpdateFailureAction(reason, true));
            new BackgroundTask(){

                public void performTask() {
                    if (MyTeamView.this.isShowingWaitIndicator) {
                        MyTeamView.this.updateView();
                    } else if (MyTeamView.this.isTickerVisible) {
                        MyTeamView.this.isTickerVisible = false;
                        TabView.mainForm.removeFeedTicker();
                    }
                }
            }.start();
        } else {
            this.fireViewActionPerformed(new UpdateFailureAction(reason, false));
        }
    }

    public void myTeamManualUpdate() {
        this.fireViewActionPerformed(new ManualUpdateAction());
    }

    public void onKeyPressed(int keyCode) {
        if (keyCode == -6) {
            this.myTeamManualUpdate();
        } else {
            super.onKeyPressed(keyCode);
        }
    }

    public void onTouchPressed(int x, int y) {
        if (TabView.mainForm.getSelectedSoftkey() == -6) {
            this.myTeamManualUpdate();
        } else {
            super.onTouchPressed(x, y);
        }
    }
}

