/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.UpgradeAction;
import com.sonyericsson.fifa.view.action.WidgetAction;
import com.sonyericsson.fifa.view.components.forms.OptionsForm;

public class OptionsView
extends FifaAbstractView {
    private OptionsForm optionsForm = new OptionsForm();

    public OptionsView(Model model) {
        super(11, model);
        this.optionsForm.setHomescreenCheckBox(model.isWidgetActivated());
        this.optionsForm.setHomeNetworkOnlyCheckBox(model.isHomeNetworkOnlyActivated());
        this.optionsForm.show();
    }

    protected void doHide() {
        this.optionsForm.setKeyListener(null);
        this.optionsForm.setTouchListener(null);
        this.optionsForm.setSelectableItemListener(null);
    }

    protected void doShow() throws ViewException {
        this.optionsForm.setKeyListener(this);
        this.optionsForm.setSelectableItemListener(this);
        this.optionsForm.setTouchListener(this);
        this.optionsForm.show();
    }

    public void onKeyPressed(int keyCode) {
        switch (keyCode) {
            case -7: {
                this.getLanguage().removeLanguageListener(this);
                this.performSoftkey();
                break;
            }
            case -5: {
                if (this.optionsForm.getApplicationUgradeStatus()) {
                    this.optionsForm.setApplicationUgradeStatus(false);
                    UpgradeAction upgrade = new UpgradeAction(false, true);
                    this.fireViewActionPerformed(upgrade);
                    break;
                }
                if (!this.optionsForm.getWidgetUgradeStatus()) break;
                this.optionsForm.setWidgetUgradeStatus(false);
                UpgradeAction upgrade = new UpgradeAction(true, false);
                this.fireViewActionPerformed(upgrade);
            }
        }
    }

    public void onTouchPressed(int valX, int valY) {
        if (this.optionsForm.getSelectedSoftkey() == -7) {
            this.performSoftkey();
        } else if (this.optionsForm.getApplicationUgradeStatus()) {
            this.optionsForm.setApplicationUgradeStatus(false);
            UpgradeAction upgrade = new UpgradeAction(false, true);
            this.fireViewActionPerformed(upgrade);
        } else if (this.optionsForm.getWidgetUgradeStatus()) {
            this.optionsForm.setWidgetUgradeStatus(false);
            UpgradeAction upgrade = new UpgradeAction(true, false);
            this.fireViewActionPerformed(upgrade);
        }
    }

    public void performSoftkey() {
        if (this.optionsForm.isHomescreenCheckboxSelected() != this.model.isWidgetActivated() || this.optionsForm.isHomeNetworkOnlyCheckboxSelected() != this.model.isHomeNetworkOnlyActivated()) {
            WidgetAction widget = new WidgetAction(this.optionsForm.isHomescreenCheckboxSelected(), this.optionsForm.isHomeNetworkOnlyCheckboxSelected());
            this.fireViewActionPerformed(widget);
        }
        this.optionsForm.isUpdateCheckboxSelected();
        BackAction back = new BackAction();
        this.fireViewActionPerformed(back);
    }

    public void selectedItem(Action action) {
        this.fireViewActionPerformed(action);
    }

    protected void doUpdateView() {
    }

    protected void doClearFormText() {
    }
}

