/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.MinimizeAction;
import com.sonyericsson.fifa.view.action.NextTabAction;
import com.sonyericsson.fifa.view.components.forms.MainForm;

public abstract class TabView
extends FifaAbstractView {
    protected static final MainForm mainForm = new MainForm();
    protected boolean selectedItem = false;

    public TabView(int viewId, Model model) {
        super(viewId, model);
    }

    protected abstract int getNextTab();

    protected abstract int getPreviousTab();

    protected void doHide() {
        mainForm.setKeyListener(null);
        mainForm.setTouchListener(null);
        mainForm.removeSelectedItemListener(this);
    }

    public void onKeyPressed(int keyCode) {
        if (keyCode == -7) {
            this.fireViewActionPerformed(new MinimizeAction());
        } else if (keyCode == -4) {
            this.changeTab(this.getNextTab());
        } else if (keyCode == -3) {
            this.changeTab(this.getPreviousTab());
        }
    }

    public void onTouchPressed(int valX, int valY) {
        if (valX == 0) {
            if (valY == 0) {
                this.changeTab(this.getPreviousTab());
            } else if (valY == 1) {
                this.changeTab(this.getNextTab());
            }
        } else if (-7 == mainForm.getSelectedSoftkey()) {
            this.fireViewActionPerformed(new BackAction());
        }
    }

    private void changeTab(int tab) {
        NextTabAction action;
        NextTabAction nextTabAction = action = new NextTabAction((byte)tab);
        this.fireViewActionPerformed(nextTabAction);
    }
}

