/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.teamList.TeamListener;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.TeamItemSelectedAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.components.forms.TeamForm;
import java.util.Vector;

public class TeamView
extends FifaAbstractView
implements TeamListener {
    private Model model = null;
    private String teamCode;
    private TeamForm teamForm = new TeamForm();
    private boolean isFirstUpdate = true;
    private boolean isFirstShow = true;

    public TeamView(Model model, String teamCode) {
        super(13, model);
        this.teamForm.addGroups();
        this.teamForm.setFlagHeadline(teamCode);
        this.model = model;
        this.teamCode = teamCode;
        this.model.addTeamListener(teamCode, this);
    }

    protected void doShow() throws ViewException {
        this.viewId = 13;
        if (this.isFirstShow) {
            this.teamForm.showWaitIndicator();
        }
        this.isFirstShow = false;
        this.model.addTeamListener(this.teamCode, this);
        this.teamForm.setSelectableItemListener(this);
        this.teamForm.setTouchListener(this);
        this.teamForm.setKeyListener(this);
        this.teamForm.show();
    }

    protected void doHide() {
        this.teamForm.removeWaitIndicator();
        this.teamForm.setKeyListener(null);
        this.teamForm.setTouchListener(null);
    }

    public void teamUpdateStarted() {
    }

    public void teamUpdateFinished(boolean newItemsAvailable, String teamCode) {
        this.isFirstShow = false;
        this.updateView();
    }

    private void addComponents() {
        this.addNewsItems();
        this.teamForm.revalidate();
        this.teamForm.fillEmptySpaceWithTeamFlag();
    }

    private void addNewsItems() {
        Enclosure enclosure = null;
        int maxItensDisp = FifaAbstractView.attributes.getMaxItemsDisplayed();
        Vector items = this.model.getTeam(this.teamCode).getLatestNews().getItems();
        int countItems = items.size();
        int i = 0;
        while (i < countItems && i < maxItensDisp) {
            FeedItem item = (FeedItem)items.elementAt(i);
            enclosure = item.getEnclosure();
            TeamItemSelectedAction action = new TeamItemSelectedAction(i, this.teamCode);
            if (enclosure != null && enclosure.getThumbPath() != null) {
                this.teamForm.addItem(item.getTitle(), item.getDescription(), enclosure.getThumbPath(), (Action)action);
            } else {
                this.teamForm.addItem(item.getTitle(), item.getDescription(), Images.getListIconDefault(), (Action)action);
            }
            ++i;
        }
        this.teamForm.addMoreItem(this.teamCode);
        this.teamForm.addCountryDataItemToFlag(this.getTeamGroup(this.teamCode), String.valueOf(this.teamCode) + "_SMALL");
        this.teamForm.removeWaitIndicator();
    }

    public void thumbnailDownloaded(int index, Enclosure thumbnail) {
        this.updateThumbnail(index, thumbnail);
    }

    public void selectedItem(Action action) {
        this.fireViewActionPerformed(action);
    }

    public void onKeyPressed(int keyCode) {
        this.performSoftkey();
    }

    public void onTouchPressed(int valX, int valY) {
        this.performSoftkey();
    }

    public void performSoftkey() {
        if (-7 == this.teamForm.getSelectedSoftkey()) {
            this.getLanguage().removeLanguageListener(this);
            this.model.removeTeamListener(this.teamCode, this);
            this.fireViewActionPerformed(new BackAction());
        }
    }

    protected void doUpdateView() {
        if (this.isFirstUpdate) {
            this.isFirstUpdate = false;
            this.addComponents();
            this.teamForm.focusFirstItem();
            this.teamForm.revalidate();
        }
    }

    protected void doUpdateThumbnail(int index, Enclosure thumbnail) {
        if (index < FifaAbstractView.attributes.getMaxItemsDisplayed()) {
            this.teamForm.setItemPicture(index, thumbnail.getThumbPath());
        }
    }

    protected void doClearFormText() {
        if (!this.teamForm.isTeamItems()) {
            this.teamForm.refreshAll();
            this.teamForm.addGroups();
            this.isFirstUpdate = true;
            this.updateView();
        } else {
            this.teamForm.refreshAll();
            this.teamForm.addGroups();
            this.isFirstUpdate = true;
        }
    }

    public void teamUpdateFailed(byte reason) {
        boolean viewDisplayable = false;
        Team team = this.model.getTeam(this.teamCode);
        if (team != null && team.getLatestNews() != null && team.getLatestNews().getItems() != null && !team.getLatestNews().getItems().isEmpty()) {
            viewDisplayable = true;
            this.updateView();
        }
        this.fireViewActionPerformed(new UpdateFailureAction(reason, viewDisplayable));
    }
}

