/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.Group;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.tournamentTable.TournamentTableListener;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.SelectedTournamentTeamAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.tabs.TabView;
import java.util.Enumeration;
import java.util.Vector;

public class TournamentView
extends TabView
implements TournamentTableListener {
    private final Vector availableTeams = new Vector();
    private Vector groupName;

    public TournamentView(Model model) {
        super(2, model);
        TabView.mainForm.tournamentAddGroups(this.getGroupVector(true));
        if (model.isTournamentUpdated()) {
            this.updateView();
        }
        model.addTournamentTableListener(this);
    }

    protected int getNextTab() {
        return 3;
    }

    protected int getPreviousTab() {
        return 1;
    }

    private Vector getGroupVector(boolean boolCreateNew) {
        if (boolCreateNew) {
            this.groupName = new Vector();
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPA_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPB_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPC_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPD_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPE_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPF_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPG_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPH_TXT"));
        }
        return this.groupName;
    }

    protected void doShow() throws ViewException {
        TabView.mainForm.setTab(1);
        this.viewId = 2;
        if (!this.selectedItem) {
            TabView.mainForm.focusFirstItem(1, FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPA_TXT"), false);
            TabView.mainForm.revalidate();
        }
        this.selectedItem = false;
        TabView.mainForm.show();
        TabView.mainForm.setKeyListener(this);
        TabView.mainForm.setTouchListener(this);
        TabView.mainForm.addSelectedItemListener(this);
    }

    public void tournamentTableUpdated() {
        this.updateView();
    }

    public void selectedItem(Action action) {
        this.selectedItem = true;
        this.fireViewActionPerformed(action);
    }

    public void performSoftkey() {
    }

    protected void doUpdateView() {
        Vector tournamentGroups = this.model.getTournamentGroups();
        if (tournamentGroups != null) {
            Enumeration groups = tournamentGroups.elements();
            while (groups.hasMoreElements()) {
                Group group = (Group)groups.nextElement();
                if (group == null) continue;
                Enumeration teams = group.getTeamCodes();
                while (teams.hasMoreElements()) {
                    String teamCode = (String)teams.nextElement();
                    String groupName = FifaResources.getMessage("FANAPP_TOURNAMSTATUS_" + group.getGroupName() + "_TXT");
                    SelectedTournamentTeamAction action = new SelectedTournamentTeamAction(teamCode);
                    TabView.mainForm.addItem(1, groupName, FifaResources.getMessage("FANAPP_TEAMNAME_" + teamCode + "_TXT"), null, String.valueOf(FifaResources.getImageFolder()) + teamCode + ".png", (Action)action);
                    this.availableTeams.addElement(teamCode);
                }
            }
        }
        TabView.mainForm.removeWaitIndicator(1);
        TabView.mainForm.focusFirstItem(1, FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPA_TXT"), true);
        TabView.mainForm.revalidate();
    }

    protected void doClearFormText() {
        if (!TabView.mainForm.isGroupEmpty(1)) {
            TabView.mainForm.refreshAll(1, true);
            TabView.mainForm.tournamentAddGroups(this.getGroupVector(true));
            this.updateView();
        } else {
            TabView.mainForm.refreshAll(1, true);
            TabView.mainForm.tournamentAddGroups(this.getGroupVector(true));
        }
    }

    public void tournamentTableUpdateFailed(byte reason) {
        this.fireViewActionPerformed(new UpdateFailureAction(reason, this.model.isTournamentUpdated()));
    }
}

