/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.ChangeTeamAction;
import com.sonyericsson.fifa.view.components.forms.WelcomeForm;

public class WelcomeView
extends FifaAbstractView {
    private WelcomeForm welcomeForm = new WelcomeForm();

    public WelcomeView(Model model) {
        super(5, model);
    }

    protected void doHide() {
        this.welcomeForm.setKeyListener(null);
        this.welcomeForm.setSelectableItemListener(null);
        this.welcomeForm.setTouchListener(null);
    }

    protected void doShow() throws ViewException {
        this.welcomeForm.simulateMiddleSoftkeyReleased();
        this.welcomeForm.setKeyListener(this);
        this.welcomeForm.setTouchListener(this);
        this.welcomeForm.setSelectableItemListener(this);
        this.welcomeForm.show();
    }

    public void onKeyPressed(int keyCode) {
        this.performSoftkey();
    }

    public void onTouchPressed(int valX, int valY) {
        this.performSoftkey();
    }

    public void performSoftkey() {
        switch (this.welcomeForm.getSelectedSoftkey()) {
            case -5: {
                ChangeTeamAction action = new ChangeTeamAction();
                this.fireViewActionPerformed(action);
                break;
            }
            case -7: {
                this.getLanguage().removeLanguageListener(this);
                BackAction backAction = new BackAction();
                this.fireViewActionPerformed(backAction);
            }
        }
    }

    public void selectedItem(Action action) {
        this.fireViewActionPerformed(action);
    }

    protected void doUpdateView() {
        this.welcomeForm.refreshAll();
        this.welcomeForm.revalidate();
    }

    protected void doClearFormText() {
        this.updateView();
    }

    public void destroy() {
        this.getLanguage().removeLanguageListener(this);
    }
}

