/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.RunnableWrapper;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.impl.ImplementationFactory;
import com.sun.lwuit.impl.LWUITImplementation;
import java.io.InputStream;
import java.util.Vector;

public final class Display {
    public static final int KEYBOARD_TYPE_UNKNOWN = 0;
    public static final int KEYBOARD_TYPE_NUMERIC = 1;
    public static final int KEYBOARD_TYPE_QWERTY = 2;
    public static final int KEYBOARD_TYPE_VIRTUAL = 3;
    public static final int KEYBOARD_TYPE_HALF_QWERTY = 4;
    private static final int POINTER_PRESSED = 1;
    private static final int POINTER_RELEASED = 2;
    private static final int POINTER_DRAGGED = 3;
    private static final int POINTER_HOVER = 8;
    private static final int POINTER_HOVER_RELEASED = 11;
    private static final int KEY_PRESSED = 4;
    private static final int KEY_RELEASED = 5;
    private static final int KEY_LONG_PRESSED = 6;
    private static final int SIZE_CHANGED = 7;
    private static final int HIDE_NOTIFY = 9;
    private static final int SHOW_NOTIFY = 10;
    private Graphics lwuitGraphics;
    private boolean touchScreen;
    private int framerateLock = 20;
    private boolean lightMode;
    public static final int GAME_FIRE = 8;
    public static final int GAME_LEFT = 2;
    public static final int GAME_RIGHT = 5;
    public static final int GAME_UP = 1;
    public static final int GAME_DOWN = 6;
    public static final int KEY_POUND = 35;
    private static final Display INSTANCE = new Display();
    static int transitionDelay = -1;
    private LWUITImplementation impl;
    private boolean lwuitRunning = false;
    private Vector pendingSerialCalls = new Vector();
    private Thread edt;
    private boolean edtPaused = false;
    private Vector animationQueue;
    private boolean thirdSoftButton = false;
    private boolean editingText;
    public static final int SHOW_DURING_EDIT_IGNORE = 1;
    public static final int SHOW_DURING_EDIT_EXCEPTION = 2;
    public static final int SHOW_DURING_EDIT_ALLOW_DISCARD = 3;
    public static final int SHOW_DURING_EDIT_ALLOW_SAVE = 4;
    public static final int SHOW_DURING_EDIT_SET_AS_NEXT = 5;
    private int showDuringEdit;
    static final Object lock = new Object();
    private Vector inputEvents = new Vector();
    private boolean longPointerCharged;
    private int pointerX;
    private int pointerY;
    private boolean keyRepeatCharged;
    private boolean longPressCharged;
    private long longKeyPressTime;
    private int longPressInterval = 800;
    private long nextKeyRepeatEvent;
    private int keyRepeatValue;
    private int keyRepeatInitialIntervalTime = 800;
    private int keyRepeatNextIntervalTime = 10;
    private boolean keyReleasedSinceEdit;
    private boolean processingSerialCalls;
    private int PATHLENGTH;
    private float[] dragPathX;
    private float[] dragPathY;
    private long[] dragPathTime;
    private int dragPathOffset = 0;
    private int dragPathLength = 0;
    long time;
    private int lastKeyPressed;

    private Display() {
    }

    Vector getAnimationQueue() {
        return this.animationQueue;
    }

    public static void init(Object m) {
        if (Display.INSTANCE.impl == null) {
            Display.INSTANCE.lwuitRunning = true;
            Display.INSTANCE.impl = ImplementationFactory.getInstance().createImplementation();
            Display.INSTANCE.impl.setDisplayLock(lock);
            Display.INSTANCE.impl.init(m);
            Display.INSTANCE.lwuitGraphics = new Graphics(Display.INSTANCE.impl.getNativeGraphics());
            Display.INSTANCE.impl.setLWUITGraphics(Display.INSTANCE.lwuitGraphics);
            if (Display.INSTANCE.impl.isThirdSoftButton()) {
                Display.INSTANCE.thirdSoftButton = true;
            }
            if (Display.INSTANCE.impl.getSoftkeyCount() > 0) {
                Form.leftSK = Display.INSTANCE.impl.getSoftkeyCode(0)[0];
                if (Display.INSTANCE.impl.getSoftkeyCount() > 1) {
                    Form.rightSK = Display.INSTANCE.impl.getSoftkeyCode(1)[0];
                    if (Display.INSTANCE.impl.getSoftkeyCode(1).length > 1) {
                        Form.rightSK2 = Display.INSTANCE.impl.getSoftkeyCode(1)[1];
                    }
                }
                Form.backSK = Display.INSTANCE.impl.getBackKeyCode();
                Form.backspaceSK = Display.INSTANCE.impl.getBackspaceKeyCode();
                Form.clearSK = Display.INSTANCE.impl.getClearKeyCode();
            }
            int width = INSTANCE.getDisplayWidth();
            int height = INSTANCE.getDisplayHeight();
            int colors = INSTANCE.numColors();
            Display.INSTANCE.PATHLENGTH = Display.INSTANCE.impl.getDragPathLength();
            Display.INSTANCE.dragPathX = new float[Display.INSTANCE.PATHLENGTH];
            Display.INSTANCE.dragPathY = new float[Display.INSTANCE.PATHLENGTH];
            Display.INSTANCE.dragPathTime = new long[Display.INSTANCE.PATHLENGTH];
            boolean bl = Display.INSTANCE.lightMode = colors > 65536 && (long)(width * height * 30) > Runtime.getRuntime().totalMemory();
            if (Display.INSTANCE.edt == null) {
                Display.INSTANCE.touchScreen = Display.INSTANCE.impl.isTouchDevice();
                Display.INSTANCE.edt = new Thread((Runnable)new RunnableWrapper(null, 3), "EDT");
                Display.INSTANCE.edt.setPriority(6);
                Display.INSTANCE.edt.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deinitialize() {
        Display.INSTANCE.lwuitRunning = false;
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    public static Display getInstance() {
        return INSTANCE;
    }

    public int getDragStartPercentage() {
        return this.getImplementation().getDragStartPercentage();
    }

    public void setDragStartPercentage(int dragStartPercentage) {
        this.getImplementation().setDragStartPercentage(dragStartPercentage);
    }

    LWUITImplementation getImplementation() {
        return this.impl;
    }

    public void setFramerate(int rate) {
        this.framerateLock = 1000 / rate;
    }

    public void vibrate(int duration) {
        this.impl.vibrate(duration);
    }

    public void flashBacklight(int duration) {
        this.impl.flashBacklight(duration);
    }

    public void setShowDuringEditBehavior(int showDuringEdit) {
        this.showDuringEdit = showDuringEdit;
    }

    public int getShowDuringEditBehavior() {
        return this.showDuringEdit;
    }

    public int getFrameRate() {
        return 1000 / this.framerateLock;
    }

    public boolean isEdt() {
        return this.edt == Thread.currentThread();
    }

    void playDialogSound(int type) {
        this.impl.playDialogSound(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSerially(Runnable r) {
        Object object = lock;
        synchronized (object) {
            this.pendingSerialCalls.addElement(r);
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callSeriallyAndWait(Runnable r) {
        RunnableWrapper c = new RunnableWrapper(r, 0);
        this.callSerially(c);
        Object object = lock;
        synchronized (object) {
            while (!c.isDone()) {
                try {
                    lock.wait(50L);
                }
                catch (InterruptedException err) {}
            }
        }
    }

    void flushEdt() {
        if (!this.isEdt()) {
            return;
        }
        while (!this.shouldEDTSleepNoFormAnimation()) {
            this.edtLoopImpl();
        }
        while (this.animationQueue != null && this.animationQueue.size() > 0) {
            this.edtLoopImpl();
        }
    }

    private void restoreMenu(Form f) {
        if (f != null) {
            f.restoreMenu();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTransitionAnimation() {
        Animation ani = (Animation)this.animationQueue.elementAt(0);
        if (!ani.animate()) {
            this.animationQueue.removeElementAt(0);
            if (ani instanceof Transition) {
                Form source = (Form)((Transition)ani).getSource();
                this.restoreMenu(source);
                if (this.animationQueue.size() > 0) {
                    ani = (Animation)this.animationQueue.elementAt(0);
                    if (ani instanceof Transition) {
                        ((Transition)ani).initTransition();
                    }
                } else {
                    Form f = (Form)((Transition)ani).getDestination();
                    this.restoreMenu(f);
                    if (source == null || source == this.impl.getCurrentForm() || source == this.getCurrent()) {
                        this.setCurrentForm(f);
                    }
                    ((Transition)ani).cleanup();
                }
                return;
            }
        }
        ani.paint(this.lwuitGraphics);
        this.impl.flushGraphics();
        if (transitionDelay > 0) {
            try {
                Object source = lock;
                synchronized (source) {
                    lock.wait(transitionDelay);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mainEDTLoop() {
        block15: {
            try {
                Object object = lock;
                synchronized (object) {
                    while (this.impl.getCurrentForm() == null) {
                        if (this.shouldEDTSleep()) {
                            lock.wait();
                        }
                        if (this.animationQueue != null && this.animationQueue.size() > 0) {
                            this.paintTransitionAnimation();
                            continue;
                        }
                        this.processSerialCalls();
                    }
                }
            }
            catch (Throwable err) {
                err.printStackTrace();
                if (this.impl.handleEDTException(err)) break block15;
                Dialog.show("Error", "An internal application error occurred: " + err.toString(), "OK", null);
            }
        }
        while (this.lwuitRunning) {
            try {
                Object err = lock;
                synchronized (err) {
                    if (this.shouldEDTSleep()) {
                        this.impl.edtIdle(true);
                        lock.wait();
                        this.impl.edtIdle(false);
                    }
                }
                this.edtLoopImpl();
            }
            catch (Throwable err) {
                err.printStackTrace();
                if (this.impl.handleEDTException(err)) continue;
                Dialog.show("Error", "An internal application error occurred: " + err.toString(), "OK", null);
            }
        }
        Display.INSTANCE.impl = null;
        Display.INSTANCE.lwuitGraphics = null;
        Display.INSTANCE.edt = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void edtLoopImpl() {
        block10: {
            try {
                if (this.animationQueue == null || this.animationQueue.size() == 0) {
                    Object object = lock;
                    synchronized (object) {
                        lock.wait(Math.max(30L, (long)this.framerateLock - this.time));
                        break block10;
                    }
                }
                this.paintTransitionAnimation();
                return;
            }
            catch (Exception ignor) {
                ignor.printStackTrace();
            }
        }
        long currentTime = System.currentTimeMillis();
        while (this.inputEvents.size() > 0) {
            int[] i = (int[])this.inputEvents.elementAt(0);
            this.inputEvents.removeElementAt(0);
            this.handleEvent(i);
        }
        this.lwuitGraphics.setGraphics(this.impl.getNativeGraphics());
        this.impl.paintDirty();
        Form current = this.impl.getCurrentForm();
        current.repaintAnimations();
        long t = System.currentTimeMillis();
        if (this.keyRepeatCharged && this.nextKeyRepeatEvent <= t) {
            current.keyRepeated(this.keyRepeatValue);
            this.nextKeyRepeatEvent = t + (long)this.keyRepeatNextIntervalTime;
        }
        if (this.longPressCharged && (long)this.longPressInterval <= t - this.longKeyPressTime) {
            this.longPressCharged = false;
            current.longKeyPress(this.keyRepeatValue);
        }
        if (this.longPointerCharged && (long)this.longPressInterval <= t - this.longKeyPressTime) {
            this.longPointerCharged = false;
            current.longPointerPress(this.pointerX, this.pointerY);
        }
        this.processSerialCalls();
        this.time = System.currentTimeMillis() - currentTime;
    }

    boolean hasNoSerialCallsPending() {
        return this.pendingSerialCalls.size() == 0;
    }

    public void onEditingComplete(Component c, String text) {
        c.onEditComplete(text);
        c.fireActionEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSerialCalls() {
        this.processingSerialCalls = true;
        int size = this.pendingSerialCalls.size();
        if (size > 0) {
            Runnable[] array = new Runnable[size];
            for (int iter = 0; iter < size; ++iter) {
                array[iter] = (Runnable)this.pendingSerialCalls.elementAt(iter);
            }
            Object iter = lock;
            synchronized (iter) {
                if (size == this.pendingSerialCalls.size()) {
                    this.pendingSerialCalls.removeAllElements();
                } else {
                    for (int iter2 = 0; iter2 < size; ++iter2) {
                        this.pendingSerialCalls.removeElementAt(0);
                    }
                }
            }
            for (int iter3 = 0; iter3 < size; ++iter3) {
                array[iter3].run();
            }
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
        }
        this.processingSerialCalls = false;
    }

    boolean isProcessingSerialCalls() {
        return this.processingSerialCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDisplay() {
        Object object = lock;
        synchronized (object) {
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndBlock(Runnable r) {
        if (this.isEdt()) {
            RunnableWrapper w = new RunnableWrapper(r, 1);
            RunnableWrapper.pushToThreadPull(w);
            while (!w.isDone()) {
                try {
                    this.edtLoopImpl();
                    Object object = lock;
                    synchronized (object) {
                        lock.wait(this.framerateLock);
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            if (w.getErr() != null) {
                throw w.getErr();
            }
        } else {
            r.run();
        }
    }

    public boolean isTouchScreenDevice() {
        return this.touchScreen;
    }

    public void setTouchScreenDevice(boolean touchScreen) {
        this.touchScreen = touchScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrent(Form newForm, boolean reverse) {
        if (this.edt == null) {
            throw new IllegalStateException("Initialize must be invoked before setCurrent!");
        }
        if (this.isVirtualKeyboardShowingSupported()) {
            this.setShowVirtualKeyboard(false);
        }
        if (this.editingText) {
            switch (this.showDuringEdit) {
                case 3: {
                    break;
                }
                case 4: {
                    this.impl.saveTextEditingState();
                    break;
                }
                case 2: {
                    throw new IllegalStateException("Show during edit");
                }
                case 1: {
                    return;
                }
                case 5: {
                    this.impl.setCurrentForm(newForm);
                    return;
                }
            }
        }
        if (!this.isEdt()) {
            this.callSerially(new RunnableWrapper(newForm, null, reverse));
            return;
        }
        Form current = this.impl.getCurrentForm();
        if (current != null && current.isInitialized()) {
            current.deinitializeImpl();
        }
        if (!newForm.isInitialized()) {
            newForm.initComponentImpl();
        }
        if (newForm.getWidth() != this.getDisplayWidth() || newForm.getHeight() != this.getDisplayHeight()) {
            newForm.setShouldCalcPreferredSize(true);
            newForm.layoutContainer();
        }
        Object object = lock;
        synchronized (object) {
            Transition t;
            Object o;
            boolean transitionExists = false;
            if (this.animationQueue != null && this.animationQueue.size() > 0 && (o = this.animationQueue.lastElement()) instanceof Transition) {
                current = (Form)((Transition)o).getDestination();
                this.impl.setCurrentForm(current);
            }
            if (current != null) {
                if (current instanceof Dialog && ((Dialog)current).isMenu()) {
                    t = current.getTransitionOutAnimator();
                    if (t != null && ((Dialog)current).getPreviousForm() != null) {
                        this.initTransition(t.copy(false), current, ((Dialog)current).getPreviousForm());
                    }
                    current = ((Dialog)current).getPreviousForm();
                    this.impl.setCurrentForm(current);
                }
                if (newForm != current && (current != null && current.getTransitionOutAnimator() != null || newForm.getTransitionInAnimator() != null)) {
                    if (this.animationQueue == null) {
                        this.animationQueue = new Vector();
                    }
                    if (current != null && !(newForm instanceof Dialog)) {
                        t = current.getTransitionOutAnimator();
                        if (current != null && t != null) {
                            this.initTransition(t.copy(reverse), current, newForm);
                            transitionExists = true;
                        }
                    }
                    if (current != null && !(current instanceof Dialog) && (t = newForm.getTransitionInAnimator()) != null) {
                        this.initTransition(t.copy(reverse), current, newForm);
                        transitionExists = true;
                    }
                }
            }
            lock.notify();
            if (!transitionExists) {
                if (this.animationQueue == null || this.animationQueue.size() == 0) {
                    this.setCurrentForm(newForm);
                } else {
                    t = CommonTransitions.createEmpty();
                    this.initTransition(t, current, newForm);
                }
            }
        }
    }

    private void initTransition(Transition transition, Form source, Form dest) {
        dest.setVisible(true);
        transition.init(source, dest);
        this.animationQueue.addElement(transition);
        if (this.animationQueue.size() == 1) {
            transition.initTransition();
        }
    }

    void setCurrentForm(Form newForm) {
        Form current = this.impl.getCurrentForm();
        if (current != null) {
            current.setVisible(false);
        }
        current = newForm;
        this.impl.setCurrentForm(current);
        current.setVisible(true);
        this.impl.confirmControlView();
        int w = current.getWidth();
        int h = current.getHeight();
        if (this.isEdt() && (w != this.impl.getDisplayWidth() || h != this.impl.getDisplayHeight())) {
            current.setSize(new Dimension(this.impl.getDisplayWidth(), this.impl.getDisplayHeight()));
            current.setShouldCalcPreferredSize(true);
            current.layoutContainer();
        }
        this.lastKeyPressed = 0;
        this.repaint(current);
        newForm.onShowCompleted();
    }

    public void setFlashGraphicsBug(boolean flushGraphicsBug) {
    }

    public void setTransitionYield(int transitionD) {
        transitionDelay = transitionD;
    }

    public void editString(Component cmp, int maxSize, int constraint, String text) {
        this.editingText = true;
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        this.keyReleasedSinceEdit = false;
        this.lastKeyPressed = 0;
        this.impl.editString(cmp, maxSize, constraint, text);
        this.editingText = false;
    }

    public boolean minimizeApplication() {
        return this.getImplementation().minimizeApplication();
    }

    public boolean isMinimized() {
        return this.getImplementation().isMinimized();
    }

    public void restoreMinimizedApplication() {
        this.getImplementation().restoreMinimizedApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInputEvent(int[] ev) {
        Object object = lock;
        synchronized (object) {
            this.inputEvents.addElement(ev);
            lock.notify();
        }
    }

    private int[] createPointerEvent(int[] x, int[] y, int eventType) {
        if (x.length == 1) {
            return new int[]{eventType, x[0], y[0]};
        }
        int[] arr = new int[1 + x.length * 2];
        arr[0] = eventType;
        int arrayOffset = 1;
        for (int iter = 0; iter < x.length; ++iter) {
            arr[arrayOffset] = x[iter];
            arr[++arrayOffset] = y[iter];
            ++arrayOffset;
        }
        return arr;
    }

    private int[] createKeyEvent(int keyCode, boolean pressed) {
        if (pressed) {
            return new int[]{4, keyCode};
        }
        return new int[]{5, keyCode};
    }

    public void keyPressed(int keyCode) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createKeyEvent(keyCode, true));
        this.longPressCharged = this.keyRepeatCharged = keyCode >= 0 || this.getGameAction(keyCode) > 0;
        this.longKeyPressTime = System.currentTimeMillis();
        this.keyRepeatValue = keyCode;
        this.nextKeyRepeatEvent = System.currentTimeMillis() + (long)this.keyRepeatInitialIntervalTime;
        this.lastKeyPressed = keyCode;
    }

    public void keyReleased(int keyCode) {
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        if (!this.keyReleasedSinceEdit && keyCode != this.lastKeyPressed) {
            return;
        }
        this.keyReleasedSinceEdit = true;
        this.addInputEvent(this.createKeyEvent(keyCode, false));
    }

    void keyRepeatedInternal(int keyCode) {
    }

    public void pointerDragged(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.longPointerCharged = false;
        this.addInputEvent(this.createPointerEvent(x, y, 3));
    }

    public void pointerHover(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(x, y, 8));
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(x, y, 11));
    }

    public void pointerPressed(int[] x, int[] y) {
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.longPointerCharged = true;
        this.longKeyPressTime = System.currentTimeMillis();
        this.pointerX = x[0];
        this.pointerY = y[0];
        this.addInputEvent(this.createPointerEvent(x, y, 1));
    }

    public void pointerReleased(int[] x, int[] y) {
        this.longPointerCharged = false;
        if (this.impl.getCurrentForm() == null) {
            return;
        }
        this.addInputEvent(this.createPointerEvent(x, y, 2));
    }

    public void sizeChanged(int w, int h) {
        Form current = this.impl.getCurrentForm();
        if (current == null) {
            return;
        }
        if (w == current.getWidth() && h == current.getHeight()) {
            return;
        }
        this.addInputEvent(this.createSizeChangedEvent(w, h));
    }

    private int[] createSizeChangedEvent(int w, int h) {
        return new int[]{7, w, h};
    }

    public void hideNotify() {
        this.keyRepeatCharged = false;
        this.longPressCharged = false;
        this.longPointerCharged = false;
        this.addInputEvent(new int[]{9});
    }

    public void showNotify() {
        this.addInputEvent(new int[]{10});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldEDTSleepNoFormAnimation() {
        Object object = lock;
        synchronized (object) {
            return this.inputEvents.size() == 0 && this.hasNoSerialCallsPending() && (!this.keyRepeatCharged || !this.longPressCharged);
        }
    }

    private void updateDragSpeedStatus(int[] ev) {
        this.dragPathX[this.dragPathOffset] = this.pointerEvent(1, ev)[0];
        this.dragPathY[this.dragPathOffset] = this.pointerEvent(2, ev)[0];
        this.dragPathTime[this.dragPathOffset] = System.currentTimeMillis();
        if (this.dragPathLength < this.PATHLENGTH) {
            ++this.dragPathLength;
        }
        ++this.dragPathOffset;
        if (this.dragPathOffset >= this.PATHLENGTH) {
            this.dragPathOffset = 0;
        }
    }

    private void handleEvent(int[] ev) {
        Form f = this.getCurrentUpcomingForm(true);
        switch (ev[0]) {
            case 4: {
                f.keyPressed(ev[1]);
                break;
            }
            case 5: {
                f.keyReleased(ev[1]);
                break;
            }
            case 1: {
                f.pointerPressed(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 2: {
                f.pointerReleased(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 3: {
                this.updateDragSpeedStatus(ev);
                f.pointerDragged(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 8: {
                this.updateDragSpeedStatus(ev);
                f.pointerHover(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 11: {
                f.pointerHoverReleased(this.pointerEvent(1, ev), this.pointerEvent(2, ev));
                break;
            }
            case 7: {
                f.sizeChangedInternal(ev[1], ev[2]);
                break;
            }
            case 9: {
                f.hideNotify();
                break;
            }
            case 10: {
                f.showNotify();
            }
        }
    }

    private int[] pointerEvent(int off, int[] event) {
        int[] peX = new int[event.length / 2];
        int offset = 0;
        for (int iter = off; iter < event.length; iter += 2) {
            peX[offset] = event[iter];
            ++offset;
        }
        return peX;
    }

    boolean shouldEDTSleep() {
        boolean sleep = false;
        Form current = this.impl.getCurrentForm();
        sleep = this.isEdtPaused() || (current == null || !current.hasAnimations()) && (this.animationQueue == null || this.animationQueue.size() == 0) && this.inputEvents.size() == 0 && !this.impl.hasPendingPaints() && this.hasNoSerialCallsPending() && !this.keyRepeatCharged && !this.longPointerCharged;
        return sleep;
    }

    public synchronized void pauseEdt(boolean pause) {
        this.edtPaused = pause;
    }

    public synchronized boolean isEdtPaused() {
        return this.edtPaused;
    }

    Object getVideoControl(Object player) {
        return this.impl.getVideoControl(player);
    }

    Form getCurrentInternal() {
        return this.impl.getCurrentForm();
    }

    Form getCurrentUpcoming() {
        return this.getCurrentUpcomingForm(false);
    }

    private Form getCurrentUpcomingForm(boolean includeMenus) {
        Form upcoming = null;
        if (this.animationQueue != null) {
            int size = this.animationQueue.size();
            for (int iter = 0; iter < size; ++iter) {
                Object o = this.animationQueue.elementAt(iter);
                if (!(o instanceof Transition)) continue;
                upcoming = (Form)((Transition)o).getDestination();
            }
        }
        if (upcoming == null) {
            if (includeMenus) {
                Form f = this.impl.getCurrentForm();
                if (f instanceof Dialog && ((Dialog)f).isDisposed()) {
                    return this.getCurrent();
                }
                return f;
            }
            return this.getCurrent();
        }
        return upcoming;
    }

    public Form getCurrent() {
        Form current = this.impl.getCurrentForm();
        if (current != null && current instanceof Dialog && (((Dialog)current).isMenu() || ((Dialog)current).isDisposed())) {
            Form p = current.getPreviousForm();
            if (p != null) {
                return p;
            }
            int size = this.animationQueue.size();
            for (int iter = 0; iter < size; ++iter) {
                Object o = this.animationQueue.elementAt(iter);
                if (!(o instanceof Transition)) continue;
                return (Form)((Transition)o).getDestination();
            }
        }
        return current;
    }

    public int numAlphaLevels() {
        return this.impl.numAlphaLevels();
    }

    public int numColors() {
        return this.impl.numColors();
    }

    public boolean isLightMode() {
        return this.lightMode;
    }

    public void setLightMode(boolean lightMode) {
        this.lightMode = lightMode;
    }

    public int getDisplayWidth() {
        return this.impl.getDisplayWidth();
    }

    public int getDisplayHeight() {
        return this.impl.getDisplayHeight();
    }

    void repaint(Animation cmp) {
        this.impl.repaint(cmp);
    }

    public int getGameAction(int keyCode) {
        return this.impl.getGameAction(keyCode);
    }

    public int getKeyCode(int gameAction) {
        return this.impl.getKeyCode(gameAction);
    }

    public void setSoftkeyCodes(int left, int right, int clear, int back) {
    }

    public boolean isThirdSoftButton() {
        return this.thirdSoftButton;
    }

    public void setThirdSoftButton(boolean thirdSoftButton) {
        this.thirdSoftButton = thirdSoftButton;
    }

    public void setShowVirtualKeyboard(boolean show) {
        this.impl.setShowVirtualKeyboard(show);
    }

    public boolean isVirtualKeyboardShowing() {
        return this.impl.isVirtualKeyboardShowing();
    }

    public boolean isVirtualKeyboardShowingSupported() {
        return this.impl.isVirtualKeyboardShowingSupported();
    }

    public int getKeyboardType() {
        return this.impl.getKeyboardType();
    }

    public boolean isNativeInputSupported() {
        return false;
    }

    public boolean isMultiTouch() {
        return this.impl.isMultiTouch();
    }

    public boolean isClickTouchScreen() {
        return this.impl.isClickTouchScreen();
    }

    float getDragSpeed(boolean yAxis) {
        float speed = yAxis ? this.impl.getDragSpeed(this.dragPathY, this.dragPathTime, this.dragPathOffset, this.dragPathLength) : this.impl.getDragSpeed(this.dragPathX, this.dragPathTime, this.dragPathOffset, this.dragPathLength);
        this.dragPathLength = 0;
        return speed;
    }

    public boolean isBidiAlgorithm() {
        return this.impl.isBidiAlgorithm();
    }

    public void setBidiAlgorithm(boolean activate) {
        this.impl.setBidiAlgorithm(activate);
    }

    public String convertBidiLogicalToVisual(String s) {
        return this.impl.convertBidiLogicalToVisual(s);
    }

    public int getCharLocation(String source, int index) {
        return this.impl.getCharLocation(source, index);
    }

    public boolean isRTL(char c) {
        return this.impl.isRTL(c);
    }

    public InputStream getResourceAsStream(Class cls, String resource) {
        return this.impl.getResourceAsStream(cls, resource);
    }
}

