/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;

public class SudokuGardenMIDlet
extends MIDlet {
    private boolean first = true;
    private Display display = Display.getDisplay((MIDlet)this);
    public SudokuGardenMIDletCanvas canvas = new SudokuGardenMIDletCanvas(this);
    boolean bSessionUp = false;
    long lSessionStartTime = 0L;
    int iLastSessionGameTime = 0;
    int iThisSessionGameTime = 0;

    public SudokuGardenMIDlet() {
        this.checkTrialCount();
        this.lSessionStartTime = System.currentTimeMillis();
    }

    public void startApp() throws MIDletStateChangeException {
        if (this.canvas != null) {
            this.display.setCurrent((Displayable)this.canvas);
        }
    }

    public void pauseApp() {
    }

    public void exitApp() {
        try {
            int iTime = this.iLastSessionGameTime + this.iThisSessionGameTime;
            this.storeSessionData(iTime);
            this.destroyApp(true);
            this.notifyDestroyed();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroyApp(boolean u) {
    }

    public void loadApp() {
        this.loadUserData();
    }

    public void checkTrialCount() {
        try {
            RecordStore r = RecordStore.openRecordStore((String)"sudokutrial", (boolean)false);
            byte[] in = r.getRecord(1);
            r.closeRecordStore();
            if (in != null) {
                String dataStr = new String(in);
                int iSeconds = Integer.parseInt(dataStr);
                if (iSeconds >= 1800) {
                    this.bSessionUp = true;
                } else {
                    this.iLastSessionGameTime = iSeconds;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void storeSessionData(int seconds) {
        try {
            String dataStr = String.valueOf(seconds);
            byte[] out = dataStr.getBytes();
            RecordStore r = RecordStore.openRecordStore((String)"sudokutrial", (boolean)true);
            if (r.getNumRecords() == 0) {
                r.addRecord(out, 0, out.length);
            } else {
                r.setRecord(1, out, 0, out.length);
            }
            r.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean loadUserData() {
        try {
            RecordStore r = RecordStore.openRecordStore((String)"userdata", (boolean)false);
            byte[] in = r.getRecord(1);
            r.closeRecordStore();
            if (in == null) {
                return false;
            }
            String dataStr = new String(in);
            String sound = null;
            String style = null;
            String backgroundIndex = null;
            String totalWins = null;
            String difficulty = null;
            int currentIndex = 0;
            int nextIndex = 0;
            nextIndex = dataStr.indexOf(";", currentIndex);
            sound = dataStr.substring(currentIndex, nextIndex);
            currentIndex = nextIndex + 1;
            nextIndex = dataStr.indexOf(";", currentIndex);
            style = dataStr.substring(currentIndex, nextIndex);
            currentIndex = nextIndex + 1;
            nextIndex = dataStr.indexOf(";", currentIndex);
            backgroundIndex = dataStr.substring(currentIndex, nextIndex);
            currentIndex = nextIndex + 1;
            nextIndex = dataStr.indexOf(";", currentIndex);
            totalWins = dataStr.substring(currentIndex, nextIndex);
            currentIndex = nextIndex + 1;
            difficulty = dataStr.substring(currentIndex, dataStr.length());
            this.canvas.setUserData(Integer.parseInt(sound), Integer.parseInt(style), Integer.parseInt(backgroundIndex), Integer.parseInt(totalWins), Integer.parseInt(difficulty));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void storeUserData(int sound, int style, int backgroundIndex, int totalWins, int difficulty) {
        try {
            String dataStr = String.valueOf(sound) + ";" + String.valueOf(style) + ";" + String.valueOf(backgroundIndex) + ";" + String.valueOf(totalWins) + ";" + String.valueOf(difficulty);
            byte[] out = dataStr.getBytes();
            RecordStore r = RecordStore.openRecordStore((String)"userdata", (boolean)true);
            if (r.getNumRecords() == 0) {
                r.addRecord(out, 0, out.length);
            } else {
                r.setRecord(1, out, 0, out.length);
            }
            r.closeRecordStore();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean loadGameboardData(String gameboardName) {
        block8: {
            try {
                RecordStore r = RecordStore.openRecordStore((String)gameboardName, (boolean)false);
                byte[] in = r.getRecord(1);
                int[] board = new int[81];
                int[] solution = new int[81];
                r.closeRecordStore();
                if (in == null) {
                    return false;
                }
                String dataStr = new String(in);
                String boardStr = null;
                String solutionStr = null;
                String cutterStr = null;
                String number = null;
                String gametypeStr = null;
                String difficultyStr = null;
                int currentIndex = 0;
                int nextIndex = 0;
                nextIndex = dataStr.indexOf("=", currentIndex);
                boardStr = dataStr.substring(currentIndex, nextIndex);
                currentIndex = nextIndex + 1;
                nextIndex = dataStr.indexOf("=", currentIndex);
                solutionStr = dataStr.substring(currentIndex, nextIndex);
                currentIndex = nextIndex + 1;
                nextIndex = dataStr.indexOf("=", currentIndex);
                cutterStr = dataStr.substring(currentIndex, nextIndex);
                currentIndex = nextIndex + 1;
                nextIndex = dataStr.indexOf("=", currentIndex);
                difficultyStr = dataStr.substring(currentIndex, nextIndex);
                currentIndex = nextIndex + 1;
                gametypeStr = dataStr.substring(currentIndex, dataStr.length());
                currentIndex = 0;
                for (int i = 0; i < 81; ++i) {
                    nextIndex = dataStr.indexOf(";", currentIndex);
                    number = boardStr.substring(currentIndex, nextIndex);
                    currentIndex = nextIndex + 1;
                    board[i] = Integer.parseInt(String.valueOf(number));
                    solution[i] = Integer.parseInt(String.valueOf(solutionStr.charAt(i)));
                }
                if (board[0] != 99999) {
                    if (solution[0] != 99999) {
                        if (gameboardName.compareTo("gameboard") == 0) {
                            this.canvas.setGameboard(board, solution, Integer.parseInt(String.valueOf(cutterStr)), Integer.parseInt(String.valueOf(gametypeStr)), Integer.parseInt(String.valueOf(difficultyStr)));
                        } else {
                            this.canvas.setPuzzleboard(board, solution, Integer.parseInt(String.valueOf(cutterStr)), Integer.parseInt(String.valueOf(gametypeStr)), Integer.parseInt(String.valueOf(difficultyStr)));
                        }
                        break block8;
                    }
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public void storeGameboardData(String gameboardName, int[] board, int[] solution, int cutter, int gameType, int difficulty) {
        try {
            String dataStr = "";
            String solutionStr = "";
            for (int i = 0; i < 81; ++i) {
                dataStr = dataStr + String.valueOf(board[i]) + ";";
                solutionStr = solutionStr + String.valueOf(solution[i]);
            }
            dataStr = dataStr + "=" + solutionStr + "=" + cutter + "=" + difficulty + "=" + gameType;
            byte[] out = dataStr.getBytes();
            RecordStore r = RecordStore.openRecordStore((String)gameboardName, (boolean)true);
            if (r.getNumRecords() == 0) {
                r.addRecord(out, 0, out.length);
            } else {
                r.setRecord(1, out, 0, out.length);
            }
            r.closeRecordStore();
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

