/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;

public final class Game {
    public static final byte TYPE_ORIGINAL = 0;
    public static final byte TYPE_SYMBOL = 1;
    public static final byte MAX_COLS = 9;
    public static final byte MAX_ROWS = 9;
    public static final int NUM_CUTTERS = 9;
    public int[] gameboard;
    public int[] solutionBoard;
    public int cutterIndex;
    public boolean ready = false;
    private Random random;
    private Cell[][] regionContents;
    private Vector remainingCells;
    private int lastSort;
    private Cell[][] solveBoard;
    private int[] regions = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 2, 2, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 3, 3, 3, 4, 4, 4, 5, 5, 5, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 8, 6, 6, 6, 7, 7, 7, 8, 8, 8, 6, 6, 6, 7, 7, 7, 8, 8, 8};
    private int[] col_index = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1, 2, 3, 4, 5, 6, 7, 8};
    private int[] row_index = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private int[][] cutters = new int[][]{{0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0}, {1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1}, {0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0}, {1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1}, {1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1}, {1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1}, {1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1}, {1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1}, {0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0}};

    public Game(boolean createNewboard) {
        this.random = new Random(System.currentTimeMillis());
        this.gameboard = new int[81];
        this.solutionBoard = new int[81];
        if (createNewboard) {
            this.createPuzzle();
        }
        this.ready = true;
    }

    public void createPuzzle() {
        boolean puzzleSolved = false;
        int[][] newboard = new int[9][9];
        int j = 0;
        while (j < 9) {
            int i = Math.abs(this.random.nextInt() % 9);
            int k = Math.abs(this.random.nextInt() % 9);
            newboard[i][k] = j++;
        }
        this.solve(newboard);
        this.setupPuzzle(true);
        while (!puzzleSolved) {
            this.cutterIndex = Math.abs(this.random.nextInt() % 9);
            this.coverBoard(this.cutterIndex);
            for (int i = 0; i < 9; ++i) {
                for (int j2 = 0; j2 < 9; ++j2) {
                    newboard[i][j2] = this.gameboard[j2 + i * 9];
                }
            }
            puzzleSolved = this.solve(newboard);
            this.setupPuzzle(false);
        }
    }

    private void setupPuzzle(boolean copyGameBoard) {
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                this.solutionBoard[y + x * 9] = this.solveBoard[x][y].value;
                if (!copyGameBoard) continue;
                this.gameboard[y + x * 9] = this.solveBoard[x][y].value;
            }
        }
    }

    public boolean solveExternal(int[] extBoard) {
        int[][] newboard = new int[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                newboard[i][j] = extBoard[j + i * 9];
            }
        }
        boolean solved = this.solve(newboard);
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                this.solutionBoard[y + x * 9] = this.solveBoard[x][y].value;
                this.gameboard[y + x * 9] = this.solveBoard[x][y].value;
            }
        }
        return solved;
    }

    public void solve() {
        System.arraycopy(this.solutionBoard, 0, this.gameboard, 0, 81);
    }

    public void restart() {
        System.arraycopy(this.solutionBoard, 0, this.gameboard, 0, 81);
        this.coverBoard(this.cutterIndex);
    }

    public void coverBoard(int index) {
        for (int i = 0; i < 81; ++i) {
            if (this.cutters[index][i] != 0) continue;
            this.gameboard[i] = 0;
        }
    }

    public int getRegion(int boardPos) {
        return this.regions[boardPos];
    }

    public int getRow(int boardPos) {
        return this.row_index[boardPos];
    }

    public int getColumn(int boardPos) {
        return this.col_index[boardPos];
    }

    public boolean solve(int[][] initBoard) {
        int y;
        int x;
        this.solveBoard = new Cell[9][9];
        this.remainingCells = new Vector();
        this.regionContents = new Cell[9][9];
        int[] regionCount = new int[9];
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 9; ++y) {
                Cell c;
                this.solveBoard[x][y] = c = new Cell(x, y);
                int n = c.inRegion;
                int n2 = regionCount[n];
                regionCount[n] = n2 + 1;
                this.regionContents[c.inRegion][n2] = this.solveBoard[x][y];
            }
        }
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 9; ++y) {
                if (initBoard[x][y] > 0) {
                    this.solveBoard[x][y].setValue(initBoard[x][y], 100);
                    continue;
                }
                this.remainingCells.addElement(this.solveBoard[x][y]);
            }
        }
        this.sort(this.remainingCells);
        return this.backtrack(1);
    }

    public boolean backtrack(int level) {
        if (level > 256) {
            return false;
        }
        if (this.remainingCells.isEmpty()) {
            return true;
        }
        if (level == this.lastSort + 5 || level == this.lastSort - 5) {
            this.sort(this.remainingCells);
            this.lastSort = level;
        }
        Cell current = (Cell)this.remainingCells.elementAt(this.remainingCells.size() - 1);
        this.remainingCells.removeElementAt(this.remainingCells.size() - 1);
        for (int v = 1; v <= 9; ++v) {
            if (current.numOut[v] != 0) continue;
            if (current.setValue(v, level)) {
                current.eraseValue(level);
                continue;
            }
            if (this.backtrack(level + 1)) {
                return true;
            }
            current.eraseValue(level);
        }
        this.remainingCells.addElement(current);
        return false;
    }

    public void sort(Vector cells) {
        int i = cells.size();
        while (--i >= 0) {
            boolean flipped = false;
            for (int j = 0; j < i; ++j) {
                if (((Cell)cells.elementAt((int)(j + 1))).numOutCount <= ((Cell)cells.elementAt((int)j)).numOutCount) continue;
                Cell T = (Cell)cells.elementAt(j);
                cells.setElementAt(cells.elementAt(j + 1), j);
                cells.setElementAt(T, j + 1);
                flipped = true;
            }
            if (flipped) continue;
            return;
        }
    }

    public class Cell {
        private int x;
        private int y;
        public int inRegion;
        public int[] numOut;
        public int numOutCount;
        public int value;

        public Cell(int x, int y) {
            this.x = x;
            this.y = y;
            this.inRegion = 3 * (x / 3) + y / 3;
            this.numOutCount = 9;
            this.numOut = new int[10];
            this.value = 0;
        }

        private boolean excludeNum(int v, int level) {
            if (this.value == 0 && this.numOut[v] == 0) {
                this.numOut[v] = level;
                if (--this.numOutCount == 0) {
                    return true;
                }
            }
            return false;
        }

        private void includeNum(int v, int level) {
            if (this.numOut[v] == level) {
                this.numOut[v] = 0;
                ++this.numOutCount;
            }
        }

        public boolean setValue(int value, int level) {
            this.value = value;
            for (int i = 0; i < 9; ++i) {
                if (Game.this.solveBoard[this.x][i].excludeNum(value, level)) {
                    return true;
                }
                if (Game.this.solveBoard[i][this.y].excludeNum(value, level)) {
                    return true;
                }
                if (!Game.this.regionContents[this.inRegion][i].excludeNum(value, level)) continue;
                return true;
            }
            return false;
        }

        public void eraseValue(int level) {
            for (int i = 0; i < 9; ++i) {
                Game.this.solveBoard[this.x][i].includeNum(this.value, level);
                Game.this.solveBoard[i][this.y].includeNum(this.value, level);
                Game.this.regionContents[this.inRegion][i].includeNum(this.value, level);
            }
            this.value = 0;
        }
    }
}

