/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import javax.microedition.lcdui.Graphics;

public class Menu
extends Window {
    private int currentItem;
    private int currentValue;
    private int firstVisibleItem;
    private int lastVisibleItem;
    private int itemWindowWidth;
    private int itemWindowHeight;
    private int itemHeight;
    private MenuItem mi;
    private boolean disableSelection;
    private MenuConfig menuConfig;

    public Menu() {
        this.menuConfig = null;
        this.mi = null;
        this.currentItem = 0;
        this.currentValue = 0;
        this.itemWindowHeight = 0;
        this.itemWindowWidth = 0;
        this.itemHeight = 0;
        this.firstVisibleItem = 0;
        this.lastVisibleItem = 0;
        this.disableSelection = false;
    }

    public Menu(MenuConfig menuConfig) {
        this.setConfig(menuConfig);
    }

    public void setMenuConfig(MenuConfig menuConfig) {
        MFont font = null;
        int fontHeight = 0;
        this.setConfig(menuConfig);
        this.menuConfig = menuConfig;
        this.currentItem = 0;
        this.currentValue = 0;
        this.itemWindowHeight = menuConfig.height - (menuConfig.footer_Image != null ? menuConfig.footer_Image.getHeight() : 0) - 4;
        if (menuConfig.header_Image != null) {
            this.itemWindowHeight -= menuConfig.header_Image.getHeight();
        } else if (menuConfig.title != null && menuConfig.text_Font != null) {
            this.itemWindowHeight -= menuConfig.text_Font.getHeight();
        }
        this.itemWindowWidth = menuConfig.width - (menuConfig.selector_Image != null ? menuConfig.selector_Image.getWidth() : 0) - menuConfig.border.thickness * 5;
        for (int i = 0; i < menuConfig.items.length; ++i) {
            font = menuConfig.getItem((int)i).font;
            if (font.getHeight() <= fontHeight) continue;
            fontHeight = font.getHeight() + font.getLeading();
        }
        this.itemHeight = fontHeight + menuConfig.item_Offset;
        this.firstVisibleItem = 0;
        this.lastVisibleItem = menuConfig.items.length - 1;
    }

    public MenuConfig getMenuConfig() {
        return this.menuConfig;
    }

    public int getCurrentItemIdex() {
        return this.currentItem;
    }

    public void setCurrentItemIdex(int index) {
        this.currentItem = index;
    }

    public MenuItem getItem(int index) {
        return this.menuConfig.getItem(index);
    }

    public void setItem(int index, MenuItem item) {
        this.menuConfig.setItem(index, item);
    }

    public void disableSelectionState(boolean flag) {
        this.disableSelection = flag;
    }

    public void paintContent(Graphics g, int xItem, int yItem, int anchor) {
        int limit = yItem + this.itemWindowHeight;
        int itemLimit = yItem + this.menuConfig.numItemsVisible * this.itemHeight;
        for (int i = this.firstVisibleItem; i < this.menuConfig.items.length; ++i) {
            this.lastVisibleItem = i;
            if (!this.disableSelection) {
                if (this.menuConfig.selector_Image != null && this.currentItem == i) {
                    g.drawImage(this.menuConfig.selector_Image, xItem - this.menuConfig.rect_Thickness, yItem, anchor);
                }
                this.menuConfig.getItem(i).paint(xItem + (this.menuConfig.selector_Image != null ? this.menuConfig.selector_Image.getWidth() : 0), yItem, g, this.currentItem == i, this.menuConfig.rect_Color, this.menuConfig.rect_Thickness, this.menuConfig.border.corner_Arc, anchor);
            } else {
                this.menuConfig.getItem(i).paint(xItem + (this.menuConfig.selector_Image != null ? this.menuConfig.selector_Image.getWidth() : 0), yItem, g, false, this.menuConfig.rect_Color, this.menuConfig.rect_Thickness, this.menuConfig.border.corner_Arc, anchor);
            }
            if ((yItem += this.itemHeight) < limit && (this.menuConfig.numItemsVisible <= 0 || yItem < itemLimit)) continue;
            --this.lastVisibleItem;
            break;
        }
        if (this.lastVisibleItem - this.firstVisibleItem != this.menuConfig.items.length - 1) {
            if (this.lastVisibleItem < this.menuConfig.items.length - 1) {
                this.drawArrow(g, false);
            } else {
                this.drawArrow(g, true);
            }
        }
    }

    private void drawArrow(Graphics g, boolean up) {
        int x = this.menuConfig.xPos + this.menuConfig.width / 2;
        int y = this.menuConfig.yPos + this.menuConfig.height - 4 - this.menuConfig.border.thickness;
        g.setColor(0);
        if (up) {
            g.drawLine(x, y, x, y);
            g.drawLine(x - 1, y + 1, x + 1, y + 1);
            g.drawLine(x - 2, y + 2, x + 2, y + 2);
        } else {
            g.drawLine(x - 2, y, x + 2, y);
            g.drawLine(x - 1, y + 1, x + 1, y + 1);
            g.drawLine(x, y + 2, x, y + 2);
        }
    }

    public void keyPressed(int gameCode, int keyCode) {
        if (gameCode == 1) {
            if (this.currentItem == this.firstVisibleItem && this.firstVisibleItem > 0) {
                --this.firstVisibleItem;
            }
            if (--this.currentItem < 0) {
                if (this.lastVisibleItem == this.menuConfig.items.length - 1) {
                    this.currentItem = this.lastVisibleItem;
                } else {
                    this.firstVisibleItem = this.lastVisibleItem + 1;
                    this.currentItem = this.lastVisibleItem = this.menuConfig.items.length - 1;
                }
            }
            if (this.currentItem <= 0) {
                this.currentItem = 0;
            }
        } else if (gameCode == 6) {
            if (this.currentItem == this.lastVisibleItem && this.lastVisibleItem < this.menuConfig.items.length - 1) {
                ++this.firstVisibleItem;
            }
            if (++this.currentItem >= this.menuConfig.items.length) {
                this.firstVisibleItem = 0;
                this.currentItem = 0;
            }
            if (this.currentItem >= this.menuConfig.items.length) {
                this.currentItem = this.menuConfig.items.length - 1;
            }
        } else if (gameCode == 2) {
            this.mi = this.menuConfig.getItem(this.currentItem);
            this.currentValue = this.mi.getValueIndex();
            if (!this.mi.animateItem) {
                --this.currentValue;
                this.currentValue = this.currentValue < 0 ? this.mi.numValues - 1 : this.currentValue;
                this.mi.setValueIndex(this.currentValue);
            }
        } else if (gameCode == 5) {
            this.mi = this.menuConfig.getItem(this.currentItem);
            this.currentValue = this.mi.getValueIndex();
            if (!this.mi.animateItem) {
                ++this.currentValue;
                this.currentValue = this.currentValue >= this.mi.numValues ? 0 : this.currentValue;
                this.mi.setValueIndex(this.currentValue);
            }
        } else if (gameCode == 8 || keyCode == this.menuConfig.rightSoftKey) {
            this.mi = this.menuConfig.getItem(this.currentItem);
            this.currentValue = this.mi.getValueIndex();
            if (!this.mi.animateItem && !this.mi.fireSelect) {
                ++this.currentValue;
                this.currentValue = this.currentValue >= this.mi.numValues ? 0 : this.currentValue;
                this.mi.setValueIndex(this.currentValue);
            }
        }
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            WindowEventNotification listener = (WindowEventNotification)e.nextElement();
            listener.windowEvent(keyCode, this.mi.index);
        }
    }
}

