/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class Window {
    private Config windowConfig;
    protected Vector listeners;

    public Window() {
        this.windowConfig = null;
        this.listeners = new Vector();
    }

    public Window(Config windowConfig) {
        this.setConfig(windowConfig);
    }

    public void setConfig(Config config) {
        this.windowConfig = config;
    }

    public Config getConfig() {
        return this.windowConfig;
    }

    public void paint(Graphics g, int anchor) {
        if (this.windowConfig != null && this.windowConfig.show) {
            int cWidth = g.getClipWidth();
            int cHeight = g.getClipHeight();
            int xItem = this.windowConfig.item_xPos + this.windowConfig.xPos + (this.windowConfig.border.vertical_Top_Image != null ? this.windowConfig.border.vertical_Top_Image.getWidth() : 3);
            int yItem = this.windowConfig.item_yPos + this.windowConfig.yPos + (this.windowConfig.border.horizontal_Top_Image != null ? this.windowConfig.border.horizontal_Top_Image.getHeight() : 3);
            int bgWidth = this.windowConfig.background_Image != null ? this.windowConfig.background_Image.getWidth() : 0;
            int bgHeight = this.windowConfig.background_Image != null ? this.windowConfig.background_Image.getHeight() : 0;
            g.setClip(this.windowConfig.xPos + this.windowConfig.border.thickness, this.windowConfig.yPos + this.windowConfig.border.thickness, this.windowConfig.width - this.windowConfig.border.thickness * 2, this.windowConfig.height - this.windowConfig.border.thickness * 2);
            if (this.windowConfig.background_Image != null) {
                g.setColor(this.windowConfig.bkColor);
                g.fillRect(this.windowConfig.xPos, this.windowConfig.yPos, this.windowConfig.width, this.windowConfig.height);
                if (this.windowConfig.background_Image.getWidth() > this.windowConfig.width / 2 && this.windowConfig.background_Image.getHeight() > this.windowConfig.height / 2) {
                    g.drawImage(this.windowConfig.background_Image, this.windowConfig.xPos, this.windowConfig.yPos, anchor);
                } else {
                    int numHorizontalTiles = (this.windowConfig.width / bgWidth + 2) * bgWidth;
                    int numVerticalTiles = (this.windowConfig.height / bgHeight + 2) * bgHeight;
                    for (int i = 0; i < numHorizontalTiles; i += bgWidth) {
                        for (int j = 0; j < numVerticalTiles; j += bgHeight) {
                            g.drawImage(this.windowConfig.background_Image, i + this.windowConfig.xPos, j + this.windowConfig.yPos, anchor);
                        }
                    }
                }
            } else if (this.windowConfig.background_Color >= 0) {
                g.setColor(this.windowConfig.background_Color);
                g.fillRect(this.windowConfig.xPos, this.windowConfig.yPos, this.windowConfig.width, this.windowConfig.height);
            }
            if (this.windowConfig.header_Image != null) {
                g.drawImage(this.windowConfig.header_Image, this.windowConfig.xPos + this.windowConfig.width / 2 - this.windowConfig.header_Image.getWidth() / 2, this.windowConfig.yPos, anchor);
                yItem += this.windowConfig.header_Image.getHeight() + 4;
            } else if (this.windowConfig.title != null && this.windowConfig.text_Font != null) {
                int titleWidth = this.windowConfig.text_Font.stringWidth(this.windowConfig.title);
                this.windowConfig.text_Font.drawString(g, this.windowConfig.title, this.windowConfig.xPos + this.windowConfig.width / 2 - titleWidth / 2, this.windowConfig.yPos + 6, 20);
                this.windowConfig.text_Font.drawString(g, this.windowConfig.title, this.windowConfig.xPos + this.windowConfig.width / 2 - titleWidth / 2 + 1, this.windowConfig.yPos + 6, 20);
                yItem += this.windowConfig.text_Font.getHeight() * 2;
            }
            this.paintContent(g, xItem, yItem, anchor);
            if (this.windowConfig.footer_Image != null) {
                g.drawImage(this.windowConfig.footer_Image, this.windowConfig.xPos, this.windowConfig.height - this.windowConfig.footer_Image.getHeight(), anchor);
            }
            if (this.windowConfig.border.thickness > 0) {
                if (this.windowConfig.border.horizontal_Top_Image != null && this.windowConfig.border.vertical_Top_Image != null && this.windowConfig.border.horizontal_Bottom_Image != null && this.windowConfig.border.vertical_Bottom_Image != null) {
                    int hWidth = this.windowConfig.border.horizontal_Top_Image.getWidth();
                    int hHeight = this.windowConfig.border.horizontal_Top_Image.getHeight();
                    int vWidth = this.windowConfig.border.vertical_Top_Image.getWidth();
                    int vHeight = this.windowConfig.border.vertical_Top_Image.getHeight();
                    g.setClip(this.windowConfig.xPos + hWidth, this.windowConfig.yPos, this.windowConfig.width - hWidth * 2, this.windowConfig.height);
                    for (int i = this.windowConfig.xPos; i < this.windowConfig.width + this.windowConfig.xPos; i += hWidth) {
                        g.drawImage(this.windowConfig.border.horizontal_Top_Image, i, this.windowConfig.yPos, 20);
                        g.drawImage(this.windowConfig.border.horizontal_Bottom_Image, i, this.windowConfig.height + this.windowConfig.yPos - hHeight, 20);
                    }
                    g.setClip(this.windowConfig.xPos, this.windowConfig.yPos + vHeight, this.windowConfig.width, this.windowConfig.height - vHeight * 2);
                    for (int j = this.windowConfig.yPos; j < this.windowConfig.height + this.windowConfig.yPos; j += vHeight) {
                        g.drawImage(this.windowConfig.border.vertical_Top_Image, this.windowConfig.xPos, j, 20);
                        g.drawImage(this.windowConfig.border.vertical_Bottom_Image, this.windowConfig.width + this.windowConfig.xPos - vWidth, j, 20);
                    }
                } else {
                    g.setClip(this.windowConfig.xPos, this.windowConfig.yPos, this.windowConfig.width, this.windowConfig.height);
                    g.setColor(this.windowConfig.border.color);
                    for (int i = 1; i <= this.windowConfig.border.thickness; ++i) {
                        g.drawRoundRect(this.windowConfig.xPos + i, this.windowConfig.yPos + i, this.windowConfig.width - i * 2 - 1, this.windowConfig.height - i * 2 - 1, this.windowConfig.border.corner_Arc, this.windowConfig.border.corner_Arc);
                    }
                }
                g.setClip(0, 0, cWidth, cHeight);
            }
            if (this.windowConfig.border.topLeft_Corner_Image != null) {
                g.drawImage(this.windowConfig.border.topLeft_Corner_Image, this.windowConfig.xPos, this.windowConfig.yPos, 20);
            }
            if (this.windowConfig.border.bottomLeft_Corner_Image != null) {
                g.drawImage(this.windowConfig.border.bottomLeft_Corner_Image, this.windowConfig.xPos, this.windowConfig.height + this.windowConfig.yPos - this.windowConfig.border.bottomRight_Corner_Image.getHeight(), 20);
            }
            if (this.windowConfig.border.topRight_Corner_Image != null) {
                g.drawImage(this.windowConfig.border.topRight_Corner_Image, this.windowConfig.width + this.windowConfig.xPos - this.windowConfig.border.bottomRight_Corner_Image.getWidth(), this.windowConfig.yPos, 20);
            }
            if (this.windowConfig.border.bottomRight_Corner_Image != null) {
                g.drawImage(this.windowConfig.border.bottomRight_Corner_Image, this.windowConfig.width + this.windowConfig.xPos - this.windowConfig.border.bottomRight_Corner_Image.getWidth(), this.windowConfig.height + this.windowConfig.yPos - this.windowConfig.border.bottomRight_Corner_Image.getHeight(), 20);
            }
            if (this.windowConfig.border.tail_Image != null) {
                g.drawImage(this.windowConfig.border.tail_Image, this.windowConfig.width / 2 + this.windowConfig.xPos, this.windowConfig.height + this.windowConfig.yPos - (this.windowConfig.border.horizontal_Top_Image != null ? this.windowConfig.border.horizontal_Top_Image.getHeight() : 0), 20);
            }
        }
    }

    public void paintContent(Graphics g, int x, int y, int anchor) {
    }

    public void addListener(WindowEventNotification listener) {
        this.listeners.addElement(listener);
    }

    public void removeListener(WindowEventNotification listener) {
        this.listeners.removeElement(listener);
    }

    public void removeAllListners() {
        this.listeners.removeAllElements();
    }
}

