






    





    



/*
 * Border.java
 * Created on Nov 2, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import javax.microedition.lcdui.*;

/**
 * A Border is a responsible for displaying the border around a Component.
 *
 * @author glewis
 */
public class Border 
{
   public static final int 
   PLAIN       = 0x00,
   DIMENSIONAL = 0x02,
   BEVELED     = 0x06,
   ETCHED      = 0x0A,
   LOWERED     = 0x10,
   RAISED      = 0x20,
   INSETS      = 0x40;

   public static final Border 
   NULL_BORDER      = new Border(PLAIN,0,0,0,0),
                      RAISED_BORDER_1  = new Border(BEVELED | RAISED, 1),
                                         RAISED_BORDER_2  = new Border(BEVELED | RAISED, 2),
                                                            LOWERED_BORDER_1 = new Border(BEVELED | LOWERED, 1),
                                                                               LOWERED_BORDER_2 = new Border(BEVELED | LOWERED, 2);

   public byte 
   left, top, right, bottom, thickness, outerThickness, innerThickness;

   public short style;
   public int 
   color, outerTopColor, innerTopColor, innerBottomColor, outerBottomColor;

   public static Border newInsets(int left, int right, int top, int bottom) 
   {
      Border b = new Border(INSETS, 0, 0);
      b.left   = (byte)left;
      b.right  = (byte)right;
      b.top    = (byte)top;
      b.bottom = (byte)bottom;
      return b;
   }

   public Border(int style, int thickness, int color) 
   {
      this(style, thickness, color, 0, 0);        
   }

   public Border(int style, int thickness) 
   {
      this(style, thickness, Component.COMPONENT_COLOR, Component.HIGHLIGHT, Component.SHADOW);        
   }

   public Border(int style, int thickness, int color, int highlightColor, int shadowColor) 
   {
      this.style = (short)style;
      this.color = color;
      this.thickness = left = right = top = bottom = (byte)thickness;

      if ((style & DIMENSIONAL) != 0)
      {
         if ((style & RAISED) != 0)
         {
            outerTopColor = highlightColor;
            outerBottomColor = shadowColor;
         }
         else
         {
            outerTopColor = shadowColor;
            outerBottomColor = highlightColor;
         }

         if ((style & BEVELED) == BEVELED)
         {
            innerTopColor = outerTopColor;
            innerBottomColor = outerBottomColor;
            outerThickness = (byte)thickness;
         }
         else
         {
            innerTopColor = outerBottomColor;
            innerBottomColor = outerTopColor;
            innerThickness = outerThickness = (byte)((thickness+1)/3);
         }
      }
   }

   public void paint(Component c, Graphics g) 
   {
      int h = c.h;
      int w = c.w;
      for (int i=outerThickness; --i>=0;)
      {
         c.setColor(g, outerTopColor);            
         g.drawLine(i, i, w-i-1, i); // top
         g.drawLine(w-1-i, i+1, w-1-i, h-2-i); // right
         c.setColor(g, outerBottomColor);            
         g.drawLine(i, h-1-i, w-1-i, h-1-i); // bottom
         g.drawLine(i, i+1, i, h-i-2); // left
      }                

      for (int i=innerThickness; --i>=0;)
      {
         c.setColor(g, innerTopColor);            
         g.drawLine(thickness-i-1, top-i-1, w-thickness+i, top-i-1); // top
         g.drawLine(w-thickness+i, top-i, w-thickness+i, h-thickness+i); // right 
         c.setColor(g, innerBottomColor);            
         g.drawLine(thickness-i-1, h-thickness+i, w-thickness+i-1, h-thickness+i); // bottom
         g.drawLine(thickness-i-1,top-i,thickness-i-1,h-thickness+i-1); // left
      }

      if ((style & INSETS) != 0)
      {
         if (c.bgColor != Component.TRANSPARENT)
         {
            c.setColor(g, Component.COMPONENT_COLOR);            
            g.fillRect(0,0,left,h);
            g.fillRect(w-right, 0, right, h);
            g.fillRect(left, 0, w-left-right, top);
            g.fillRect(left, h-bottom, w-left-right, bottom);
         }
      }
      else if (color != Component.TRANSPARENT)
      {
         c.setColor(g, color);            
         for (int i=thickness-innerThickness; --i>=outerThickness;)
            g.drawRect(i, i, w-2*i-1, h-2*i-1);
      }
   }
}
