






    





    



/*
 * BufferedInStream.java
 * Created Jul 8, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.io.*;

/**
 * An InputStream that buffers the data from another InputStream.
 *
 * @author glewis
 */
public class BufferedInStream extends InputStream {
   public InputStream in;
   public byte[] buffer;
   public int first;
   public int last;
   public long remaining;

   /** Creates new BufferedInStream */
   public BufferedInStream(InputStream in, long length, byte[] buffer) {
      this.in = in;
      this.remaining = length;
      this.buffer = buffer;
   }

   public int read() throws IOException {
      if (first < last) {
         return buffer[first++];
      }
      last = 0;
      first = 0;
      if (remaining < 0) {
         throw new EOFException();
      }
      else if (remaining == 0) {
         remaining = -1;
         return -1;
      }
      int numToRead = buffer.length;
      if (numToRead >= remaining) {
         numToRead = (int)remaining;            
      }
      last = in.read(buffer, 0, numToRead);
      if (last <= 0) {
         last = 0;
         remaining = -1;
         return -1;
      }
      remaining -= last;
      first = 1;
      return buffer[0] & 0xFF;
   }

   public int available() {
      return last - first;
   }

   public void close() throws IOException {
      in.close();
      remaining = -2;
      first = 0;
      last = 0;
      buffer = null;
   }

   public int read(byte[] b, int off, int len) throws IOException {
      if (len == 0) {
         return 0;
      }
      else if ((len < 0) || (off < 0) || (off + len > b.length)) {
         throw new IllegalArgumentException();
      }
      int firstRead = read();
      if (firstRead < 0) {
         return -1;
      }
      b[off] = (byte)firstRead;
      int numToRead = last - first;
      if (numToRead >= len) {
         numToRead = len-1;
      }
      if (numToRead > 0) {
         System.arraycopy(buffer, first, b, off+1, numToRead);
         first += numToRead;
      }
      return numToRead+1;
   }
}
