






    





    



/*
 * Properties.java
 * Created on May 3, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.util.*;
import java.io.*;

/**
 * @author glewis
 */
public class Properties extends Hashtable {
   protected Properties defaults;

   public Properties() {
      this(null);
   } 

   public Properties(Properties defaults) {
      this.defaults = defaults; 
   }

   public String getProperty(String key) {     
      String prop = (String)get(key);
      if ((prop == null) && (defaults != null)) {
         prop = defaults.getProperty(key);
      }
      return prop;
   }

   public String getProperty(String key, String defaultValue) {
      String prop = getProperty(key);
      if (prop == null) {
         prop = defaultValue;
      }
      return prop;
   }

   public Object setProperty(String key, String value) { 
      return put(key, value);
   }

   public Enumeration propertyNames() {
      if (defaults == null) {
         return keys();
      }
      CompositeEnumeration enum = new CompositeEnumeration();
      for (Properties props = this; props != null; props = props.defaults) {
         enum.append(props.keys());
      }
      return enum;
   }

   public void load(InputStream inStream) throws IOException { 
      load(new InputStreamReader(inStream));
   }

   public void list(PrintStream out) {
      try {
         store(out, null);
      }
      catch (IOException e) {
         ;
      }
   }

   public void list(Writer out) {
      try {
         store(out, null); 
      }
      catch (IOException e) {
         ;
      }
   }

   public void save(OutputStream out, String header) { 
      try {
         store(out, header);
      }
      catch (IOException e) {
         ;
      }
   }

   public void store(OutputStream out, String header) throws IOException {
      store(new OutputStreamWriter(out), header);
   }

   private static final int READ_LINE = 0;
   private static final int READ_KEY = 1;
   private static final int READING_KEY = 2;
   private static final int READING_COMMENT = 3;
   private static final int READ_SEPARATOR = 4;
   private static final int READ_VALUE = 5;
   private static final int READING_VALUE = 6;

   private static final int TYPE_WHITESPACE = 0;
   private static final int TYPE_SEPARATOR = 1;
   private static final int TYPE_EOL = 2;
   private static final int TYPE_CHAR = 3;

   private void load(Reader reader) throws IOException {
      StringBuffer sBuf = new StringBuffer();
      String key = null;
      int mode = READ_LINE;
      boolean escape = false;
      int c = 0;
      while (c != -1) {
         c = reader.read();
         int type = TYPE_CHAR;
         if (mode == READING_COMMENT) {
            if (c == -1) {
               break;
            }
            else if (c == '\n') {
               mode = READ_LINE;
               continue;
            }
         }
         if (escape) {
            escape = false;
            switch (c) {
               case '\n':
                  escape = false;
                  continue;
               case -1:
                  type = TYPE_EOL;
                  break;
               case 'n':
                  c = '\n';
                  break;
               case 'r':
                  c = '\r';
                  break;
               case 't':
                  c = '\t';
                  break;
               case 'f':
                  c = '\f';
                  break;
            }
         }
         else if (c == '\\') {
            escape = true;
            continue; 
         }
         else {
            switch (c) {
               case -1:
               case '\n':
                  type = TYPE_EOL;
                  break;
               case ':':
               case '=':
                  type = TYPE_SEPARATOR;
               default:
                  if (c <= 0x20) {
                     type = TYPE_WHITESPACE;
                  }
            }
         }
         switch (mode) {
            case READ_LINE:
               if ((c == '#') || (c == '!')) {
                  mode = READING_COMMENT;
                  continue;
               }
               mode = READ_KEY;
               // intentionally fall through
            case READ_KEY:
               if ((type == TYPE_WHITESPACE) || (type == TYPE_EOL)) {
                  continue;
               }
               mode = READING_KEY;
               // intentionally fall through
            case READING_KEY:
               if (type == TYPE_CHAR) {
                  sBuf.append((char)c);
                  continue;
               }
               else {
                  key = sBuf.toString().trim();
                  sBuf.setLength(0);
                  mode = READ_SEPARATOR;
               }
               // intentionally fall through
            case READ_SEPARATOR:
               switch (type) {
                  case TYPE_SEPARATOR:
                     mode = READ_VALUE;
                     continue;
                  case TYPE_EOL:
                     mode = READ_VALUE;
                     break;
               }
               // intentionally fall through
            case READ_VALUE:
               if (type == TYPE_WHITESPACE) {
                  continue;
               }
               mode = READING_VALUE;
               // intentionally fall through
            case READING_VALUE:
               if (type == TYPE_EOL) {
                  String val = sBuf.toString().trim();
                  put(key, val);
                  sBuf.setLength(0);
                  mode = READ_LINE;
               }
               else {
                  sBuf.append((char)c);
               }
         }
      }
   }

   private void store(Writer writer, String header) throws IOException {
      if (header != null) {
         writer.write('#');
         writer.write(header);
         writer.write('\n');
      }
      for (Enumeration enum = keys(); enum.hasMoreElements();) {
         Object key = enum.nextElement();
         writer.write(key.toString());
         writer.write('=');
         writer.write(get(key).toString());
         writer.write('\n');
      }
      writer.flush();
   }
}
