






    





    



/*
 * WOFData.java
 * Created on May 20, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.io.*;

/**
 * An OutputStream that writes all data written to it to two other 
 * OutputStreams.
 *
 * @author glewis
 */
public class Splitter extends OutputStream {
   private OutputStream o1;
   private OutputStream o2;
   private boolean close1;
   private boolean close2;

   /** 
    * Creates a new Splitter that will write to o1 and o2.
    * close1 and close2 indicate whether or not the corresponding OutputStreams
    * should be closed when this Splitter is closed.
    */
   public Splitter(OutputStream o1, OutputStream o2, 
                   boolean close1, boolean close2) {
      this.o1 = o1;
      this.o2 = o2;
      this.close1 = close1;
      this.close2 = close2;
   }

   /** closes this Splitter. The two OutputStreams associated with this
    * Splitter may also be closed, depending on the arguments passed to this
    * Splitter's constructor.
    */
   public void close() throws IOException {
      try {
         if (close1) {
            o1.close();
         }
         if (close2) {
            o2.close();
         }
         o1 = null;
         o2 = null;
      }
      catch (NullPointerException e) {
         ;
         throw new IOException();
      }
   }

   /** flushes both of this Splitter's OutputStreams. */
   public void flush() throws IOException {
      o1.flush();
      o2.flush();
   }

   public void write(byte[] b) throws IOException {
      o1.write(b, 0, b.length);
      o2.write(b, 0, b.length);
   }

   public void write(byte[] b, int off, int len) throws IOException {
      o1.write(b, off, len);
      o2.write(b, off, len);
   }

   public void write(int b) throws IOException {
      o1.write(b);
      o2.write(b);
   }
}
