






    





    



/*
 * StringUtils.java
 * Created on May 13, 2004
 * 
 * Copyright Zaxis Technologies, Inc. 2004
 * 10401 Roselle Street, Suite A202
 * San Diego, CA 92121
 * USA
 * 858-623-0666
 *
 * The copyright to the computer program(s) 
 * is the property of Zaxis Technologies, Inc. 2004.
 * The program(s) may be used and/or copied only with
 * the written permission of Zaxis Technologies, Inc.
 * or in accordance with the terms and conditions
 * stipulated in the agreement/contract under which
 * the program(s) have been supplied.
 */

import java.io.*;

/**
 * A collection of utility functions for Strings, StringBuffers, 
 * characters, and arrays of characters.
 *
 * @author glewis
 */
public class StringUtils {
   private static Object lock = new Object();
   private static char[] buf = new char[256];

   /** 
    * performs a case-independent comparison between s1 and s2 and
    * returns a positive number if s1 is before s2, a negative number if
    * s2 is before s1, and zero if the two are identical. Null values
    * are equivalent to an empty string.
    */
   public static int compare(StringBuffer s1, StringBuffer s2) {
      int len1 = 0;
      int len2 = 0;
      if (s1 != null) {
         len1 = s1.length();
      }
      if (s2 != null) {
         len2 = s2.length();
      }
      int len = (len1 > len2) ? len2 : len1;
      for (int i=0; i<len; i++) {
         char c1 = Character.toUpperCase(s1.charAt(i));
         char c2 = Character.toUpperCase(s2.charAt(i));
         int result = c1 - c2;
         if (result != 0) {
            return result;
         }
      }
      return(len1 - len2);
   }

   /** 
    * performs a case-independent comparison between s1 and s2 and
    * returns a positive number if s1 is before s2, a negative number if
    * s2 is before s1, and zero if the two are identical. Null values
    * are equivalent to an empty string.
    */
   public static int compare(StringBuffer s1, String s2) {
      int len1 = 0;
      int len2 = 0;
      if (s1 != null) {
         len1 = s1.length();
      }
      if (s2 != null) {
         len2 = s2.length();
      }
      int len = (len1 > len2) ? len2 : len1;
      for (int i=0; i<len; i++) {
         char c1 = Character.toUpperCase(s1.charAt(i));
         char c2 = Character.toUpperCase(s2.charAt(i));
         int result = c1 - c2;
         if (result != 0) {
            return result;
         }
      }
      return(len1 - len2);
   }

   /** 
    * performs a case-independent comparison between s1 and s2 and
    * returns a positive number if s1 is before s2, a negative number if
    * s2 is before s1, and zero if the two are identical. Null values
    * are equivalent to an empty string.
    */
   public static int compare(String s1, String s2) {
      int len1 = 0;
      int len2 = 0;
      if (s1 != null) {
         len1 = s1.length();
      }
      if (s2 != null) {
         len2 = s2.length();
      }
      int len = (len1 > len2) ? len2 : len1;
      for (int i=0; i<len; i++) {
         char c1 = Character.toUpperCase(s1.charAt(i));
         char c2 = Character.toUpperCase(s2.charAt(i));
         int result = c1 - c2;
         if (result != 0) {
            return result;
         }
      }
      return(len1 - len2);
   }

   /** 
    * appends value to sBuf in the designated base. If value has fewer digits
    * than indicated by the digits argument, zeros will be inserted before
    * the value to make up the designated number of digits. If value has more
    * digits than indicated by the digits argument, however, the whole value
    * will be appended.
    */
   public static void append(StringBuffer sBuf,int value,int digits,int base) {
      int len = sBuf.length();
      while ((--digits >= 0) || (value > 0)) {
         int dig = value % base;
         if (dig < 0) {
            dig = -dig;
         }
         if (dig > 9) {
            dig += 'A' - '0' - 10;
         }
         sBuf.insert(len, (char)(dig+'0'));
         value /= base;
      }
   }

   /** appends s to sBuf. */
   public static StringBuffer append(StringBuffer sBuf, StringBuffer s) {
      if (s == null) {
         return null;
      }
      synchronized (lock) {
         int len = s.length();
         buf = testSize(buf, len);
         s.getChars(0, len, buf, 0);
         return sBuf.append(buf, 0, len);
      }
   }

   /** 
    * returns a new StringBuffer that contains the characters in s, starting
    * with index start and continuing up to, but not including, end.
    */
   public static StringBuffer substring(StringBuffer s, int start, int end){
      synchronized (lock) {
         StringBuffer sBuf = new StringBuffer();
         int len = end-start;
         if (len > 0) {
            buf = testSize(buf, len);
            s.getChars(start, end, buf, 0);
            sBuf.append(buf, 0, len);
         }
         return sBuf;
      }            
   }

   /** 
    * writes s to out substituting "&lt;" for "<", "&gt;" for ">", and "&amp;"
    * for "&". This is used for writing XML data.
    */
   public static void write(StringBuffer s, Writer out) 
   throws IOException {
      synchronized (lock) {
         int len = s.length();
         buf = testSize(buf, len);
         s.getChars(0, len, buf, 0);
         int start = 0;
         String str = null;
         for (int i=0; i<len; i++) {
            switch (buf[i]) {
               case '<':
                  str = "&lt;";
                  break;
               case '>':
                  str = "&gt;";
                  break;
               case '&':      
                  str = "&amp;";
                  break;
               default :
                  continue;
            }
            out.write(buf, start, i-start);
            out.write(str);
            start = i+1;
         }
         out.write(buf, start, len-start);
      }
   }

   /** 
    * reads a long decimal value from s and returns it, or zero if s
    * does not represent a decimal value. 
    */
   public static long parseLong(StringBuffer s) {
      long val = 0;
      if (s != null) {
         int len = s.length();
         for (int i=0; i<len; i++) {
            char c = s.charAt(i);
            if ((c >= '0') && (c <= '9')) {
               val *= 10;
               val += (c-'0');
            }
            else {
               return 0;
            }
         }
      }
      return val;
   }

   /** writes s to out in an encoded form. */
   public static void writeEncoded(StringBuffer s, DataOutputStream out) 
   throws IOException {
      synchronized (lock) {
         int len = s.length();
         out.writeInt(len);
         buf = testSize(buf, len);
         s.getChars(0, len, buf, 0);
         for (int i=0; i<len; i++) {
            out.write(buf[i]);
         }
      }
   }

   /** 
    * reads a String from in, as encoded by writeEncoded, and appends it to s.
    */
   public static StringBuffer readEncoded(StringBuffer s, DataInputStream in) 
   throws IOException {
      int len = in.readInt();
      while (--len>=0) {
         s.append((char)in.read());
      }
      return s;
   }

   /** returns a clone of s. */
   public static StringBuffer copy(StringBuffer s) {
      StringBuffer c = new StringBuffer();
      append(c, s);
      return c;
   }

   /** returns true if c is a whitespace character. */
   public static boolean isWhiteSpace(int c) {
      return((c == ' ') || (c == '\t') || (c == '\n') || (c == '\r'));
   }

   /** removes leading and trailing whitespace from s. */
   public static StringBuffer trim(StringBuffer s) {
      int len = s.length();
      int i = len;
      while (--i>=0) {
         if (!isWhiteSpace(s.charAt(i))) {
            break;
         }
      }
      s.delete(i+1, len);
      len = i+1;
      i = -1;
      while (++i<len) {
         if (!isWhiteSpace(s.charAt(i))) {
            break;
         }
      }
      s.delete(0, i);
      return s;
   }

   /** 
    * checks that buffer is non-null and of at least size length.
    * If it is, then it is returned. Otherwise, a new buffer is created that
    * is at least that size, all data from buffer is transferred to this new
    * buffer, and it is returned.
    */
   public static byte[] testSize(byte[] buffer, int length) {
      if (buffer == null) {
         if (length < 0) {
            length = 0;
         }
         return new byte[length];
      }
      else if (buffer.length < length) {            
         byte[] replace = new byte[length + (buffer.length/2)];
         System.arraycopy(buffer, 0, replace, 0, buffer.length);
         return replace;
      }
      else {
         return buffer;
      }
   }

   /** 
    * checks that buffer is non-null and of at least size length.
    * If it is, then it is returned. Otherwise, a new buffer is created that
    * is at least that size, all data from buffer is transferred to this new
    * buffer, and it is returned.
    */
   public static char[] testSize(char[] buffer, int length) {
      if (buffer == null) {
         if (length < 0) {
            length = 0;
         }
         return new char[length];
      }
      else if (buffer.length < length) {            
         char[] replace = new char[length + (buffer.length/2)];
         System.arraycopy(buffer, 0, replace, 0, buffer.length);
         return replace;
      }
      else {
         return buffer;
      }
   }    
}
